/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ByteBufferInputStreamTest
extends ZKTestCase {
    private static final byte[] DATA_BYTES_0 = "Apache ZooKeeper".getBytes(StandardCharsets.UTF_8);
    private static byte[] DATA_BYTES;
    private ByteBuffer bb;
    private ByteBufferInputStream in;
    private byte[] bs;

    @BeforeClass
    public static void setUpClass() {
        int len = DATA_BYTES_0.length + 2;
        DATA_BYTES = new byte[len];
        System.arraycopy(DATA_BYTES_0, 0, DATA_BYTES, 0, DATA_BYTES_0.length);
        ByteBufferInputStreamTest.DATA_BYTES[len - 2] = 0;
        ByteBufferInputStreamTest.DATA_BYTES[len - 1] = -1;
    }

    @Before
    public void setUp() throws Exception {
        this.bb = ByteBuffer.wrap(DATA_BYTES);
        this.in = new ByteBufferInputStream(this.bb);
        this.bs = new byte[]{1, 2, 3, 4};
    }

    @Test
    public void testRead() throws Exception {
        for (int i = 0; i < DATA_BYTES.length; ++i) {
            int b = this.in.read();
            Assert.assertEquals((long)DATA_BYTES[i], (long)((byte)b));
        }
        Assert.assertEquals((long)-1L, (long)this.in.read());
    }

    @Test
    public void testReadArrayOffsetLength() throws Exception {
        Assert.assertEquals((long)1L, (long)this.in.read(this.bs, 2, 1));
        byte[] expected = new byte[]{1, 2, DATA_BYTES[0], 4};
        Assert.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testReadArrayOffsetLength_LengthTooLarge() throws Exception {
        this.in.read(this.bs, 2, 3);
    }

    @Test
    public void testReadArrayOffsetLength_HitEndOfStream() throws Exception {
        for (int i = 0; i < DATA_BYTES.length - 1; ++i) {
            this.in.read();
        }
        Assert.assertEquals((long)1L, (long)this.in.read(this.bs, 2, 2));
        byte[] expected = new byte[]{1, 2, DATA_BYTES[DATA_BYTES.length - 1], 4};
        Assert.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testReadArrayOffsetLength_AtEndOfStream() throws Exception {
        for (int i = 0; i < DATA_BYTES.length; ++i) {
            this.in.read();
        }
        byte[] expected = Arrays.copyOf(this.bs, this.bs.length);
        Assert.assertEquals((long)-1L, (long)this.in.read(this.bs, 2, 2));
        Assert.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testReadArrayOffsetLength_0Length() throws Exception {
        byte[] expected = Arrays.copyOf(this.bs, this.bs.length);
        Assert.assertEquals((long)0L, (long)this.in.read(this.bs, 2, 0));
        Assert.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testReadArray() throws Exception {
        byte[] expected = Arrays.copyOf(DATA_BYTES, 4);
        Assert.assertEquals((long)4L, (long)this.in.read(this.bs));
        Assert.assertArrayEquals((byte[])expected, (byte[])this.bs);
    }

    @Test
    public void testSkip() throws Exception {
        this.in.read();
        Assert.assertEquals((long)2L, (long)this.in.skip(2L));
        Assert.assertEquals((long)DATA_BYTES[3], (long)this.in.read());
        Assert.assertEquals((long)DATA_BYTES[4], (long)this.in.read());
    }

    @Test
    public void testSkip2() throws Exception {
        for (int i = 0; i < DATA_BYTES.length / 2; ++i) {
            this.in.read();
        }
        long skipAmount = DATA_BYTES.length / 4;
        Assert.assertEquals((long)skipAmount, (long)this.in.skip(skipAmount));
        int idx = DATA_BYTES.length / 2 + (int)skipAmount;
        Assert.assertEquals((long)DATA_BYTES[idx++], (long)this.in.read());
        Assert.assertEquals((long)DATA_BYTES[idx++], (long)this.in.read());
    }

    @Test
    public void testNegativeSkip() throws Exception {
        this.in.read();
        Assert.assertEquals((long)0L, (long)this.in.skip(-2L));
        Assert.assertEquals((long)DATA_BYTES[1], (long)this.in.read());
        Assert.assertEquals((long)DATA_BYTES[2], (long)this.in.read());
    }

    @Test
    public void testSkip_HitEnd() throws Exception {
        for (int i = 0; i < DATA_BYTES.length - 1; ++i) {
            this.in.read();
        }
        Assert.assertEquals((long)1L, (long)this.in.skip(2L));
        Assert.assertEquals((long)-1L, (long)this.in.read());
    }

    @Test
    public void testSkip_AtEnd() throws Exception {
        for (int i = 0; i < DATA_BYTES.length; ++i) {
            this.in.read();
        }
        Assert.assertEquals((long)0L, (long)this.in.skip(2L));
        Assert.assertEquals((long)-1L, (long)this.in.read());
    }

    @Test
    public void testAvailable() throws Exception {
        for (int i = DATA_BYTES.length; i > 0; --i) {
            Assert.assertEquals((long)i, (long)this.in.available());
            this.in.read();
        }
        Assert.assertEquals((long)0L, (long)this.in.available());
    }
}

