/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LocalPeerBeanTest {
    @Test
    public void testClientAddress() throws Exception {
        QuorumPeer quorumPeer = new QuorumPeer();
        LocalPeerBean remotePeerBean = new LocalPeerBean(quorumPeer);
        String result = remotePeerBean.getClientAddress();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.length());
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        int clientPort = PortAssignment.unique();
        InetSocketAddress address = new InetSocketAddress(clientPort);
        cnxnFactory.configure(address, 5, -1, false);
        quorumPeer.setCnxnFactory(cnxnFactory);
        result = remotePeerBean.getClientAddress();
        String ipv4 = "0.0.0.0:" + clientPort;
        String ipv6 = "[0:0:0:0:0:0:0:0]:" + clientPort;
        Assert.assertTrue((result.equals(ipv4) || result.equals(ipv6) ? 1 : 0) != 0);
        cnxnFactory.shutdown();
        clientPort = PortAssignment.unique();
        InetAddress clientIP = InetAddress.getLoopbackAddress();
        address = new InetSocketAddress(clientIP, clientPort);
        cnxnFactory = ServerCnxnFactory.createFactory();
        cnxnFactory.configure(address, 5, -1, false);
        quorumPeer.setCnxnFactory(cnxnFactory);
        result = remotePeerBean.getClientAddress();
        String expectedResult = clientIP.getHostAddress() + ":" + clientPort;
        Assert.assertEquals((Object)expectedResult, (Object)result);
        cnxnFactory.shutdown();
    }

    @Test
    public void testLocalPeerIsLeader() throws Exception {
        long localPeerId = 7L;
        QuorumPeer peer = (QuorumPeer)Mockito.mock(QuorumPeer.class);
        Mockito.when((Object)peer.getId()).thenReturn((Object)localPeerId);
        Mockito.when((Object)peer.isLeader(ArgumentMatchers.eq((long)localPeerId))).thenReturn((Object)true);
        LocalPeerBean localPeerBean = new LocalPeerBean(peer);
        Assert.assertTrue((boolean)localPeerBean.isLeader());
    }

    @Test
    public void testLocalPeerIsNotLeader() throws Exception {
        long localPeerId = 7L;
        QuorumPeer peer = (QuorumPeer)Mockito.mock(QuorumPeer.class);
        Mockito.when((Object)peer.getId()).thenReturn((Object)localPeerId);
        Mockito.when((Object)peer.isLeader(ArgumentMatchers.eq((long)localPeerId))).thenReturn((Object)false);
        LocalPeerBean localPeerBean = new LocalPeerBean(peer);
        Assert.assertFalse((boolean)localPeerBean.isLeader());
    }
}

