/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.common.BaseX509ParameterizedTestCase;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.common.X509KeyType;
import org.apache.zookeeper.common.X509TestContext;
import org.apache.zookeeper.common.X509Util;
import org.apache.zookeeper.server.quorum.UnifiedServerSocket;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnifiedServerSocketTest
extends BaseX509ParameterizedTestCase {
    private static final int MAX_RETRIES = 5;
    private static final int TIMEOUT = 1000;
    private static final byte[] DATA_TO_CLIENT = "hello client".getBytes();
    private static final byte[] DATA_FROM_CLIENT = "hello server".getBytes();
    private X509Util x509Util;
    private InetSocketAddress localServerAddress;
    private final Object handshakeCompletedLock = new Object();
    private boolean handshakeCompleted = false;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int paramIndex = 0;
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (Boolean hostnameVerification : new Boolean[]{true, false}) {
                    result.add(new Object[]{caKeyType, certKeyType, hostnameVerification, paramIndex++});
                }
            }
        }
        return result;
    }

    public UnifiedServerSocketTest(X509KeyType caKeyType, X509KeyType certKeyType, Boolean hostnameVerification, Integer paramIndex) {
        super(paramIndex, () -> {
            try {
                return X509TestContext.newBuilder().setTempDir(tempDir).setKeyStoreKeyType(certKeyType).setTrustStoreKeyType(caKeyType).setHostnameVerification(hostnameVerification).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        this.localServerAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), PortAssignment.unique());
        this.x509Util = new ClientX509Util();
        this.x509TestContext.setSystemProperties(this.x509Util, KeyStoreFileType.JKS, KeyStoreFileType.JKS);
    }

    @After
    public void tearDown() throws Exception {
        this.x509TestContext.clearSystemProperties(this.x509Util);
        this.x509Util.close();
    }

    private static void forceClose(Socket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void forceClose(ServerSocket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private SSLSocket connectWithSSL() throws IOException, X509Exception, InterruptedException {
        SSLSocket sslSocket = null;
        for (int retries = 0; retries < 5; ++retries) {
            try {
                sslSocket = this.x509Util.createSSLSocket();
                sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        Object object = UnifiedServerSocketTest.this.handshakeCompletedLock;
                        synchronized (object) {
                            UnifiedServerSocketTest.this.handshakeCompleted = true;
                            UnifiedServerSocketTest.this.handshakeCompletedLock.notifyAll();
                        }
                    }
                });
                sslSocket.setSoTimeout(1000);
                sslSocket.connect(this.localServerAddress, 1000);
                break;
            }
            catch (ConnectException connectException) {
                connectException.printStackTrace();
                UnifiedServerSocketTest.forceClose(sslSocket);
                sslSocket = null;
                Thread.sleep(1000L);
                continue;
            }
        }
        Assert.assertNotNull((String)"Failed to connect to server with SSL", sslSocket);
        return sslSocket;
    }

    private Socket connectWithoutSSL() throws IOException, InterruptedException {
        Socket socket = null;
        for (int retries = 0; retries < 5; ++retries) {
            try {
                socket = new Socket();
                socket.setSoTimeout(1000);
                socket.connect(this.localServerAddress, 1000);
                break;
            }
            catch (ConnectException connectException) {
                connectException.printStackTrace();
                UnifiedServerSocketTest.forceClose(socket);
                socket = null;
                Thread.sleep(1000L);
                continue;
            }
        }
        Assert.assertNotNull((String)"Failed to connect to server without SSL", socket);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithSSLToNonStrictServer() throws Exception {
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, true, DATA_TO_CLIENT);
        serverThread.start();
        SSLSocket sslSocket = this.connectWithSSL();
        try {
            sslSocket.getOutputStream().write(DATA_FROM_CLIENT);
            sslSocket.getOutputStream().flush();
            byte[] buf = new byte[DATA_TO_CLIENT.length];
            int bytesRead = sslSocket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Object object = this.handshakeCompletedLock;
            synchronized (object) {
                if (!this.handshakeCompleted) {
                    this.handshakeCompletedLock.wait(1000L);
                }
                Assert.assertTrue((boolean)this.handshakeCompleted);
            }
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(0));
        }
        finally {
            UnifiedServerSocketTest.forceClose(sslSocket);
            serverThread.shutdown(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithSSLToStrictServer() throws Exception {
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, false, DATA_TO_CLIENT);
        serverThread.start();
        SSLSocket sslSocket = this.connectWithSSL();
        try {
            sslSocket.getOutputStream().write(DATA_FROM_CLIENT);
            sslSocket.getOutputStream().flush();
            byte[] buf = new byte[DATA_TO_CLIENT.length];
            int bytesRead = sslSocket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Object object = this.handshakeCompletedLock;
            synchronized (object) {
                if (!this.handshakeCompleted) {
                    this.handshakeCompletedLock.wait(1000L);
                }
                Assert.assertTrue((boolean)this.handshakeCompleted);
            }
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(0));
        }
        finally {
            UnifiedServerSocketTest.forceClose(sslSocket);
            serverThread.shutdown(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithoutSSLToNonStrictServer() throws Exception {
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, true, DATA_TO_CLIENT);
        serverThread.start();
        Socket socket = this.connectWithoutSSL();
        try {
            socket.getOutputStream().write(DATA_FROM_CLIENT);
            socket.getOutputStream().flush();
            byte[] buf = new byte[DATA_TO_CLIENT.length];
            int bytesRead = socket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(0));
        }
        finally {
            UnifiedServerSocketTest.forceClose(socket);
            serverThread.shutdown(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithoutSSLToNonStrictServerPartialWrite() throws Exception {
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, true, DATA_TO_CLIENT);
        serverThread.start();
        Socket socket = this.connectWithoutSSL();
        try {
            socket.getOutputStream().write(DATA_FROM_CLIENT, 0, 2);
            socket.getOutputStream().flush();
            Thread.sleep(500L);
            socket.getOutputStream().write(DATA_FROM_CLIENT, 2, DATA_FROM_CLIENT.length - 2);
            socket.getOutputStream().flush();
            byte[] buf = new byte[DATA_TO_CLIENT.length];
            int bytesRead = socket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(0));
        }
        finally {
            UnifiedServerSocketTest.forceClose(socket);
            serverThread.shutdown(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithoutSSLToStrictServer() throws Exception {
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, false, DATA_TO_CLIENT);
        serverThread.start();
        Socket socket = this.connectWithoutSSL();
        socket.getOutputStream().write(DATA_FROM_CLIENT);
        socket.getOutputStream().flush();
        byte[] buf = new byte[DATA_TO_CLIENT.length];
        try {
            int bytesRead = socket.getInputStream().read(buf, 0, buf.length);
            if (bytesRead == -1) {
                return;
            }
        }
        catch (SocketException e) {
            return;
        }
        finally {
            UnifiedServerSocketTest.forceClose(socket);
            serverThread.shutdown(1000L);
            Assert.assertFalse((String)"The strict server accepted connection without SSL.", (boolean)serverThread.receivedAnyDataFromClient());
        }
        Assert.fail((String)"Expected server to hang up the connection. Read from server succeeded unexpectedly.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTLSDetectionNonBlockingNonStrictServerIdleClient() throws Exception {
        Socket badClientSocket = null;
        Socket clientSocket = null;
        SSLSocket secureClientSocket = null;
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, true, DATA_TO_CLIENT);
        serverThread.start();
        try {
            badClientSocket = this.connectWithoutSSL();
            clientSocket = this.connectWithoutSSL();
            clientSocket.getOutputStream().write(DATA_FROM_CLIENT);
            clientSocket.getOutputStream().flush();
            byte[] buf = new byte[DATA_TO_CLIENT.length];
            int bytesRead = clientSocket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(0));
            Object object = this.handshakeCompletedLock;
            synchronized (object) {
                Assert.assertFalse((boolean)this.handshakeCompleted);
            }
            secureClientSocket = this.connectWithSSL();
            secureClientSocket.getOutputStream().write(DATA_FROM_CLIENT);
            secureClientSocket.getOutputStream().flush();
            buf = new byte[DATA_TO_CLIENT.length];
            bytesRead = secureClientSocket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(1));
            object = this.handshakeCompletedLock;
            synchronized (object) {
                if (!this.handshakeCompleted) {
                    this.handshakeCompletedLock.wait(1000L);
                }
                Assert.assertTrue((boolean)this.handshakeCompleted);
            }
        }
        catch (Throwable throwable) {
            UnifiedServerSocketTest.forceClose(badClientSocket);
            UnifiedServerSocketTest.forceClose(clientSocket);
            UnifiedServerSocketTest.forceClose(secureClientSocket);
            serverThread.shutdown(1000L);
            throw throwable;
        }
        UnifiedServerSocketTest.forceClose(badClientSocket);
        UnifiedServerSocketTest.forceClose(clientSocket);
        UnifiedServerSocketTest.forceClose(secureClientSocket);
        serverThread.shutdown(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTLSDetectionNonBlockingStrictServerIdleClient() throws Exception {
        Socket badClientSocket = null;
        SSLSocket secureClientSocket = null;
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, false, DATA_TO_CLIENT);
        serverThread.start();
        try {
            badClientSocket = this.connectWithoutSSL();
            secureClientSocket = this.connectWithSSL();
            secureClientSocket.getOutputStream().write(DATA_FROM_CLIENT);
            secureClientSocket.getOutputStream().flush();
            byte[] buf = new byte[DATA_TO_CLIENT.length];
            int bytesRead = secureClientSocket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Object object = this.handshakeCompletedLock;
            synchronized (object) {
                if (!this.handshakeCompleted) {
                    this.handshakeCompletedLock.wait(1000L);
                }
                Assert.assertTrue((boolean)this.handshakeCompleted);
            }
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(0));
        }
        finally {
            UnifiedServerSocketTest.forceClose(badClientSocket);
            UnifiedServerSocketTest.forceClose(secureClientSocket);
            serverThread.shutdown(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTLSDetectionNonBlockingNonStrictServerDisconnectedClient() throws Exception {
        Socket clientSocket = null;
        SSLSocket secureClientSocket = null;
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, true, DATA_TO_CLIENT);
        serverThread.start();
        try {
            Socket badClientSocket = this.connectWithoutSSL();
            UnifiedServerSocketTest.forceClose(badClientSocket);
            clientSocket = this.connectWithoutSSL();
            clientSocket.getOutputStream().write(DATA_FROM_CLIENT);
            clientSocket.getOutputStream().flush();
            byte[] buf = new byte[DATA_TO_CLIENT.length];
            int bytesRead = clientSocket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(0));
            Object object = this.handshakeCompletedLock;
            synchronized (object) {
                Assert.assertFalse((boolean)this.handshakeCompleted);
            }
            secureClientSocket = this.connectWithSSL();
            secureClientSocket.getOutputStream().write(DATA_FROM_CLIENT);
            secureClientSocket.getOutputStream().flush();
            buf = new byte[DATA_TO_CLIENT.length];
            bytesRead = secureClientSocket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(1));
            object = this.handshakeCompletedLock;
            synchronized (object) {
                if (!this.handshakeCompleted) {
                    this.handshakeCompletedLock.wait(1000L);
                }
                Assert.assertTrue((boolean)this.handshakeCompleted);
            }
        }
        catch (Throwable throwable) {
            UnifiedServerSocketTest.forceClose(clientSocket);
            UnifiedServerSocketTest.forceClose(secureClientSocket);
            serverThread.shutdown(1000L);
            throw throwable;
        }
        UnifiedServerSocketTest.forceClose(clientSocket);
        UnifiedServerSocketTest.forceClose(secureClientSocket);
        serverThread.shutdown(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTLSDetectionNonBlockingStrictServerDisconnectedClient() throws Exception {
        SSLSocket secureClientSocket = null;
        UnifiedServerThread serverThread = new UnifiedServerThread(this.x509Util, this.localServerAddress, false, DATA_TO_CLIENT);
        serverThread.start();
        try {
            Socket badClientSocket = this.connectWithoutSSL();
            UnifiedServerSocketTest.forceClose(badClientSocket);
            secureClientSocket = this.connectWithSSL();
            secureClientSocket.getOutputStream().write(DATA_FROM_CLIENT);
            secureClientSocket.getOutputStream().flush();
            byte[] buf = new byte[DATA_TO_CLIENT.length];
            int bytesRead = secureClientSocket.getInputStream().read(buf, 0, buf.length);
            Assert.assertEquals((long)buf.length, (long)bytesRead);
            Assert.assertArrayEquals((byte[])DATA_TO_CLIENT, (byte[])buf);
            Object object = this.handshakeCompletedLock;
            synchronized (object) {
                if (!this.handshakeCompleted) {
                    this.handshakeCompletedLock.wait(1000L);
                }
                Assert.assertTrue((boolean)this.handshakeCompleted);
            }
            Assert.assertArrayEquals((byte[])DATA_FROM_CLIENT, (byte[])serverThread.getDataFromClient(0));
        }
        catch (Throwable throwable) {
            UnifiedServerSocketTest.forceClose(secureClientSocket);
            serverThread.shutdown(1000L);
            throw throwable;
        }
        UnifiedServerSocketTest.forceClose(secureClientSocket);
        serverThread.shutdown(1000L);
    }

    private static final class UnifiedServerThread
    extends Thread {
        private final byte[] dataToClient;
        private List<byte[]> dataFromClients;
        private ExecutorService workerPool;
        private UnifiedServerSocket serverSocket;

        UnifiedServerThread(X509Util x509Util, InetSocketAddress bindAddress, boolean allowInsecureConnection, byte[] dataToClient) throws IOException {
            this.dataToClient = dataToClient;
            this.dataFromClients = new ArrayList<byte[]>();
            this.workerPool = Executors.newCachedThreadPool();
            this.serverSocket = new UnifiedServerSocket(x509Util, allowInsecureConnection);
            this.serverSocket.bind((SocketAddress)bindAddress);
        }

        @Override
        public void run() {
            try {
                try {
                    Random rnd = new Random();
                    while (true) {
                        final Socket unifiedSocket = this.serverSocket.accept();
                        final boolean tcpNoDelay = rnd.nextBoolean();
                        unifiedSocket.setTcpNoDelay(tcpNoDelay);
                        unifiedSocket.setSoTimeout(1000);
                        final boolean keepAlive = rnd.nextBoolean();
                        unifiedSocket.setKeepAlive(keepAlive);
                        BufferedInputStream bis = new BufferedInputStream(unifiedSocket.getInputStream());
                        this.workerPool.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    byte[] buf = new byte[1024];
                                    int bytesRead = unifiedSocket.getInputStream().read(buf, 0, 1024);
                                    Assert.assertEquals((Object)tcpNoDelay, (Object)unifiedSocket.getTcpNoDelay());
                                    Assert.assertEquals((long)1000L, (long)unifiedSocket.getSoTimeout());
                                    Assert.assertEquals((Object)keepAlive, (Object)unifiedSocket.getKeepAlive());
                                    if (bytesRead > 0) {
                                        byte[] dataFromClient = new byte[bytesRead];
                                        System.arraycopy(buf, 0, dataFromClient, 0, bytesRead);
                                        List list = dataFromClients;
                                        synchronized (list) {
                                            dataFromClients.add(dataFromClient);
                                        }
                                    }
                                    unifiedSocket.getOutputStream().write(dataToClient);
                                    unifiedSocket.getOutputStream().flush();
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                                finally {
                                    UnifiedServerSocketTest.forceClose(unifiedSocket);
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                UnifiedServerSocketTest.forceClose((ServerSocket)this.serverSocket);
                this.workerPool.shutdown();
                throw throwable;
            }
        }

        public void shutdown(long millis) throws InterruptedException {
            UnifiedServerSocketTest.forceClose((ServerSocket)this.serverSocket);
            this.workerPool.awaitTermination(millis, TimeUnit.MILLISECONDS);
            this.join(millis);
        }

        synchronized byte[] getDataFromClient(int index) {
            return this.dataFromClients.get(index);
        }

        synchronized boolean receivedAnyDataFromClient() {
            return !this.dataFromClients.isEmpty();
        }
    }
}

