/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLCountTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ACLCountTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();

    @Test
    public void testAclCount() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        ArrayList<ACL> CREATOR_ALL_AND_WORLD_READABLE = new ArrayList<ACL>(){
            {
                this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
                this.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
                this.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
            }
        };
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);
            zk.addAuthInfo("digest", "pat:test".getBytes());
            zk.setACL("/", (List)ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            String path = "/path";
            try {
                Assert.assertEquals((long)4L, (long)CREATOR_ALL_AND_WORLD_READABLE.size());
            }
            catch (Exception e) {
                LOG.error("Something is fundamentally wrong with ArrayList's add() method. add()ing four times to an empty ArrayList should result in an ArrayList with 4 members.");
                throw e;
            }
            zk.create(path, path.getBytes(), (List)CREATOR_ALL_AND_WORLD_READABLE, CreateMode.PERSISTENT);
            List acls = zk.getACL("/path", new Stat());
            Assert.assertEquals((long)2L, (long)acls.size());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
        f.shutdown();
        zks.shutdown();
    }
}

