/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumRestartTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumRestartTest.class);
    private QuorumUtil qu;

    @Before
    public void setUp() throws Exception {
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        this.qu = new QuorumUtil(1, 2);
        this.qu.startAll();
    }

    @Test
    public void testRollingRestart() throws Exception {
        for (int serverToRestart = 1; serverToRestart <= 3; ++serverToRestart) {
            LOG.info("***** restarting: " + serverToRestart);
            this.qu.shutdown(serverToRestart);
            Assert.assertTrue((String)String.format("Timeout during waiting for server %d to go down", serverToRestart), (boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.qu.getPeer((int)serverToRestart).clientPort, ClientBase.CONNECTION_TIMEOUT));
            this.qu.restart(serverToRestart);
            String errorMessage = "Not all the quorum members are connected after restarting server " + serverToRestart;
            this.waitFor(errorMessage, () -> this.qu.allPeersAreConnected(), 30);
            LOG.info("***** Restart {} succeeded", (Object)serverToRestart);
        }
    }

    @Test
    public void testRollingRestartBackwards() throws Exception {
        for (int serverToRestart = 3; serverToRestart >= 1; --serverToRestart) {
            LOG.info("***** restarting: " + serverToRestart);
            this.qu.shutdown(serverToRestart);
            Assert.assertTrue((String)String.format("Timeout during waiting for server %d to go down", serverToRestart), (boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.qu.getPeer((int)serverToRestart).clientPort, ClientBase.CONNECTION_TIMEOUT));
            this.qu.restart(serverToRestart);
            String errorMessage = "Not all the quorum members are connected after restarting server " + serverToRestart;
            this.waitFor(errorMessage, () -> this.qu.allPeersAreConnected(), 30);
            LOG.info("***** Restart {} succeeded", (Object)serverToRestart);
        }
    }

    @Test
    public void testRestartingLeaderMultipleTimes() throws Exception {
        for (int restartCount = 1; restartCount <= 3; ++restartCount) {
            int leaderId = this.qu.getLeaderServer();
            LOG.info("***** new leader: " + leaderId);
            this.qu.shutdown(leaderId);
            Assert.assertTrue((String)"Timeout during waiting for current leader to go down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.qu.getPeer((int)leaderId).clientPort, ClientBase.CONNECTION_TIMEOUT));
            String errorMessage = "No new leader was elected";
            this.waitFor(errorMessage, () -> this.qu.leaderExists() && this.qu.getLeaderServer() != leaderId, 30);
            this.qu.restart(leaderId);
            errorMessage = "Not all the quorum members are connected after restarting the old leader";
            this.waitFor(errorMessage, () -> this.qu.allPeersAreConnected(), 30);
            LOG.info("***** Leader Restart {} succeeded", (Object)restartCount);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.qu.shutdownAll();
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.serverCnxnFactory");
    }
}

