/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.alts.FailingClientCall;
import javax.annotation.Nullable;

final class CallCredentialsInterceptor
implements ClientInterceptor {
    @Nullable
    private final CallCredentials credentials;
    private final Status status;

    public CallCredentialsInterceptor(@Nullable CallCredentials credentials, Status status) {
        this.credentials = credentials;
        this.status = status;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (!this.status.isOk()) {
            return new FailingClientCall(this.status);
        }
        return next.newCall(method, callOptions.withCallCredentials(this.credentials));
    }
}

