/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.EdsLoadBalancer2;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public class EdsLoadBalancerProvider
extends LoadBalancerProvider {
    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "eds_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new EdsLoadBalancer2(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        throw new UnsupportedOperationException("not supported as top-level LB policy");
    }

    static final class EdsConfig {
        final String clusterName;
        @Nullable
        final String edsServiceName;
        @Nullable
        final String lrsServerName;
        final ServiceConfigUtil.PolicySelection localityPickingPolicy;
        final ServiceConfigUtil.PolicySelection endpointPickingPolicy;

        EdsConfig(String clusterName, @Nullable String edsServiceName, @Nullable String lrsServerName, ServiceConfigUtil.PolicySelection localityPickingPolicy, ServiceConfigUtil.PolicySelection endpointPickingPolicy) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
            this.localityPickingPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)localityPickingPolicy, (Object)"localityPickingPolicy");
            this.endpointPickingPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)endpointPickingPolicy, (Object)"endpointPickingPolicy");
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerName", (Object)this.lrsServerName).add("localityPickingPolicy", (Object)this.localityPickingPolicy).add("endpointPickingPolicy", (Object)this.endpointPickingPolicy).toString();
        }
    }
}

