/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.controller;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.controller.ControlCommand;
import org.apache.zookeeper.server.controller.ControllerTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerControllerEndToEndTest
extends ControllerTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerControllerEndToEndTest.class);
    private ZooKeeper zkClient;
    private static final String AnyPath = "/Any";
    private static final byte[] AnyData = new byte[]{0, 1};

    @Override
    @After
    public void cleanup() throws InterruptedException {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        super.cleanup();
    }

    private void initClient(Watcher watcher) throws IOException {
        this.zkClient = new ZooKeeper("localhost:" + this.config.getClientPortAddress().getPort(), 10000, watcher);
    }

    @Test
    public void verifyClientConnects() throws Exception {
        BlockingStateWatcher watcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(watcher);
        watcher.waitForEvent();
    }

    @Test
    public void verifyClientDisconnectsAndReconnects() throws Exception {
        BlockingStateWatcher watcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(watcher);
        watcher.waitForEvent();
        watcher.reset(new Watcher.Event.KeeperState[]{Watcher.Event.KeeperState.Disconnected, Watcher.Event.KeeperState.SyncConnected});
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.CLOSECONNECTION, String.valueOf(this.zkClient.getSessionId())));
        watcher.waitForEvent();
    }

    @Test
    public void verifySessionExpiration() throws Exception {
        BlockingStateWatcher watcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(watcher);
        watcher.waitForEvent();
        watcher.reset(new Watcher.Event.KeeperState[]{Watcher.Event.KeeperState.Disconnected, Watcher.Event.KeeperState.Expired});
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.EXPIRESESSION, String.valueOf(this.zkClient.getSessionId())));
        watcher.waitForEvent();
    }

    @Test
    public void verifyGlobalSessionExpiration() throws Exception {
        BlockingStateWatcher stateWatcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(stateWatcher);
        stateWatcher.waitForEvent();
        BlockingPathWatcher pathWatcher = new BlockingPathWatcher(AnyPath, Watcher.Event.EventType.NodeCreated);
        this.zkClient.exists(AnyPath, (Watcher)pathWatcher);
        Assert.assertEquals((Object)AnyPath, (Object)this.zkClient.create(AnyPath, AnyData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL));
        pathWatcher.waitForEvent();
        stateWatcher.reset(Watcher.Event.KeeperState.Expired);
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.EXPIRESESSION));
        stateWatcher.waitForEvent();
    }

    @Ignore
    public void verifyRejectAcceptSessions() throws Exception {
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.REJECTCONNECTIONS));
        BlockingStateWatcher watcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(watcher);
        try {
            watcher.waitForEvent(100);
            Assert.fail((String)"should have failed connecting");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.RESET));
        watcher.waitForEvent();
    }

    private long timedTransaction() throws Exception {
        long startTime = System.currentTimeMillis();
        this.zkClient.exists(AnyPath, false);
        return System.currentTimeMillis() - startTime;
    }

    @Test
    public void verifyAddDelay() throws Exception {
        BlockingStateWatcher watcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(watcher);
        watcher.waitForEvent();
        this.timedTransaction();
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.ADDDELAY, String.valueOf(200)));
        long delayedDuration = this.timedTransaction();
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.RESET));
        long resetDuration = this.timedTransaction();
        Assert.assertTrue((delayedDuration - resetDuration > 200L ? 1 : 0) != 0);
    }

    @Test
    public void verifyFailAllRequests() throws Exception {
        BlockingStateWatcher stateWatcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(stateWatcher);
        stateWatcher.waitForEvent();
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.FAILREQUESTS));
        try {
            this.zkClient.exists(AnyPath, null);
            Assert.fail((String)"should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
        try {
            this.zkClient.exists(AnyPath, null);
            Assert.fail((String)"should still fail");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.RESET));
        this.zkClient.exists(AnyPath, null);
    }

    @Test
    public void verifyFailRequestCount() throws Exception {
        BlockingStateWatcher stateWatcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(stateWatcher);
        stateWatcher.waitForEvent();
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.FAILREQUESTS, "1"));
        try {
            this.zkClient.exists(AnyPath, null);
            Assert.fail((String)"should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
        this.zkClient.exists(AnyPath, null);
    }

    @Test
    public void verifyServerEatsAllResponses() throws Exception {
        BlockingStateWatcher watcher = new BlockingStateWatcher(Watcher.Event.KeeperState.SyncConnected);
        this.initClient(watcher);
        watcher.waitForEvent();
        Assert.assertNull((Object)this.zkClient.exists(AnyPath, null));
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.NORESPONSE));
        try {
            BlockingPathWatcher pathWatcher = new BlockingPathWatcher(AnyPath, Watcher.Event.EventType.NodeCreated);
            this.zkClient.create(AnyPath, AnyData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, (AsyncCallback.StringCallback)pathWatcher, null);
            pathWatcher.waitForEvent(500);
            Assert.fail((String)"should time out since the event should never come");
        }
        catch (TimeoutException pathWatcher) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.commandClient.trySendCommand(ControlCommand.Action.RESET));
        watcher.reset(Watcher.Event.KeeperState.SyncConnected);
        try {
            this.zkClient.exists(AnyPath, false);
            Assert.fail((String)"should have failed with bad xid");
        }
        catch (KeeperException ex) {
            Assert.assertTrue((boolean)(ex instanceof KeeperException.ConnectionLossException));
        }
        watcher.waitForEvent();
        Assert.assertNotNull((Object)this.zkClient.exists(AnyPath, false));
    }

    private class BlockingPathWatcher
    extends EventWaiter {
        private String pathToNotifyOn;
        private Watcher.Event.EventType requiredEventType;

        public BlockingPathWatcher(String pathToNotifyOn, Watcher.Event.EventType requiredEventType) {
            this.reset(pathToNotifyOn, requiredEventType);
        }

        public void reset(String pathToNotifyOn, Watcher.Event.EventType requiredEventType) {
            super.reset();
            this.pathToNotifyOn = pathToNotifyOn;
            this.requiredEventType = requiredEventType;
        }

        @Override
        public void process(WatchedEvent event) {
            LOG.info("WatchEvent {} for path {}", (Object)event.getType(), (Object)event.getPath());
            if (this.pathToNotifyOn != null && event.getType() == this.requiredEventType && this.pathToNotifyOn.equalsIgnoreCase(event.getPath())) {
                this.notifyListener();
            }
        }
    }

    private class BlockingStateWatcher
    extends EventWaiter {
        private Object lockMe;
        private LinkedList<Watcher.Event.KeeperState> statesToWaitFor;

        public BlockingStateWatcher(Watcher.Event.KeeperState stateToNotifyOn) {
            this.lockMe = new Object();
            this.reset(stateToNotifyOn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(WatchedEvent event) {
            LOG.info("State transition: {}", (Object)event.getState());
            boolean shouldNotify = false;
            Object object = this.lockMe;
            synchronized (object) {
                if (!this.statesToWaitFor.isEmpty() && this.statesToWaitFor.getFirst() == event.getState()) {
                    this.statesToWaitFor.removeFirst();
                    shouldNotify = this.statesToWaitFor.isEmpty();
                }
            }
            if (shouldNotify) {
                this.notifyListener();
            }
        }

        public void reset(Watcher.Event.KeeperState stateToNotifyOn) {
            this.reset(new Watcher.Event.KeeperState[]{stateToNotifyOn});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(Watcher.Event.KeeperState[] orderedStatesToWaitOn) {
            if (orderedStatesToWaitOn == null) {
                throw new IllegalArgumentException("orderedStatesToWaitOn can't be null.");
            }
            if (orderedStatesToWaitOn.length <= 0) {
                throw new IllegalArgumentException("orderedStatesToWaitOn length must be positive.");
            }
            Object object = this.lockMe;
            synchronized (object) {
                super.reset();
                this.statesToWaitFor = new LinkedList();
                for (Watcher.Event.KeeperState state : orderedStatesToWaitOn) {
                    this.statesToWaitFor.add(state);
                }
            }
        }
    }

    private abstract class EventWaiter
    implements Watcher,
    AsyncCallback.StringCallback {
        private final int DEFAULT_WAIT_DURATION = 10000;
        private CountDownLatch eventNotification;

        public EventWaiter() {
            this.reset();
        }

        protected void reset() {
            this.eventNotification = new CountDownLatch(1);
        }

        public void process(WatchedEvent event) {
            LOG.info("WatchedEvent: {}", (Object)event);
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            LOG.info("StringCallback: {}, {}, {}, {}", new Object[]{rc, path, ctx, name});
        }

        public void notifyListener() {
            this.eventNotification.countDown();
        }

        public void waitForEvent() throws InterruptedException, TimeoutException {
            this.waitForEvent(10000);
        }

        public void waitForEvent(int waitDurationInMs) throws InterruptedException, TimeoutException {
            if (!this.eventNotification.await(waitDurationInMs, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Timed out waiting for event");
            }
        }
    }
}

