/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.LinkedList;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTest
extends ZKTestCase
implements AsyncCallback.StringCallback,
AsyncCallback.VoidCallback,
AsyncCallback.DataCallback {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncTest.class);
    private QuorumBase qb = new QuorumBase();
    List<Integer> results = new LinkedList<Integer>();

    @BeforeEach
    public void setUp() throws Exception {
        this.qb.setUp();
    }

    @AfterEach
    public void tearDown() throws Exception {
        LOG.info("Test clients shutting down");
        this.qb.tearDown();
    }

    private ZooKeeper createClient() throws Exception {
        return this.createClient(this.qb.hostPort);
    }

    private ZooKeeper createClient(String hp) throws Exception {
        ZooKeeper zk = ClientBase.createZKClient(hp);
        return zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsync() throws Exception {
        ZooKeeper zk = null;
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            zk.create("/ben", new byte[0], (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, this.results);
            zk.create("/ben/2", new byte[0], (List)ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, this.results);
            zk.delete("/ben", -1, (AsyncCallback.VoidCallback)this, this.results);
            zk.create("/ben2", new byte[0], (List)ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, (AsyncCallback.StringCallback)this, this.results);
            zk.getData("/ben2", false, (AsyncCallback.DataCallback)this, this.results);
            List<Integer> list = this.results;
            synchronized (list) {
                while (this.results.size() < 5) {
                    this.results.wait();
                }
            }
            Assertions.assertEquals((int)0, (int)this.results.get(0));
            Assertions.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)KeeperException.Code.get((int)this.results.get(1)));
            Assertions.assertEquals((int)0, (int)this.results.get(2));
            Assertions.assertEquals((int)0, (int)this.results.get(3));
            Assertions.assertEquals((int)0, (int)this.results.get(4));
        }
        finally {
            zk.close();
        }
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd2".getBytes());
            try {
                zk.getData("/ben2", false, new Stat());
                Assertions.fail((String)"Should have received a permission error");
            }
            catch (KeeperException e) {
                Assertions.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)e.code());
            }
        }
        finally {
            zk.close();
        }
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            zk.getData("/ben2", false, new Stat());
        }
        finally {
            zk.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx, String name) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }
}

