/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.X509Util;
import org.apache.zookeeper.common.ZKConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ZKConfigTest {
    X509Util x509Util = new ClientX509Util();

    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty(this.x509Util.getSslProtocolProperty());
    }

    @Test
    @Timeout(value=10L)
    public void testBooleanRetrievalFromPropertyDefault() {
        ZKConfig conf = new ZKConfig();
        String prop = "UnSetProperty" + System.currentTimeMillis();
        boolean defaultValue = false;
        boolean result = conf.getBoolean(prop, defaultValue);
        Assertions.assertEquals((Object)defaultValue, (Object)result);
    }

    @Test
    @Timeout(value=10L)
    public void testBooleanRetrievalFromProperty() {
        boolean value = true;
        boolean defaultValue = false;
        System.setProperty(this.x509Util.getSslProtocolProperty(), Boolean.toString(value));
        ZKConfig conf = new ZKConfig();
        boolean result = conf.getBoolean(this.x509Util.getSslProtocolProperty(), defaultValue);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    @Timeout(value=10L)
    public void testBooleanRetrievalFromPropertyWithWhitespacesInBeginning() {
        boolean value = true;
        boolean defaultValue = false;
        System.setProperty(this.x509Util.getSslProtocolProperty(), " " + value);
        ZKConfig conf = new ZKConfig();
        boolean result = conf.getBoolean(this.x509Util.getSslProtocolProperty(), defaultValue);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    @Timeout(value=10L)
    public void testBooleanRetrievalFromPropertyWithWhitespacesAtEnd() {
        boolean value = true;
        boolean defaultValue = false;
        System.setProperty(this.x509Util.getSslProtocolProperty(), value + " ");
        ZKConfig conf = new ZKConfig();
        boolean result = conf.getBoolean(this.x509Util.getSslProtocolProperty(), defaultValue);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    @Timeout(value=10L)
    public void testBooleanRetrievalFromPropertyWithWhitespacesAtBeginningAndEnd() {
        boolean value = true;
        boolean defaultValue = false;
        System.setProperty(this.x509Util.getSslProtocolProperty(), " " + value + " ");
        ZKConfig conf = new ZKConfig();
        boolean result = conf.getBoolean(this.x509Util.getSslProtocolProperty(), defaultValue);
        Assertions.assertEquals((Object)value, (Object)result);
    }
}

