/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadFromLogTest
extends ClientBase {
    private static final int NUM_MESSAGES = 300;
    protected static final Logger LOG = LoggerFactory.getLogger(LoadFromLogTest.class);
    private static final int TRANSACTION_OVERHEAD = 2;
    private static final int TOTAL_TRANSACTIONS = 302;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        SyncRequestProcessor.setSnapCount((int)50);
        super.setUp();
    }

    @Test
    public void testLoad() throws Exception {
        try (ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);){
            for (int i = 0; i < 300; ++i) {
                zk.create("/invalidsnap-" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        this.stopServer();
        File logDir = new File(this.tmpDir, "version-2");
        FileTxnLog txnLog = new FileTxnLog(logDir);
        TxnLog.TxnIterator itr = txnLog.read(0L);
        FileTxnLog.FileTxnIterator fileItr = (FileTxnLog.FileTxnIterator)itr;
        long storageSize = fileItr.getStorageSize();
        LOG.info("Txnlog size: {} bytes", (Object)storageSize);
        Assertions.assertTrue((storageSize > 0L ? 1 : 0) != 0, (String)"Storage size is greater than zero ");
        long expectedZxid = 0L;
        long lastZxid = 0L;
        do {
            TxnHeader hdr = itr.getHeader();
            Assertions.assertTrue((lastZxid != hdr.getZxid() ? 1 : 0) != 0, (String)("not the same transaction. lastZxid=" + lastZxid + ", zxid=" + hdr.getZxid()));
            Assertions.assertTrue((hdr.getZxid() == ++expectedZxid ? 1 : 0) != 0, (String)("excepting next transaction. expected=" + expectedZxid + ", retrieved=" + hdr.getZxid()));
            lastZxid = hdr.getZxid();
        } while (itr.next());
        Assertions.assertTrue((expectedZxid == 302L ? 1 : 0) != 0, (String)("processed all transactions. " + expectedZxid + " == " + 302));
    }

    @Test
    public void testLoadFailure() throws Exception {
        try (ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);){
            for (int i = 0; i < 300; ++i) {
                zk.create("/data-", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            }
        }
        this.stopServer();
        File logDir = new File(this.tmpDir, "version-2");
        File[] logFiles = FileTxnLog.getLogFiles((File[])logDir.listFiles(), (long)0L);
        Assertions.assertTrue((logFiles.length > 3 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)logFiles[0].delete(), (String)"delete the first log file");
        long secondStartZxid = Util.getZxidFromName((String)logFiles[1].getName(), (String)"log");
        FileTxnLog txnLog = new FileTxnLog(logDir);
        TxnLog.TxnIterator itr = txnLog.read(1L, false);
        Assertions.assertEquals((long)secondStartZxid, (long)itr.getHeader().getZxid());
        itr = txnLog.read(secondStartZxid, false);
        Assertions.assertEquals((long)secondStartZxid, (long)itr.getHeader().getZxid());
        Assertions.assertTrue((boolean)itr.next());
        long nextZxid = itr.getHeader().getZxid();
        itr = txnLog.read(nextZxid, false);
        Assertions.assertEquals((long)secondStartZxid, (long)itr.getHeader().getZxid());
        long thirdStartZxid = Util.getZxidFromName((String)logFiles[2].getName(), (String)"log");
        itr = txnLog.read(thirdStartZxid, false);
        Assertions.assertEquals((long)secondStartZxid, (long)itr.getHeader().getZxid());
        Assertions.assertTrue((boolean)itr.next());
        nextZxid = itr.getHeader().getZxid();
        itr = txnLog.read(nextZxid, false);
        Assertions.assertEquals((long)secondStartZxid, (long)itr.getHeader().getZxid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestore() throws Exception {
        String path;
        String[] children;
        String lastPath = null;
        try (ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);){
            zk.create("/invalidsnap", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (int i = 0; i < 300; ++i) {
                lastPath = zk.create("/invalidsnap/test-", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            }
        }
        String[] tokens = lastPath.split("-");
        String expectedPath = "/invalidsnap/test-" + String.format("%010d", Integer.parseInt(tokens[1]) + 1);
        ZooKeeperServer zks = this.serverFactory.getZooKeeperServer();
        long eZxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
        zks.getZKDatabase().setlastProcessedZxid(zks.getZKDatabase().getDataTreeLastProcessedZxid() - 10L);
        LOG.info("Set lastProcessedZxid to {}", (Object)zks.getZKDatabase().getDataTreeLastProcessedZxid());
        zks.takeSnapshot();
        zks.shutdown();
        this.stopServer();
        this.startServer();
        zks = this.serverFactory.getZooKeeperServer();
        long fZxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
        Assertions.assertTrue((fZxid == eZxid ? 1 : 0) != 0, (String)("Restore failed expected zxid=" + eZxid + " found=" + fZxid));
        zk = LoadFromLogTest.createZKClient(this.hostPort);
        try {
            children = zk.getChildren("/invalidsnap", false).toArray(new String[0]);
            path = zk.create("/invalidsnap/test-", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        }
        finally {
            zk.close();
        }
        LOG.info("Expected {} found {}", (Object)expectedPath, (Object)path);
        Assertions.assertTrue((boolean)path.equals(expectedPath), (String)("Error in sequential znode creation expected " + expectedPath + " found " + path));
        Assertions.assertTrue((children.length == 300 ? 1 : 0) != 0, (String)("Unexpected number of children " + children.length + " expected " + 300));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreWithTransactionErrors() throws Exception {
        try (ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);){
            for (int i = 0; i < 300; ++i) {
                try {
                    zk.create("/invaliddir/test-", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                    continue;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }
        }
        ZooKeeperServer zks = this.serverFactory.getZooKeeperServer();
        zks.getZKDatabase().setlastProcessedZxid(zks.getZKDatabase().getDataTreeLastProcessedZxid() - 10L);
        LOG.info("Set lastProcessedZxid to {}", (Object)zks.getZKDatabase().getDataTreeLastProcessedZxid());
        zks.takeSnapshot();
        zks.shutdown();
        this.stopServer();
        zks = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        this.startServer();
    }

    @Test
    public void testDatadirAutocreate() throws Exception {
        this.stopServer();
        try {
            System.setProperty("zookeeper.datadir.autocreate", "false");
            this.tmpDir = LoadFromLogTest.createTmpDir();
            this.startServer();
            Assertions.fail((String)"Server should not have started without datadir");
        }
        catch (IOException e) {
            LOG.debug("Server failed to start - correct behavior", (Throwable)e);
        }
        finally {
            System.setProperty("zookeeper.datadir.autocreate", "true");
        }
    }

    @Test
    public void testReloadSnapshotWithMissingParent() throws Exception {
        ZooKeeper zk = LoadFromLogTest.createZKClient(this.hostPort);
        zk.create("/a", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = zk.exists("/a", false);
        long createZxId = stat.getMzxid();
        zk.create("/a/b", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.delete("/a/b", -1);
        zk.delete("/a", -1);
        ZooKeeperServer zks = this.serverFactory.getZooKeeperServer();
        zks.getZKDatabase().setlastProcessedZxid(createZxId);
        LOG.info("Set lastProcessedZxid to {}", (Object)zks.getZKDatabase().getDataTreeLastProcessedZxid());
        zks.takeSnapshot();
        zks.shutdown();
        this.stopServer();
        this.startServer();
    }
}

