/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.StatsTrack;
import org.junit.Assert;
import org.junit.Test;

public class StatsTrackTest {
    @Test
    public void testBackwardCompatibility() {
        StatsTrack quota = new StatsTrack();
        quota.setCount(4L);
        quota.setCountHardLimit(4L);
        quota.setBytes(9L);
        quota.setByteHardLimit(15L);
        Assert.assertEquals((Object)"count=4,bytes=9=;byteHardLimit=15;countHardLimit=4", (Object)quota.toString());
        OldStatsTrack ost = new OldStatsTrack(quota.toString());
        Assert.assertTrue((String)"bytes are set", (ost.getBytes() == 9L ? 1 : 0) != 0);
        Assert.assertTrue((String)"num count is set", (ost.getCount() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"count=4,bytes=9", (Object)ost.toString());
    }

    @Test
    public void testUpwardCompatibility() {
        OldStatsTrack ost = new OldStatsTrack(null);
        ost.setCount(2);
        ost.setBytes(5L);
        Assert.assertEquals((Object)"count=2,bytes=5", (Object)ost.toString());
        StatsTrack st = new StatsTrack(ost.toString());
        Assert.assertEquals((Object)"count=2,bytes=5", (Object)st.toString());
        Assert.assertEquals((long)5L, (long)st.getBytes());
        Assert.assertEquals((long)2L, (long)st.getCount());
        Assert.assertEquals((long)-1L, (long)st.getByteHardLimit());
        Assert.assertEquals((long)-1L, (long)st.getCountHardLimit());
    }

    public static class OldStatsTrack {
        private int count;
        private long bytes;
        private String countStr = "count";
        private String byteStr = "bytes";

        public OldStatsTrack() {
            this(null);
        }

        public OldStatsTrack(String stats) {
            String[] split;
            if (stats == null) {
                stats = "count=-1,bytes=-1";
            }
            if ((split = stats.split(",")).length != 2) {
                throw new IllegalArgumentException("invalid string " + stats);
            }
            this.count = Integer.parseInt(split[0].split("=")[1]);
            this.bytes = Long.parseLong(split[1].split("=")[1]);
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getBytes() {
            return this.bytes;
        }

        public void setBytes(long bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            return this.countStr + "=" + this.count + "," + this.byteStr + "=" + this.bytes;
        }
    }
}

