/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.prometheus;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.stats.Counter;

public class LongAdderCounter
implements Counter {
    private final LongAdder counter = new LongAdder();
    private Map<String, String> labels;
    private boolean threadInitialized;

    public LongAdderCounter(Map<String, String> labels) {
        this.labels = labels;
    }

    public void clear() {
        this.counter.reset();
    }

    public void inc() {
        this.counter.increment();
    }

    public void dec() {
        this.counter.decrement();
    }

    public void addCount(long delta) {
        this.counter.add(delta);
    }

    public void addLatency(long eventLatency, TimeUnit unit) {
        long valueMillis = unit.toMillis(eventLatency);
        this.counter.add(valueMillis);
    }

    public Long get() {
        return this.counter.sum();
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean isThreadInitialized() {
        return this.threadInitialized;
    }

    public void initializeThread(Map<String, String> labels) {
        this.labels = labels;
        this.threadInitialized = true;
    }
}

