/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CheckedInputStream;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.IOUtils;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.CommandAuthTest;
import org.apache.zookeeper.server.admin.JettyAdminServer;
import org.apache.zookeeper.server.persistence.SnapStream;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class SnapshotAndRestoreCommandTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotAndRestoreCommandTest.class);
    private static final String SNAPSHOT_TEST_PATH = "/snapshot_test";
    private static final int NODE_COUNT = 10;
    private final String hostPort = "127.0.0.1:" + PortAssignment.unique();
    private final int jettyAdminPort = PortAssignment.unique();
    private ServerCnxnFactory cnxnFactory;
    private JettyAdminServer adminServer;
    private ZooKeeperServer zks;
    private ZooKeeper zk;
    @TempDir
    static File dataDir;
    @TempDir
    static File logDir;

    @BeforeAll
    public void setup() throws Exception {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        this.zks = new ZooKeeperServer(dataDir, logDir, 3000);
        int port = Integer.parseInt(this.hostPort.split(":")[1]);
        this.cnxnFactory = ServerCnxnFactory.createFactory((int)port, (int)-1);
        this.cnxnFactory.startup(this.zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(this.hostPort, 120000L));
        System.setProperty("zookeeper.admin.enableServer", "true");
        System.setProperty("zookeeper.admin.serverPort", String.valueOf(this.jettyAdminPort));
        System.setProperty("zookeeper.admin.rateLimiterIntervalInMS", "0");
        System.setProperty("zookeeper.admin.snapshot.enabled", "true");
        System.setProperty("zookeeper.serializeLastProcessedZxid.enabled", "true");
        System.setProperty("zookeeper.admin.restore.enabled", "true");
        this.adminServer = new JettyAdminServer();
        this.adminServer.setZooKeeperServer(this.zks);
        this.adminServer.start();
        this.zk = ClientBase.createZKClient(this.hostPort);
        CommandAuthTest.setupRootACLForDigest(this.zk);
        CommandAuthTest.addAuthInfoForDigest(this.zk);
        this.createData(this.zk, SNAPSHOT_TEST_PATH, 10L);
    }

    @AfterAll
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.4lw.commands.whitelist");
        System.clearProperty("zookeeper.admin.enableServer");
        System.clearProperty("zookeeper.admin.serverPort");
        System.clearProperty("zookeeper.admin.rateLimiterIntervalInMS");
        System.clearProperty("zookeeper.admin.snapshot.enabled");
        System.clearProperty("zookeeper.serializeLastProcessedZxid.enabled");
        System.clearProperty("zookeeper.admin.restore.enabled");
        CommandAuthTest.resetRootACL(this.zk);
        if (this.zk != null) {
            this.zk.close();
        }
        if (this.adminServer != null) {
            this.adminServer.shutdown();
        }
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
        }
        if (this.zks != null) {
            this.zks.shutdown();
        }
    }

    @Test
    public void testSnapshotAndRestoreCommand_streaming() throws Exception {
        ServerMetrics.getMetrics().resetAll();
        File snapshotFile = SnapshotAndRestoreCommandTest.takeSnapshotAndValidate(this.jettyAdminPort, dataDir);
        this.validateSnapshotMetrics();
        SnapshotAndRestoreCommandTest.performRestoreAndValidate(this.jettyAdminPort, snapshotFile);
        try (ZooKeeper zk = ClientBase.createZKClient(this.hostPort);){
            CommandAuthTest.addAuthInfoForDigest(zk);
            this.createData(zk, SNAPSHOT_TEST_PATH, 11L);
            Assertions.assertEquals((int)21, (int)zk.getAllChildrenNumber(SNAPSHOT_TEST_PATH));
        }
        this.validateRestoreMetrics();
    }

    @Test
    public void testClientRequest_restoreInProgress() throws Exception {
        int threadCount = 2;
        int nodeCount = 50;
        String restoreTestPath = "/restore_test";
        File snapshotFile = SnapshotAndRestoreCommandTest.takeSnapshotAndValidate(this.jettyAdminPort, dataDir);
        ExecutorService service = Executors.newFixedThreadPool(2);
        CountDownLatch latch = new CountDownLatch(2);
        AtomicBoolean createSucceeded = new AtomicBoolean(false);
        AtomicBoolean restoreSucceeded = new AtomicBoolean(false);
        service.submit(() -> {
            try {
                this.createData(this.zk, "/restore_test", 50L);
                createSucceeded.set(true);
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
                e.printStackTrace();
            }
            finally {
                latch.countDown();
            }
        });
        service.submit(() -> {
            try {
                SnapshotAndRestoreCommandTest.performRestoreAndValidate(this.jettyAdminPort, snapshotFile);
                restoreSucceeded.set(true);
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
                e.printStackTrace();
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (createSucceeded.get() && restoreSucceeded.get()) {
            Assertions.assertEquals((int)50, (int)this.zk.getAllChildrenNumber("/restore_test"));
        }
    }

    @Test
    public void testRestores() throws Exception {
        File snapshotFile = SnapshotAndRestoreCommandTest.takeSnapshotAndValidate(this.jettyAdminPort, dataDir);
        for (int i = 0; i < 3; ++i) {
            SnapshotAndRestoreCommandTest.performRestoreAndValidate(this.jettyAdminPort, snapshotFile);
        }
    }

    @Test
    public void testSnapshotCommand_nonStreaming() throws Exception {
        HttpURLConnection snapshotConn = SnapshotAndRestoreCommandTest.sendSnapshotRequest(false, this.jettyAdminPort);
        Assertions.assertEquals((int)200, (int)snapshotConn.getResponseCode());
        SnapshotAndRestoreCommandTest.validateResponseHeaders(snapshotConn);
        SnapshotAndRestoreCommandTest.displayResponsePayload(snapshotConn);
    }

    @Test
    public void testSnapshotCommand_disabled() throws Exception {
        System.setProperty("zookeeper.admin.snapshot.enabled", "false");
        try {
            HttpURLConnection snapshotConn = SnapshotAndRestoreCommandTest.sendSnapshotRequest(true, this.jettyAdminPort);
            Assertions.assertEquals((int)503, (int)snapshotConn.getResponseCode());
        }
        finally {
            System.setProperty("zookeeper.admin.snapshot.enabled", "true");
        }
    }

    @Test
    public void testSnapshotCommand_serializeLastZxidDisabled() throws Exception {
        ZooKeeperServer.setSerializeLastProcessedZxidEnabled((boolean)false);
        try {
            HttpURLConnection snapshotConn = SnapshotAndRestoreCommandTest.sendSnapshotRequest(true, this.jettyAdminPort);
            Assertions.assertEquals((int)500, (int)snapshotConn.getResponseCode());
        }
        finally {
            ZooKeeperServer.setSerializeLastProcessedZxidEnabled((boolean)true);
        }
    }

    @Test
    public void testRestoreCommand_disabled() throws Exception {
        System.setProperty("zookeeper.admin.restore.enabled", "false");
        try {
            HttpURLConnection restoreConn = SnapshotAndRestoreCommandTest.sendRestoreRequest(this.jettyAdminPort);
            Assertions.assertEquals((int)503, (int)restoreConn.getResponseCode());
        }
        finally {
            System.setProperty("zookeeper.admin.restore.enabled", "true");
        }
    }

    @Test
    public void testRestoreCommand_serializeLastZxidDisabled() throws Exception {
        ZooKeeperServer.setSerializeLastProcessedZxidEnabled((boolean)false);
        try {
            HttpURLConnection restoreConn = SnapshotAndRestoreCommandTest.sendRestoreRequest(this.jettyAdminPort);
            Assertions.assertEquals((int)500, (int)restoreConn.getResponseCode());
        }
        finally {
            ZooKeeperServer.setSerializeLastProcessedZxidEnabled((boolean)true);
        }
    }

    @Test
    public void testRestoreCommand_invalidSnapshotData() throws Exception {
        HttpURLConnection restoreConn = SnapshotAndRestoreCommandTest.sendRestoreRequest(this.jettyAdminPort);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream("Invalid snapshot data".getBytes());
             OutputStream outputStream = restoreConn.getOutputStream();){
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1024, (boolean)true);
        }
        Assertions.assertEquals((int)500, (int)restoreConn.getResponseCode());
    }

    private void createData(ZooKeeper zk, String parentPath, long count) throws Exception {
        try {
            zk.create(parentPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        int i = 0;
        while ((long)i < count) {
            zk.create(String.format("%s/%s", parentPath, "n_"), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            ++i;
        }
    }

    private static HttpURLConnection sendSnapshotRequest(boolean streaming, int jettyAdminPort) throws Exception {
        String queryParamsStr = SnapshotAndRestoreCommandTest.buildQueryStringForSnapshotCommand(streaming);
        URL snapshotURL = new URL(String.format("http://localhost:%d/commands/snapshot", jettyAdminPort) + "?" + queryParamsStr);
        HttpURLConnection snapshotConn = (HttpURLConnection)snapshotURL.openConnection();
        CommandAuthTest.addAuthHeader(snapshotConn, CommandAuthTest.AuthSchema.DIGEST, true);
        snapshotConn.setRequestMethod("GET");
        return snapshotConn;
    }

    private static HttpURLConnection sendRestoreRequest(int jettyAdminPort) throws Exception {
        URL restoreURL = new URL(String.format("http://localhost:%d/commands/restore", jettyAdminPort));
        HttpURLConnection restoreConn = (HttpURLConnection)restoreURL.openConnection();
        restoreConn.setDoOutput(true);
        CommandAuthTest.addAuthHeader(restoreConn, CommandAuthTest.AuthSchema.DIGEST, true);
        restoreConn.setRequestMethod("POST");
        return restoreConn;
    }

    private static String buildQueryStringForSnapshotCommand(boolean streaming) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("streaming", String.valueOf(streaming));
        return SnapshotAndRestoreCommandTest.getParamsString(parameters);
    }

    private static String getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }

    private static void validateResponseHeaders(HttpURLConnection conn) {
        LOG.info("Header:{}, Value:{}", (Object)"last_zxid", (Object)conn.getHeaderField("last_zxid"));
        Assertions.assertNotNull((Object)conn.getHeaderField("last_zxid"));
        LOG.info("Header:{}, Value:{}", (Object)"snapshot_size", (Object)conn.getHeaderField("snapshot_size"));
        Assertions.assertNotNull((Object)conn.getHeaderField("snapshot_size"));
        Assertions.assertTrue((Integer.parseInt(conn.getHeaderField("snapshot_size")) > 0 ? 1 : 0) != 0);
    }

    private static void displayResponsePayload(HttpURLConnection conn) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine);
            }
            LOG.info("Response payload: {}", (Object)sb);
        }
    }

    private void validateSnapshotMetrics() {
        Map<String, Object> metrics = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((long)0L, (long)((Long)metrics.get("snapshot_error_count")));
        Assertions.assertEquals((long)0L, (long)((Long)metrics.get("snapshot_rate_limited_count")));
        Assertions.assertTrue(((Double)metrics.get("avg_snapshottime") > 0.0 ? 1 : 0) != 0);
    }

    private void validateRestoreMetrics() {
        Map<String, Object> metrics = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((long)0L, (long)((Long)metrics.get("restore_error_count")));
        Assertions.assertEquals((long)0L, (long)((Long)metrics.get("restore_rate_limited_count")));
        Assertions.assertTrue(((Double)metrics.get("avg_restore_time") > 0.0 ? 1 : 0) != 0);
    }

    public static File takeSnapshotAndValidate(int jettyAdminPort, File dataDir) throws Exception {
        HttpURLConnection snapshotConn = SnapshotAndRestoreCommandTest.sendSnapshotRequest(true, jettyAdminPort);
        Assertions.assertEquals((int)200, (int)snapshotConn.getResponseCode());
        SnapshotAndRestoreCommandTest.validateResponseHeaders(snapshotConn);
        File snapshotFile = new File(dataDir + "/snapshot." + System.currentTimeMillis());
        try (InputStream inputStream = snapshotConn.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(snapshotFile);){
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1024, (boolean)true);
            long fileSize = Files.size(snapshotFile.toPath());
            Assertions.assertTrue((fileSize > 0L ? 1 : 0) != 0);
        }
        return snapshotFile;
    }

    public static void performRestoreAndValidate(int jettyAdminPort, File snapshotFile) throws Exception {
        HttpURLConnection restoreConn = SnapshotAndRestoreCommandTest.sendRestoreRequest(jettyAdminPort);
        try (CheckedInputStream is = SnapStream.getInputStream((File)snapshotFile);
             OutputStream outputStream = restoreConn.getOutputStream();){
            IOUtils.copyBytes((InputStream)is, (OutputStream)outputStream, (int)1024, (boolean)true);
        }
        Assertions.assertEquals((int)200, (int)restoreConn.getResponseCode());
        SnapshotAndRestoreCommandTest.displayResponsePayload(restoreConn);
    }
}

