/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourLetterWordsQuorumTest
extends QuorumBase {
    protected static final Logger LOG = LoggerFactory.getLogger(FourLetterWordsQuorumTest.class);

    @Test
    public void testFourLetterWords() throws Exception {
        String[] servers;
        for (String hp : servers = this.hostPort.split(",")) {
            this.verify(hp, "ruok", "imok");
            this.verify(hp, "envi", "java.version");
            this.verify(hp, "conf", "clientPort");
            this.verify(hp, "stat", "Outstanding");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", "queued");
            this.verify(hp, "dump", "Session");
            this.verify(hp, "wchs", "watches");
            this.verify(hp, "wchp", "");
            this.verify(hp, "wchc", "");
            this.verify(hp, "srst", "reset");
            this.verify(hp, "crst", "reset");
            this.verify(hp, "stat", "Outstanding");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", "queued");
            TestableZooKeeper zk = this.createClient(hp);
            String sid = FourLetterWordsQuorumTest.getHexSessionId(zk.getSessionId());
            this.verify(hp, "stat", "queued");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", sid);
            this.verify(hp, "dump", sid);
            this.verify(hp, "dirs", "size");
            zk.getData("/", true, null);
            this.verify(hp, "stat", "queued");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", sid);
            this.verify(hp, "dump", sid);
            this.verify(hp, "wchs", "watching 1");
            this.verify(hp, "wchp", sid);
            this.verify(hp, "wchc", sid);
            this.verify(hp, "dirs", "size");
            zk.close();
            this.verify(hp, "ruok", "imok");
            this.verify(hp, "envi", "java.version");
            this.verify(hp, "conf", "clientPort");
            this.verify(hp, "stat", "Outstanding");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", "queued");
            this.verify(hp, "dump", "Session");
            this.verify(hp, "wchs", "watch");
            this.verify(hp, "wchp", "");
            this.verify(hp, "wchc", "");
            this.verify(hp, "dirs", "size");
            this.verify(hp, "srst", "reset");
            this.verify(hp, "crst", "reset");
            this.verify(hp, "stat", "Outstanding");
            this.verify(hp, "srvr", "Outstanding");
            this.verify(hp, "cons", "queued");
            this.verify(hp, "mntr", "zk_version\t");
        }
    }

    private void verify(String hp, String cmd, String expected) throws IOException, X509Exception.SSLContextException {
        for (ClientBase.HostPort hpobj : FourLetterWordsQuorumTest.parseHostPortList(hp)) {
            String resp = FourLetterWordMain.send4LetterWord((String)hpobj.host, (int)hpobj.port, (String)cmd);
            LOG.info("cmd {} expected {} got {}", new Object[]{cmd, expected, resp});
            if (cmd.equals("dump")) {
                Assertions.assertTrue((resp.contains(expected) || resp.contains("Sessions with Ephemerals") ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertTrue((boolean)resp.contains(expected));
        }
    }
}

