/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.TxnLogEntry;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GetProposalFromTxnTest
extends ZKTestCase {
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int MSG_COUNT = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProposalFromTxn() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L), (String)"waiting for server being up ");
        Object[] zxids = new Long[2000];
        try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
            String data = "data";
            byte[] bytes = data.getBytes();
            for (int i = 0; i < 2000; ++i) {
                Stat stat = new Stat();
                zk.create("/invalidsnap-" + i, bytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.getData("/invalidsnap-" + i, null, stat);
                zxids[i] = stat.getCzxid();
            }
        }
        f.shutdown();
        zks.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L), (String)"waiting for server to shutdown");
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        zks.startdata();
        ZKDatabase db = zks.getZKDatabase();
        Iterator itr = db.getProposalsFromTxnLog(zxids[0].longValue(), 10000000L);
        int createCount = 0;
        ArrayList<Long> retrievedZxids = new ArrayList<Long>(2000);
        while (itr.hasNext()) {
            Leader.Proposal proposal = (Leader.Proposal)itr.next();
            TxnLogEntry logEntry = SerializeUtils.deserializeTxn((byte[])proposal.getQuorumPacket().getData());
            TxnHeader hdr = logEntry.getHeader();
            Record rec = logEntry.getTxn();
            if (hdr.getType() != 1) continue;
            retrievedZxids.add(hdr.getZxid());
            ++createCount;
        }
        Assertions.assertTrue((boolean)Arrays.equals(zxids, (Object[])retrievedZxids.toArray(new Long[0])), (String)"Zxids missmatches");
        Assertions.assertTrue((createCount == 2000 ? 1 : 0) != 0, (String)"create proposal count == 2000");
        db.setSnapshotSizeFactor(0.33);
        long sizeLimit = db.calculateTxnLogSizeLimit();
        itr = db.getProposalsFromTxnLog(((Long)zxids[1000]).longValue(), sizeLimit);
        Assertions.assertFalse((boolean)itr.hasNext(), (String)"Expect empty proposal");
        f.shutdown();
        zks.shutdown();
    }
}

