/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.DummyWatcher;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QuorumZxidSyncTest
extends ZKTestCase {
    QuorumBase qb = new QuorumBase();

    @BeforeEach
    public void setUp() throws Exception {
        this.qb.setUp();
    }

    @Test
    public void testBehindLeader() throws Exception {
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ZooKeeper zk = new ZooKeeper(this.qb.hostPort, 10000, (Watcher)DummyWatcher.INSTANCE);
        zk.create("/0", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, (Watcher)DummyWatcher.INSTANCE);
        zk.create("/1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, (Watcher)DummyWatcher.INSTANCE);
        zk.create("/2", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.cleanAndInitializeDataDir(this.qb.s1dir);
        this.cleanAndInitializeDataDir(this.qb.s2dir);
        this.cleanAndInitializeDataDir(this.qb.s3dir);
        this.cleanAndInitializeDataDir(this.qb.s4dir);
        this.qb.setupServers();
        this.qb.s1.start();
        this.qb.s2.start();
        this.qb.s3.start();
        this.qb.s4.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(this.qb.hostPort, 10000L), (String)"Servers didn't come up");
        this.qb.s5.start();
        String hostPort = "127.0.0.1:" + this.qb.s5.getClientPort();
        Assertions.assertFalse((boolean)ClientBase.waitForServerUp(hostPort, 10000L), (String)"Servers came up, but shouldn't have since it's ahead of leader");
    }

    private void cleanAndInitializeDataDir(File f) throws IOException {
        File v = new File(f, "version-2");
        for (File c : v.listFiles()) {
            c.delete();
        }
        ClientBase.createInitializeFile(f);
    }

    @Test
    public void testLateLogs() throws Exception {
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ZooKeeper zk = new ZooKeeper(this.qb.hostPort, 10000, (Watcher)DummyWatcher.INSTANCE);
        zk.create("/0", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, (Watcher)DummyWatcher.INSTANCE);
        zk.create("/1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        this.qb.shutdownServers();
        this.deleteLogs(this.qb.s1dir);
        this.deleteLogs(this.qb.s2dir);
        this.deleteLogs(this.qb.s3dir);
        this.deleteLogs(this.qb.s4dir);
        this.deleteLogs(this.qb.s5dir);
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, (Watcher)DummyWatcher.INSTANCE);
        zk.create("/2", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        this.qb.shutdownServers();
        this.qb.startServers();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        zk = new ZooKeeper(this.qb.hostPort, 10000, (Watcher)DummyWatcher.INSTANCE);
        boolean saw2 = false;
        for (String child : zk.getChildren("/", false)) {
            if (!child.equals("2")) continue;
            saw2 = true;
        }
        zk.close();
        Assertions.assertTrue((boolean)saw2, (String)"Didn't see /2 (went back in time)");
    }

    private void deleteLogs(File f) {
        File v = new File(f, "version-2");
        for (File c : v.listFiles()) {
            if (!c.getName().startsWith("log")) continue;
            c.delete();
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.qb.tearDown();
    }
}

