/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.Arrays;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SaslClientTest
extends ZKTestCase {
    private String existingPropertyValue = null;

    @BeforeEach
    public void setUp() {
        this.existingPropertyValue = System.getProperty("zookeeper.sasl.client");
    }

    @AfterEach
    public void tearDown() {
        if (this.existingPropertyValue != null) {
            System.setProperty("zookeeper.sasl.client", this.existingPropertyValue);
        }
    }

    @Test
    public void testSaslClientDisabled() {
        System.clearProperty("zookeeper.sasl.client");
        Assertions.assertTrue((boolean)new ZKClientConfig().isSaslClientEnabled(), (String)"SASL client disabled");
        for (String value : Arrays.asList("true", "TRUE")) {
            System.setProperty("zookeeper.sasl.client", value);
            Assertions.assertTrue((boolean)new ZKClientConfig().isSaslClientEnabled(), (String)"SASL client disabled");
        }
        for (String value : Arrays.asList("false", "FALSE")) {
            System.setProperty("zookeeper.sasl.client", value);
            Assertions.assertFalse((boolean)new ZKClientConfig().isSaslClientEnabled(), (String)"SASL client disabled");
        }
    }
}

