/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StatTest
extends ClientBase {
    private ZooKeeper zk;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    private Stat newStat() {
        Stat stat = new Stat();
        stat.setAversion(100);
        stat.setCtime(100L);
        stat.setCversion(100);
        stat.setCzxid(100L);
        stat.setDataLength(100);
        stat.setEphemeralOwner(100L);
        stat.setMtime(100L);
        stat.setMzxid(100L);
        stat.setNumChildren(100);
        stat.setPzxid(100L);
        stat.setVersion(100);
        return stat;
    }

    @Test
    public void testBasic() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = this.newStat();
        this.zk.getData(name, false, stat);
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assertions.assertEquals((int)0, (int)stat.getCversion());
        Assertions.assertEquals((int)0, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)name.length(), (int)stat.getDataLength());
        Assertions.assertEquals((int)0, (int)stat.getNumChildren());
    }

    @Test
    public void testChild() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String childname = name + "/bar";
        this.zk.create(childname, childname.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Stat stat = this.newStat();
        this.zk.getData(name, false, stat);
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assertions.assertEquals((long)(stat.getCzxid() + 1L), (long)stat.getPzxid());
        Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assertions.assertEquals((int)1, (int)stat.getCversion());
        Assertions.assertEquals((int)0, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)name.length(), (int)stat.getDataLength());
        Assertions.assertEquals((int)1, (int)stat.getNumChildren());
        stat = this.newStat();
        this.zk.getData(childname, false, stat);
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assertions.assertEquals((int)0, (int)stat.getCversion());
        Assertions.assertEquals((int)0, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)this.zk.getSessionId(), (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)childname.length(), (int)stat.getDataLength());
        Assertions.assertEquals((int)0, (int)stat.getNumChildren());
    }

    @Test
    public void testChildren() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int i = 0; i < 10; ++i) {
            String childname = name + "/bar" + i;
            this.zk.create(childname, childname.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            Stat stat = this.newStat();
            this.zk.getData(name, false, stat);
            Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
            Assertions.assertEquals((long)(stat.getCzxid() + (long)i + 1L), (long)stat.getPzxid());
            Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
            Assertions.assertEquals((int)(i + 1), (int)stat.getCversion());
            Assertions.assertEquals((int)0, (int)stat.getVersion());
            Assertions.assertEquals((int)0, (int)stat.getAversion());
            Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
            Assertions.assertEquals((int)name.length(), (int)stat.getDataLength());
            Assertions.assertEquals((int)(i + 1), (int)stat.getNumChildren());
        }
    }

    @Test
    public void testDataSizeChange() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = this.newStat();
        this.zk.getData(name, false, stat);
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assertions.assertEquals((int)0, (int)stat.getCversion());
        Assertions.assertEquals((int)0, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)name.length(), (int)stat.getDataLength());
        Assertions.assertEquals((int)0, (int)stat.getNumChildren());
        this.zk.setData(name, (name + name).getBytes(), -1);
        stat = this.newStat();
        this.zk.getData(name, false, stat);
        Assertions.assertNotSame((Object)stat.getCzxid(), (Object)stat.getMzxid());
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assertions.assertNotSame((Object)stat.getCtime(), (Object)stat.getMtime());
        Assertions.assertEquals((int)0, (int)stat.getCversion());
        Assertions.assertEquals((int)1, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)(name.length() * 2), (int)stat.getDataLength());
        Assertions.assertEquals((int)0, (int)stat.getNumChildren());
    }
}

