/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.table;

import io.netty.buffer.ByteBuf;

final class KeyGenerator {
    private final long numKeys;
    private final long keysPerPrefix;
    private final int prefixSize;

    KeyGenerator(long numKeys, long keysPerPrefix, int prefixSize) {
        this.numKeys = numKeys;
        this.keysPerPrefix = keysPerPrefix;
        this.prefixSize = prefixSize;
    }

    public void generateKeyFromLong(ByteBuf slice, long n) {
        int startPos = 0;
        if (this.keysPerPrefix > 0L) {
            int i;
            long numPrefix = (this.numKeys + this.keysPerPrefix - 1L) / this.keysPerPrefix;
            long prefix = n % numPrefix;
            int bytesToFill = Math.min(this.prefixSize, 8);
            for (i = 0; i < bytesToFill; ++i) {
                slice.setByte(i, (int)((byte)(prefix % 256L)));
                prefix /= 256L;
            }
            for (i = 8; i < bytesToFill; ++i) {
                slice.setByte(i, 48);
            }
            startPos = bytesToFill;
        }
        for (int i = slice.writableBytes() - 1; i >= startPos; --i) {
            slice.setByte(i, (int)((byte)(48L + n % 10L)));
            n /= 10L;
        }
    }
}

