/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.placement;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.distributedlog.service.placement.thrift.StreamLoad;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public class ServerLoad
implements Comparable {
    private static final int BUFFER_SIZE = 4096000;
    private final String server;
    private final HashSet<org.apache.distributedlog.service.placement.StreamLoad> streamLoads = new HashSet();
    private long load = 0L;

    public ServerLoad(String server) {
        this.server = server;
    }

    public synchronized long addStream(org.apache.distributedlog.service.placement.StreamLoad stream) {
        this.load += (long)stream.getLoad();
        this.streamLoads.add(stream);
        return this.load;
    }

    public synchronized long removeStream(String stream) {
        for (org.apache.distributedlog.service.placement.StreamLoad streamLoad : this.streamLoads) {
            if (!streamLoad.stream.equals(stream)) continue;
            this.load -= (long)streamLoad.getLoad();
            this.streamLoads.remove(streamLoad);
            return this.load;
        }
        return this.load;
    }

    public synchronized long getLoad() {
        return this.load;
    }

    public synchronized Set<org.apache.distributedlog.service.placement.StreamLoad> getStreamLoads() {
        return this.streamLoads;
    }

    public synchronized String getServer() {
        return this.server;
    }

    protected synchronized org.apache.distributedlog.service.placement.thrift.ServerLoad toThrift() {
        org.apache.distributedlog.service.placement.thrift.ServerLoad tServerLoad = new org.apache.distributedlog.service.placement.thrift.ServerLoad();
        tServerLoad.setServer(this.server);
        tServerLoad.setLoad(this.load);
        ArrayList<StreamLoad> tStreamLoads = new ArrayList<StreamLoad>();
        for (org.apache.distributedlog.service.placement.StreamLoad streamLoad : this.streamLoads) {
            tStreamLoads.add(streamLoad.toThrift());
        }
        tServerLoad.setStreams(tStreamLoads);
        return tServerLoad;
    }

    public byte[] serialize() throws IOException {
        TMemoryBuffer transport = new TMemoryBuffer(4096000);
        TJSONProtocol protocol = new TJSONProtocol((TTransport)transport);
        try {
            this.toThrift().write((TProtocol)protocol);
            transport.flush();
            return transport.toString(Charsets.UTF_8.name()).getBytes(Charsets.UTF_8);
        }
        catch (TException e) {
            throw new IOException("Failed to serialize server load : ", e);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IOException("Failed to serialize server load : ", uee);
        }
    }

    public static ServerLoad deserialize(byte[] data) throws IOException {
        org.apache.distributedlog.service.placement.thrift.ServerLoad tServerLoad = new org.apache.distributedlog.service.placement.thrift.ServerLoad();
        TMemoryInputTransport transport = new TMemoryInputTransport(data);
        TJSONProtocol protocol = new TJSONProtocol((TTransport)transport);
        try {
            tServerLoad.read((TProtocol)protocol);
            ServerLoad serverLoad = new ServerLoad(tServerLoad.getServer());
            if (tServerLoad.isSetStreams()) {
                for (StreamLoad tStreamLoad : tServerLoad.getStreams()) {
                    serverLoad.addStream(new org.apache.distributedlog.service.placement.StreamLoad(tStreamLoad.getStream(), tStreamLoad.getLoad()));
                }
            }
            return serverLoad;
        }
        catch (TException e) {
            throw new IOException("Failed to deserialize server load : ", e);
        }
    }

    public synchronized int compareTo(Object o) {
        ServerLoad other = (ServerLoad)o;
        if (this.load == other.getLoad()) {
            return this.server.compareTo(other.getServer());
        }
        return Long.compare(this.load, other.getLoad());
    }

    public synchronized boolean equals(Object o) {
        if (!(o instanceof ServerLoad)) {
            return false;
        }
        ServerLoad other = (ServerLoad)o;
        return this.server.equals(other.getServer()) && this.load == other.getLoad() && this.streamLoads.equals(other.getStreamLoads());
    }

    public synchronized String toString() {
        return String.format("ServerLoad<Server: %s, Load: %d, Streams: %s>", this.server, this.load, this.streamLoads);
    }

    public synchronized int hashCode() {
        return new HashCodeBuilder().append((Object)this.server).append(this.load).append(this.streamLoads).build();
    }
}

