/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Collection;
import java.util.SortedSet;
import javax.lang.model.element.PackageElement;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.RawHtml;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;

public abstract class AbstractPackageIndexWriter
extends HtmlDocletWriter {
    protected SortedSet<PackageElement> packages;

    public AbstractPackageIndexWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
        this.packages = configuration.packages;
    }

    protected abstract void addNavigationBarHeader(Content var1);

    protected abstract void addNavigationBarFooter(Content var1);

    protected abstract void addOverviewHeader(Content var1);

    protected abstract void addPackagesList(Collection<PackageElement> var1, String var2, String var3, Content var4);

    protected void buildPackageIndexFile(String title, boolean includeScript) throws IOException {
        String windowOverview = this.configuration.getText(title);
        HtmlTree body = this.getBody(includeScript, this.getWindowTitle(windowOverview));
        this.addNavigationBarHeader(body);
        this.addOverviewHeader(body);
        this.addIndex(body);
        this.addOverview(body);
        this.addNavigationBarFooter(body);
        this.printHtmlDocument(this.configuration.metakeywords.getOverviewMetaKeywords(title, this.configuration.doctitle), includeScript, body);
    }

    protected void addOverview(Content body) throws IOException {
    }

    protected void addIndex(Content body) {
        this.addIndexContents(this.packages, "doclet.Package_Summary", this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Package_Summary"), this.configuration.getText("doclet.packages")), body);
    }

    protected void addIndexContents(Collection<PackageElement> packages, String text, String tableSummary, Content body) {
        if (!packages.isEmpty()) {
            HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.NAV) ? HtmlTree.NAV() : new HtmlTree(HtmlTag.DIV);
            htmlTree.addStyle(HtmlStyle.indexNav);
            HtmlTree ul = new HtmlTree(HtmlTag.UL);
            this.addAllClassesLink(ul);
            htmlTree.addContent(ul);
            body.addContent(htmlTree);
            this.addPackagesList(packages, text, tableSummary, body);
        }
    }

    protected void addConfigurationTitle(Content body) {
        if (this.configuration.doctitle.length() > 0) {
            RawHtml title = new RawHtml(this.configuration.doctitle);
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.title, (Content)title);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
            body.addContent(div);
        }
    }

    @Override
    protected Content getNavLinkContents() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.overviewLabel);
        return li;
    }

    protected void addAllClassesLink(Content div) {
    }
}

