/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AbstractExecutableMemberWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SectionName;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.MemberSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.MethodWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ImplementedMethods;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class MethodWriterImpl
extends AbstractExecutableMemberWriter
implements MethodWriter,
MemberSummaryWriter {
    public MethodWriterImpl(SubWriterHolderWriter writer, TypeElement typeElement) {
        super(writer, typeElement);
    }

    public MethodWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    @Override
    public Content getMemberSummaryHeader(TypeElement typeElement, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_METHOD_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, typeElement, memberTree);
        return memberTree;
    }

    @Override
    public void addMemberTree(Content memberSummaryTree, Content memberTree) {
        this.writer.addMemberTree(memberSummaryTree, memberTree);
    }

    @Override
    public Content getMethodDetailsTreeHeader(TypeElement typeElement, Content memberDetailsTree) {
        memberDetailsTree.addContent(HtmlConstants.START_OF_METHOD_DETAILS);
        Content methodDetailsTree = this.writer.getMemberTreeHeader();
        methodDetailsTree.addContent(this.writer.getMarkerAnchor(SectionName.METHOD_DETAIL));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.DETAILS_HEADING, this.writer.methodDetailsLabel);
        methodDetailsTree.addContent(heading);
        return methodDetailsTree;
    }

    @Override
    public Content getMethodDocTreeHeader(ExecutableElement method, Content methodDetailsTree) {
        String erasureAnchor = this.getErasureAnchor(method);
        if (erasureAnchor != null) {
            methodDetailsTree.addContent(this.writer.getMarkerAnchor(erasureAnchor));
        }
        methodDetailsTree.addContent(this.writer.getMarkerAnchor(this.writer.getAnchor(method)));
        Content methodDocTree = this.writer.getMemberTreeHeader();
        HtmlTree heading = new HtmlTree(HtmlConstants.MEMBER_HEADING);
        ((Content)heading).addContent(this.name(method));
        methodDocTree.addContent(heading);
        return methodDocTree;
    }

    @Override
    public Content getSignature(ExecutableElement method) {
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.writer.addAnnotationInfo(method, (Content)pre);
        int annotationLength = ((Content)pre).charCount();
        this.addModifiers(method, pre);
        this.addTypeParameters(method, pre);
        this.addReturnType(method, pre);
        if (this.configuration.linksource) {
            StringContent methodName = new StringContent(this.name(method));
            this.writer.addSrcLink(method, methodName, pre);
        } else {
            this.addName(this.name(method), pre);
        }
        int indent = ((Content)pre).charCount() - annotationLength;
        this.addParameters(method, pre, indent);
        this.addExceptions(method, pre, indent);
        return pre;
    }

    @Override
    public void addDeprecated(ExecutableElement method, Content methodDocTree) {
        this.addDeprecatedInfo(method, methodDocTree);
    }

    @Override
    public void addComments(TypeMirror holderType, ExecutableElement method, Content methodDocTree) {
        TypeElement holder = this.utils.asTypeElement(holderType);
        if (!this.utils.getBody(method).isEmpty()) {
            if (holder.equals(this.typeElement) || !this.utils.isPublic(holder) && !this.utils.isLinkable(holder)) {
                this.writer.addInlineComment(method, methodDocTree);
            } else {
                Content link = this.writer.getDocLink(LinkInfoImpl.Kind.EXECUTABLE_ELEMENT_COPY, holder, (Element)method, this.utils.isIncluded(holder) ? this.utils.getSimpleName(holder) : this.utils.getFullyQualifiedName(holder), false);
                HtmlTree codelLink = HtmlTree.CODE(link);
                HtmlTree descfrmLabel = HtmlTree.SPAN(HtmlStyle.descfrmTypeLabel, this.utils.isClass(holder) ? this.writer.descfrmClassLabel : this.writer.descfrmInterfaceLabel);
                ((Content)descfrmLabel).addContent(this.writer.getSpace());
                ((Content)descfrmLabel).addContent(codelLink);
                methodDocTree.addContent(HtmlTree.DIV(HtmlStyle.block, descfrmLabel));
                this.writer.addInlineComment(method, methodDocTree);
            }
        }
    }

    @Override
    public void addTags(ExecutableElement method, Content methodDocTree) {
        this.writer.addTagsInfo(method, methodDocTree);
    }

    @Override
    public Content getMethodDetails(Content methodDetailsTree) {
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            HtmlTree htmlTree = HtmlTree.SECTION(this.getMemberTree(methodDetailsTree));
            return htmlTree;
        }
        return this.getMemberTree(methodDetailsTree);
    }

    @Override
    public Content getMethodDoc(Content methodDocTree, boolean isLastContent) {
        return this.getMemberTree(methodDocTree, isLastContent);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Method_Summary"));
        memberTree.addContent(label);
    }

    @Override
    public String getTableSummary() {
        return this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Method_Summary"), this.configuration.getText("doclet.methods"));
    }

    @Override
    public Content getCaption() {
        return this.configuration.getResource("doclet.Methods");
    }

    @Override
    public List<String> getSummaryTableHeader(Element member) {
        List<String> header = Arrays.asList(this.writer.getModifierTypeHeader(), this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Method"), this.configuration.getText("doclet.Description")));
        return header;
    }

    @Override
    public void addSummaryAnchor(TypeElement typeElement, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor(SectionName.METHOD_SUMMARY));
    }

    @Override
    public void addInheritedSummaryAnchor(TypeElement typeElement, Content inheritedTree) {
        inheritedTree.addContent(this.writer.getMarkerAnchor(SectionName.METHODS_INHERITANCE, this.configuration.getClassName(typeElement)));
    }

    @Override
    public void addInheritedSummaryLabel(TypeElement typeElement, Content inheritedTree) {
        Content classLink = this.writer.getPreQualifiedClassLink(LinkInfoImpl.Kind.MEMBER, typeElement, false);
        StringContent label = new StringContent(this.utils.isClass(typeElement) ? this.configuration.getText("doclet.Methods_Inherited_From_Class") : this.configuration.getText("doclet.Methods_Inherited_From_Interface"));
        HtmlTree labelHeading = HtmlTree.HEADING(HtmlConstants.INHERITED_SUMMARY_HEADING, label);
        ((Content)labelHeading).addContent(this.writer.getSpace());
        ((Content)labelHeading).addContent(classLink);
        inheritedTree.addContent(labelHeading);
    }

    @Override
    protected void addSummaryType(Element member, Content tdSummaryType) {
        ExecutableElement meth = (ExecutableElement)member;
        this.addModifierAndType(meth, this.utils.getReturnType(meth), tdSummaryType);
    }

    protected static void addOverridden(HtmlDocletWriter writer, TypeMirror overriddenType, ExecutableElement method, Content dl) {
        if (writer.configuration.nocomment) {
            return;
        }
        Utils utils = writer.configuration().utils;
        TypeElement holder = utils.getEnclosingTypeElement(method);
        if (!utils.isPublic(holder) && !utils.isLinkable(holder)) {
            return;
        }
        if (utils.isIncluded(holder) && !utils.isIncluded(method)) {
            return;
        }
        Content label = writer.overridesLabel;
        LinkInfoImpl.Kind context = LinkInfoImpl.Kind.METHOD_OVERRIDES;
        if (method != null) {
            if (utils.isAbstract(holder) && utils.isAbstract(method)) {
                label = writer.specifiedByLabel;
                context = LinkInfoImpl.Kind.METHOD_SPECIFIED_BY;
            }
            HtmlTree dt = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.overrideSpecifyLabel, label));
            dl.addContent(dt);
            Content overriddenTypeLink = writer.getLink(new LinkInfoImpl(writer.configuration, context, overriddenType));
            HtmlTree codeOverridenTypeLink = HtmlTree.CODE(overriddenTypeLink);
            Content methlink = writer.getLink(new LinkInfoImpl(writer.configuration, LinkInfoImpl.Kind.MEMBER, holder).where(writer.getName(writer.getAnchor(method))).label(method.getSimpleName()));
            HtmlTree codeMethLink = HtmlTree.CODE(methlink);
            HtmlTree dd = HtmlTree.DD(codeMethLink);
            ((Content)dd).addContent(writer.getSpace());
            ((Content)dd).addContent(writer.getResource("doclet.in_class"));
            ((Content)dd).addContent(writer.getSpace());
            ((Content)dd).addContent(codeOverridenTypeLink);
            dl.addContent(dd);
        }
    }

    protected static void addImplementsInfo(HtmlDocletWriter writer, ExecutableElement method, Content dl) {
        if (writer.configuration.nocomment) {
            return;
        }
        Utils utils = writer.utils;
        ImplementedMethods implementedMethodsFinder = new ImplementedMethods(method, writer.configuration);
        TreeSet<Element> implementedMethods = new TreeSet<Element>(utils.makeOverrideUseComparator());
        implementedMethods.addAll(implementedMethodsFinder.build());
        for (ExecutableElement executableElement : implementedMethods) {
            TypeMirror intfac = implementedMethodsFinder.getMethodHolder(executableElement);
            intfac = utils.getDeclaredType(utils.getEnclosingTypeElement(method), intfac);
            Content intfaclink = writer.getLink(new LinkInfoImpl(writer.configuration, LinkInfoImpl.Kind.METHOD_SPECIFIED_BY, intfac));
            HtmlTree codeIntfacLink = HtmlTree.CODE(intfaclink);
            HtmlTree dt = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.overrideSpecifyLabel, writer.specifiedByLabel));
            dl.addContent(dt);
            Content methlink = writer.getDocLink(LinkInfoImpl.Kind.MEMBER, executableElement, executableElement.getSimpleName(), false);
            HtmlTree codeMethLink = HtmlTree.CODE(methlink);
            HtmlTree dd = HtmlTree.DD(codeMethLink);
            ((Content)dd).addContent(writer.getSpace());
            ((Content)dd).addContent(writer.getResource("doclet.in_interface"));
            ((Content)dd).addContent(writer.getSpace());
            ((Content)dd).addContent(codeIntfacLink);
            dl.addContent(dd);
        }
    }

    protected void addReturnType(ExecutableElement method, Content htmltree) {
        TypeMirror type = this.utils.getReturnType(method);
        if (type != null) {
            Content linkContent = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.RETURN_TYPE, type));
            htmltree.addContent(linkContent);
            htmltree.addContent(this.writer.getSpace());
        }
    }

    @Override
    protected Content getNavSummaryLink(TypeElement typeElement, boolean link) {
        if (link) {
            if (typeElement == null) {
                return this.writer.getHyperLink(SectionName.METHOD_SUMMARY, this.writer.getResource("doclet.navMethod"));
            }
            return this.writer.getHyperLink(SectionName.METHODS_INHERITANCE, this.configuration.getClassName(typeElement), this.writer.getResource("doclet.navMethod"));
        }
        return this.writer.getResource("doclet.navMethod");
    }

    @Override
    protected void addNavDetailLink(boolean link, Content liNav) {
        if (link) {
            liNav.addContent(this.writer.getHyperLink(SectionName.METHOD_DETAIL, this.writer.getResource("doclet.navMethod")));
        } else {
            liNav.addContent(this.writer.getResource("doclet.navMethod"));
        }
    }
}

