/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.doclet.DocletEnvironment;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class IndexBuilder {
    private final Map<Character, SortedSet<Element>> indexmap;
    private boolean noDeprecated;
    private boolean classesOnly;
    private boolean javafx;
    private final Configuration configuration;
    private final Utils utils;

    public IndexBuilder(Configuration configuration, boolean noDeprecated) {
        this(configuration, noDeprecated, false);
    }

    public IndexBuilder(Configuration configuration, boolean noDeprecated, boolean classesOnly) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        if (classesOnly) {
            configuration.message.notice("doclet.Building_Index_For_All_Classes", new Object[0]);
        } else {
            configuration.message.notice("doclet.Building_Index", new Object[0]);
        }
        this.noDeprecated = noDeprecated;
        this.classesOnly = classesOnly;
        this.javafx = configuration.javafx;
        this.indexmap = new TreeMap<Character, SortedSet<Element>>();
        this.buildIndexMap(configuration.root);
    }

    protected void buildIndexMap(DocletEnvironment root) {
        Set<PackageElement> packages = this.utils.getSpecifiedPackages();
        Set<TypeElement> classes = root.getIncludedClasses();
        if (!this.classesOnly) {
            if (packages.isEmpty()) {
                HashSet<PackageElement> set = new HashSet<PackageElement>();
                for (TypeElement aClass : classes) {
                    PackageElement pkg = this.utils.containingPackage(aClass);
                    if (pkg == null || pkg.isUnnamed()) continue;
                    set.add(pkg);
                }
                this.adjustIndexMap(set);
            } else {
                this.adjustIndexMap(packages);
            }
        }
        this.adjustIndexMap(classes);
        if (!this.classesOnly) {
            for (TypeElement aClass : classes) {
                if (!this.shouldAddToIndexMap(aClass)) continue;
                this.putMembersInIndexMap(aClass);
            }
        }
    }

    protected void putMembersInIndexMap(TypeElement te) {
        this.adjustIndexMap(this.utils.getAnnotationFields(te));
        this.adjustIndexMap(this.utils.getFields(te));
        this.adjustIndexMap(this.utils.getMethods(te));
        this.adjustIndexMap(this.utils.getConstructors(te));
    }

    protected void adjustIndexMap(Iterable<? extends Element> elements) {
        for (Element element : elements) {
            if (!this.shouldAddToIndexMap(element)) continue;
            String name = this.utils.isPackage(element) ? this.utils.getPackageName((PackageElement)element) : this.utils.getSimpleName(element);
            char ch = name.length() == 0 ? (char)'*' : (char)Character.toUpperCase(name.charAt(0));
            Character unicode = Character.valueOf(ch);
            SortedSet list = this.indexmap.computeIfAbsent(unicode, c -> new TreeSet<Element>(this.utils.makeIndexUseComparator()));
            list.add(element);
        }
    }

    protected boolean shouldAddToIndexMap(Element element) {
        if (this.javafx && !this.utils.getBlockTags(element, "treatAsPrivate").isEmpty()) {
            return false;
        }
        if (this.utils.isPackage(element)) {
            return !this.noDeprecated || !this.configuration.utils.isDeprecated(element);
        }
        return !this.noDeprecated || !this.configuration.utils.isDeprecated(element) && !this.configuration.utils.isDeprecated(this.utils.containingPackage(element));
    }

    public Map<Character, SortedSet<Element>> getIndexMap() {
        return this.indexmap;
    }

    public List<? extends Element> getMemberList(Character index) {
        SortedSet<Element> set = this.indexmap.get(index);
        if (set == null) {
            return null;
        }
        ArrayList<Element> out = new ArrayList<Element>();
        out.addAll(set);
        return out;
    }

    public List<Character> index() {
        return new ArrayList<Character>(this.indexmap.keySet());
    }
}

