/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle;

import com.twitter.finagle.Failure;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.logging.Level;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

public final class Failure$
implements Serializable {
    public static final Failure$ MODULE$;
    private final StackTraceElement[] NoStacktrace;
    private final long Restartable;
    private final long Interrupted;
    private final long Wrapped;
    private final long Naming;
    private final long ShowMask;
    private final Failure rejected;
    private final Stack.Role role;

    static {
        new Failure$();
    }

    private StackTraceElement[] NoStacktrace() {
        return this.NoStacktrace;
    }

    public long Restartable() {
        return this.Restartable;
    }

    public long Interrupted() {
        return this.Interrupted;
    }

    public long Wrapped() {
        return this.Wrapped;
    }

    public long Naming() {
        return this.Naming;
    }

    private long ShowMask() {
        return this.ShowMask;
    }

    public Failure apply(Throwable cause, long flags, Level logLevel) {
        Failure failure;
        if (cause == null) {
            String x$43 = "unknown";
            None$ x$44 = None$.MODULE$;
            long x$45 = flags;
            Level x$46 = logLevel;
            Map<Enumeration.Value, Object> x$47 = this.$lessinit$greater$default$4();
            StackTraceElement[] x$48 = this.$lessinit$greater$default$5();
            failure = new Failure(x$43, (Option<Throwable>)x$44, x$45, x$47, x$48, x$46);
        } else if (cause.getMessage() == null) {
            String x$49 = cause.getClass().getName();
            Some x$50 = new Some((Object)cause);
            long x$51 = flags;
            Level x$52 = logLevel;
            Map<Enumeration.Value, Object> x$53 = this.$lessinit$greater$default$4();
            StackTraceElement[] x$54 = this.$lessinit$greater$default$5();
            failure = new Failure(x$49, (Option<Throwable>)x$50, x$51, x$53, x$54, x$52);
        } else {
            String x$55 = cause.getMessage();
            Some x$56 = new Some((Object)cause);
            long x$57 = flags;
            Level x$58 = logLevel;
            Map<Enumeration.Value, Object> x$59 = this.$lessinit$greater$default$4();
            StackTraceElement[] x$60 = this.$lessinit$greater$default$5();
            failure = new Failure(x$55, (Option<Throwable>)x$56, x$57, x$59, x$60, x$58);
        }
        return failure;
    }

    public Failure apply(Throwable cause) {
        return this.apply(cause, 0L, this.apply$default$3());
    }

    public Failure apply(String why, Throwable cause, long flags) {
        return new Failure(why, (Option<Throwable>)Option$.MODULE$.apply((Object)cause), flags, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6());
    }

    public Failure apply(String why, Throwable cause) {
        return this.apply(why, cause, 0L);
    }

    public Failure apply(String why, long flags) {
        return new Failure(why, (Option<Throwable>)None$.MODULE$, flags, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6());
    }

    public Failure apply(String why) {
        return new Failure(why, (Option<Throwable>)None$.MODULE$, 0L, this.$lessinit$greater$default$4(), this.$lessinit$greater$default$5(), this.$lessinit$greater$default$6());
    }

    public Level apply$default$3() {
        return Level.WARNING$.MODULE$;
    }

    public Option<Option<Throwable>> unapply(Failure exc) {
        return new Some(exc.cause());
    }

    public Set<String> flagsOf(Throwable exc) {
        Set set2;
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure = (Failure)throwable;
            Set flags = Predef$.MODULE$.Set().empty();
            if (failure.isFlagged(this.Interrupted())) {
                flags = (Set)flags.$plus((Object)"interrupted");
            }
            if (failure.isFlagged(this.Restartable())) {
                flags = (Set)flags.$plus((Object)"restartable");
            }
            if (failure.isFlagged(this.Wrapped())) {
                flags = (Set)flags.$plus((Object)"wrapped");
            }
            if (failure.isFlagged(this.Naming())) {
                flags = (Set)flags.$plus((Object)"naming");
            }
            set2 = flags;
        } else {
            set2 = Predef$.MODULE$.Set().empty();
        }
        return set2;
    }

    public Failure adapt(Throwable exc, long flags) {
        Failure failure;
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure2 = (Failure)throwable;
            failure = failure2.chained().flagged(flags);
        } else {
            failure = this.apply(throwable, flags, this.apply$default$3());
        }
        return failure;
    }

    public Failure wrap(Throwable exc, long flags) {
        Failure failure;
        Predef$.MODULE$.require(exc != null);
        Throwable throwable = exc;
        if (throwable instanceof Failure) {
            Failure failure2 = (Failure)throwable;
            failure = failure2.flagged(flags | this.Wrapped());
        } else {
            failure = this.apply(throwable, flags | this.Wrapped(), this.apply$default$3());
        }
        return failure;
    }

    public Failure wrap(Throwable exc) {
        return this.wrap(exc, 0L);
    }

    public Failure rejected(String why) {
        String x$61 = why;
        None$ x$62 = None$.MODULE$;
        long x$63 = this.Restartable();
        Level.DEBUG$ x$64 = Level.DEBUG$.MODULE$;
        Map<Enumeration.Value, Object> x$65 = this.$lessinit$greater$default$4();
        StackTraceElement[] x$66 = this.$lessinit$greater$default$5();
        return new Failure(x$61, (Option<Throwable>)x$62, x$63, x$65, x$66, (Level)x$64);
    }

    public Failure rejected(Throwable cause) {
        return this.apply(cause, this.Restartable(), (Level)Level.DEBUG$.MODULE$);
    }

    public Failure rejected(String why, Throwable cause) {
        String x$67 = why;
        Option x$68 = Option$.MODULE$.apply((Object)cause);
        long x$69 = this.Restartable();
        Level.DEBUG$ x$70 = Level.DEBUG$.MODULE$;
        Map<Enumeration.Value, Object> x$71 = this.$lessinit$greater$default$4();
        StackTraceElement[] x$72 = this.$lessinit$greater$default$5();
        return new Failure(x$67, (Option<Throwable>)x$68, x$69, x$71, x$72, (Level)x$70);
    }

    public Failure rejected() {
        return this.rejected;
    }

    public Throwable com$twitter$finagle$Failure$$show(Failure f) {
        Throwable throwable;
        block5: {
            while (f.isFlagged(this.Wrapped())) {
                Throwable inner;
                boolean bl = false;
                Some some = null;
                Option<Throwable> option = f.cause();
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    Throwable inner2 = (Throwable)some.x();
                    if (inner2 instanceof Failure) {
                        Failure failure;
                        f = failure = (Failure)inner2;
                        continue;
                    }
                }
                if (bl && (inner = (Throwable)some.x()) != null) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable2 = inner;
                    throwable = throwable3;
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException("Wrapped failure without a cause");
                }
                throw new MatchError(option);
            }
            throwable = f.masked(this.ShowMask());
        }
        return throwable;
    }

    public Stack.Role role() {
        return this.role;
    }

    public <Req, Rep> Stackable<ServiceFactory<Req, Rep>> module() {
        return new Stack.Module0<ServiceFactory<Req, Rep>>(){
            private final Stack.Role role;
            private final String description;
            private final Failure.ProcessFailures<Req, Rep> filter;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public ServiceFactory<Req, Rep> make(ServiceFactory<Req, Rep> next2) {
                return this.filter.andThen(next2);
            }
            {
                this.role = Failure$.MODULE$.role();
                this.description = "process failures";
                this.filter = new Failure.ProcessFailures<Req, Rep>();
            }
        };
    }

    public Option<Throwable> $lessinit$greater$default$2() {
        return None$.MODULE$;
    }

    public long $lessinit$greater$default$3() {
        return 0L;
    }

    public Map<Enumeration.Value, Object> $lessinit$greater$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public StackTraceElement[] $lessinit$greater$default$5() {
        return this.NoStacktrace();
    }

    public Level $lessinit$greater$default$6() {
        return Level.WARNING$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Failure$() {
        MODULE$ = this;
        this.NoStacktrace = (StackTraceElement[])((Object[])new StackTraceElement[]{new StackTraceElement("com.twitter.finagle", "NoStacktrace", null, -1)});
        this.Restartable = 1L;
        this.Interrupted = 2L;
        this.Wrapped = 4L;
        this.Naming = 0x100000000L;
        this.ShowMask = this.Interrupted();
        this.rejected = this.rejected("The request was rejected");
        this.role = new Stack.Role("ProcessFailure");
    }
}

