/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.common.util.PermitManager;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitedPermitManager
implements PermitManager,
Runnable,
Watcher {
    static final Logger LOG = LoggerFactory.getLogger(LimitedPermitManager.class);
    boolean enablePermits = true;
    final Semaphore semaphore;
    final int period;
    final TimeUnit timeUnit;
    final ScheduledExecutorService executorService;
    final AtomicInteger epoch = new AtomicInteger(0);
    private StatsLogger statsLogger = null;
    private Gauge<Number> outstandingGauge = null;

    public LimitedPermitManager(int concurrency, int period, TimeUnit timeUnit, ScheduledExecutorService executorService) {
        this(concurrency, period, timeUnit, executorService, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public LimitedPermitManager(final int concurrency, int period, TimeUnit timeUnit, ScheduledExecutorService executorService, StatsLogger statsLogger) {
        this.semaphore = concurrency > 0 ? new Semaphore(concurrency) : null;
        this.period = period;
        this.timeUnit = timeUnit;
        this.executorService = executorService;
        this.statsLogger = statsLogger;
        this.outstandingGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return null == LimitedPermitManager.this.semaphore ? 0 : concurrency - LimitedPermitManager.this.semaphore.availablePermits();
            }
        };
        this.statsLogger.scope("permits").registerGauge("outstanding", this.outstandingGauge);
    }

    public synchronized PermitManager.Permit acquirePermit() {
        if (!this.enablePermits) {
            return new EpochPermit(PermitState.DISABLED);
        }
        if (null != this.semaphore) {
            return this.semaphore.tryAcquire() ? new EpochPermit(PermitState.ALLOWED) : new EpochPermit(PermitState.DISALLOWED);
        }
        return new EpochPermit(PermitState.ALLOWED);
    }

    public synchronized void releasePermit(PermitManager.Permit permit) {
        if (null != this.semaphore && permit.isAllowed()) {
            if (this.period <= 0) {
                this.semaphore.release();
            } else {
                try {
                    this.executorService.schedule(this, (long)this.period, this.timeUnit);
                }
                catch (RejectedExecutionException ree) {
                    LOG.warn("Failed on scheduling releasing permit in given period ({}ms). Release it immediately : ", (Object)this.timeUnit.toMillis(this.period), (Object)ree);
                    this.semaphore.release();
                }
            }
        }
    }

    public synchronized boolean disallowObtainPermits(PermitManager.Permit permit) {
        if (!(permit instanceof EpochPermit)) {
            return false;
        }
        if (this.epoch.getAndIncrement() == ((EpochPermit)permit).getEpoch()) {
            this.enablePermits = false;
            LOG.info("EnablePermits = {}, Epoch = {}.", (Object)this.enablePermits, (Object)this.epoch.get());
            return true;
        }
        return false;
    }

    public void close() {
        this.unregisterGauge();
    }

    public synchronized boolean allowObtainPermits() {
        this.forceSetAllowPermits(true);
        return true;
    }

    synchronized void forceSetAllowPermits(boolean allowPermits) {
        this.epoch.getAndIncrement();
        this.enablePermits = allowPermits;
        LOG.info("EnablePermits = {}, Epoch = {}.", (Object)this.enablePermits, (Object)this.epoch.get());
    }

    @Override
    public void run() {
        this.semaphore.release();
    }

    public void process(WatchedEvent event) {
        if (event.getType().equals((Object)Watcher.Event.EventType.None)) {
            switch (event.getState()) {
                case SyncConnected: {
                    this.forceSetAllowPermits(true);
                    break;
                }
                case Disconnected: {
                    this.forceSetAllowPermits(false);
                    break;
                }
                case Expired: {
                    this.forceSetAllowPermits(false);
                    break;
                }
            }
        }
    }

    public void unregisterGauge() {
        if (this.statsLogger != null && this.outstandingGauge != null) {
            this.statsLogger.scope("permits").unregisterGauge("outstanding", this.outstandingGauge);
        }
    }

    class EpochPermit
    implements PermitManager.Permit {
        final PermitState state;
        final int epoch;

        EpochPermit(PermitState state) {
            this.state = state;
            this.epoch = LimitedPermitManager.this.epoch.get();
        }

        int getEpoch() {
            return this.epoch;
        }

        public boolean isAllowed() {
            return PermitState.ALLOWED == this.state;
        }
    }

    static enum PermitState {
        ALLOWED,
        DISALLOWED,
        DISABLED;

    }
}

