/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.openjdk.tools.javac.parser.Tokens;

final class ModifierOrderer {
    ModifierOrderer() {
    }

    private static Modifier getModifier(Tokens.TokenKind kind) {
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case PUBLIC: {
                return Modifier.PUBLIC;
            }
            case PROTECTED: {
                return Modifier.PROTECTED;
            }
            case PRIVATE: {
                return Modifier.PRIVATE;
            }
            case ABSTRACT: {
                return Modifier.ABSTRACT;
            }
            case STATIC: {
                return Modifier.STATIC;
            }
            case DEFAULT: {
                return Modifier.DEFAULT;
            }
            case FINAL: {
                return Modifier.FINAL;
            }
            case TRANSIENT: {
                return Modifier.TRANSIENT;
            }
            case VOLATILE: {
                return Modifier.VOLATILE;
            }
            case SYNCHRONIZED: {
                return Modifier.SYNCHRONIZED;
            }
            case NATIVE: {
                return Modifier.NATIVE;
            }
            case STRICTFP: {
                return Modifier.STRICTFP;
            }
        }
        return null;
    }

    static JavaInput reorderModifiers(String text) throws FormatterException {
        return ModifierOrderer.reorderModifiers(new JavaInput(text), Collections.singleton(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(text.length()))));
    }

    static JavaInput reorderModifiers(JavaInput javaInput, Collection<Range<Integer>> characterRanges) throws FormatterException {
        if (javaInput.getTokens().isEmpty()) {
            return javaInput;
        }
        RangeSet<Integer> tokenRanges = javaInput.characterRangesToTokenRanges(characterRanges);
        UnmodifiableIterator it = javaInput.getTokens().iterator();
        TreeRangeMap replacements = TreeRangeMap.create();
        while (it.hasNext()) {
            Modifier mod;
            Input.Token token = (Input.Token)it.next();
            if (!tokenRanges.contains((Comparable)Integer.valueOf(token.getTok().getIndex())) || (mod = ModifierOrderer.asModifier(token)) == null) continue;
            ArrayList<Input.Token> modifierTokens = new ArrayList<Input.Token>();
            ArrayList<Modifier> mods = new ArrayList<Modifier>();
            int begin = token.getTok().getPosition();
            mods.add(mod);
            modifierTokens.add(token);
            int end = -1;
            while (it.hasNext() && (mod = ModifierOrderer.asModifier(token = (Input.Token)it.next())) != null) {
                mods.add(mod);
                modifierTokens.add(token);
                end = token.getTok().getPosition() + token.getTok().length();
            }
            if (Ordering.natural().isOrdered(mods)) continue;
            Collections.sort(mods);
            StringBuilder replacement = new StringBuilder();
            for (int i = 0; i < mods.size(); ++i) {
                if (i > 0) {
                    ModifierOrderer.addTrivia(replacement, ((Input.Token)modifierTokens.get(i)).getToksBefore());
                }
                replacement.append(((Modifier)((Object)mods.get(i))).toString());
                if (i >= modifierTokens.size() - 1) continue;
                ModifierOrderer.addTrivia(replacement, ((Input.Token)modifierTokens.get(i)).getToksAfter());
            }
            replacements.put(Range.closedOpen((Comparable)Integer.valueOf(begin), (Comparable)Integer.valueOf(end)), (Object)replacement.toString());
        }
        return ModifierOrderer.applyReplacements(javaInput, (TreeRangeMap<Integer, String>)replacements);
    }

    private static void addTrivia(StringBuilder replacement, ImmutableList<? extends Input.Tok> toks) {
        for (Input.Tok tok : toks) {
            replacement.append(tok.getText());
        }
    }

    private static Modifier asModifier(Input.Token token) {
        return ModifierOrderer.getModifier(((JavaInput.Tok)token.getTok()).kind());
    }

    private static JavaInput applyReplacements(JavaInput javaInput, TreeRangeMap<Integer, String> replacementMap) throws FormatterException {
        Map ranges = replacementMap.asDescendingMapOfRanges();
        if (ranges.isEmpty()) {
            return javaInput;
        }
        StringBuilder sb = new StringBuilder(javaInput.getText());
        for (Map.Entry entry : ranges.entrySet()) {
            Range range = (Range)entry.getKey();
            sb.replace((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint(), (String)entry.getValue());
        }
        return new JavaInput(sb.toString());
    }
}

