/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.DurationSpec;
import org.apache.cassandra.db.CassandraKeyspaceWriteHandler;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.KeyspaceWriteHandler;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.repair.CassandraKeyspaceRepairManager;
import org.apache.cassandra.db.view.ViewManager;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.metrics.KeyspaceMetrics;
import org.apache.cassandra.repair.KeyspaceRepairManager;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.ReplicationParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.SchemaProvider;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.service.snapshot.TableSnapshot;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.concurrent.AsyncPromise;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.Promise;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Keyspace {
    private static final Logger logger = LoggerFactory.getLogger(Keyspace.class);
    private static final String TEST_FAIL_WRITES_KS = System.getProperty("cassandra.test.fail_writes_ks", "");
    private static final boolean TEST_FAIL_WRITES = !TEST_FAIL_WRITES_KS.isEmpty();
    private static int TEST_FAIL_MV_LOCKS_COUNT = Integer.getInteger("cassandra.test.fail_mv_locks_count", 0);
    public final KeyspaceMetrics metric;
    private volatile KeyspaceMetadata metadata;
    public static final OpOrder writeOrder;
    private final ConcurrentMap<TableId, ColumnFamilyStore> columnFamilyStores = new ConcurrentHashMap<TableId, ColumnFamilyStore>();
    private volatile AbstractReplicationStrategy replicationStrategy;
    public final ViewManager viewManager;
    private final KeyspaceWriteHandler writeHandler;
    private volatile ReplicationParams replicationParams;
    private final KeyspaceRepairManager repairManager;
    private final SchemaProvider schema;
    private static volatile boolean initialized;

    public static boolean isInitialized() {
        return initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitialized() {
        Schema schema = Schema.instance;
        synchronized (schema) {
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void unsetInitialized() {
        Schema schema = Schema.instance;
        synchronized (schema) {
            initialized = false;
        }
    }

    public static Keyspace open(String keyspaceName) {
        assert (initialized || SchemaConstants.isLocalSystemKeyspace(keyspaceName)) : "Initialized: " + initialized;
        return Keyspace.open(keyspaceName, Schema.instance, true);
    }

    public static Keyspace openWithoutSSTables(String keyspaceName) {
        return Keyspace.open(keyspaceName, Schema.instance, false);
    }

    public static Keyspace open(String keyspaceName, SchemaProvider schema, boolean loadSSTables) {
        return schema.maybeAddKeyspaceInstance(keyspaceName, () -> new Keyspace(keyspaceName, schema, loadSSTables));
    }

    public static ColumnFamilyStore openAndGetStore(TableMetadataRef tableRef) {
        return Keyspace.open(tableRef.keyspace).getColumnFamilyStore(tableRef.id);
    }

    public static ColumnFamilyStore openAndGetStore(TableMetadata table) {
        return Keyspace.open(table.keyspace).getColumnFamilyStore(table.id);
    }

    public static ColumnFamilyStore openAndGetStoreIfExists(TableMetadata table) {
        Keyspace keyspace = Keyspace.open(table.keyspace);
        if (keyspace == null) {
            return null;
        }
        return keyspace.getIfExists(table.id);
    }

    public static void removeUnreadableSSTables(File directory) {
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore baseCfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore cfs : baseCfs.concatWithIndexes()) {
                    cfs.maybeRemoveUnreadableSSTables(directory);
                }
            }
        }
    }

    public void setMetadata(KeyspaceMetadata metadata) {
        this.metadata = metadata;
        this.createReplicationStrategy(metadata);
    }

    public KeyspaceMetadata getMetadata() {
        return this.metadata;
    }

    public Collection<ColumnFamilyStore> getColumnFamilyStores() {
        return Collections.unmodifiableCollection(this.columnFamilyStores.values());
    }

    public ColumnFamilyStore getColumnFamilyStore(String cfName) {
        TableMetadata table = this.schema.getTableMetadata(this.getName(), cfName);
        if (table == null) {
            throw new IllegalArgumentException(String.format("Unknown keyspace/cf pair (%s.%s)", this.getName(), cfName));
        }
        return this.getColumnFamilyStore(table.id);
    }

    public ColumnFamilyStore getColumnFamilyStore(TableId id) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(id);
        if (cfs == null) {
            throw new IllegalArgumentException("Unknown CF " + id);
        }
        return cfs;
    }

    public ColumnFamilyStore getIfExists(TableId id) {
        return (ColumnFamilyStore)this.columnFamilyStores.get(id);
    }

    public boolean hasColumnFamilyStore(TableId id) {
        return this.columnFamilyStores.containsKey(id);
    }

    public void snapshot(String snapshotName, String columnFamilyName, boolean skipFlush, DurationSpec.IntSecondsBound ttl, RateLimiter rateLimiter, Instant creationTime) throws IOException {
        assert (snapshotName != null);
        boolean tookSnapShot = false;
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            if (columnFamilyName != null && !cfStore.name.equals(columnFamilyName)) continue;
            tookSnapShot = true;
            cfStore.snapshot(snapshotName, skipFlush, ttl, rateLimiter, creationTime);
        }
        if (columnFamilyName != null && !tookSnapShot) {
            throw new IOException("Failed taking snapshot. Table " + columnFamilyName + " does not exist.");
        }
    }

    public void snapshot(String snapshotName, String columnFamilyName) throws IOException {
        this.snapshot(snapshotName, columnFamilyName, false, null, null, FBUtilities.now());
    }

    public static String getTimestampedSnapshotName(String clientSuppliedName) {
        String snapshotName = Long.toString(Clock.Global.currentTimeMillis());
        if (clientSuppliedName != null && !clientSuppliedName.equals("")) {
            snapshotName = snapshotName + "-" + clientSuppliedName;
        }
        return snapshotName;
    }

    public static String getTimestampedSnapshotNameWithPrefix(String clientSuppliedName, String prefix) {
        return prefix + "-" + Keyspace.getTimestampedSnapshotName(clientSuppliedName);
    }

    public boolean snapshotExists(String snapshotName) {
        assert (snapshotName != null);
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            if (!cfStore.snapshotExists(snapshotName)) continue;
            return true;
        }
        return false;
    }

    public static void clearSnapshot(String snapshotName, String keyspace) {
        RateLimiter clearSnapshotRateLimiter = DatabaseDescriptor.getSnapshotRateLimiter();
        List<File> tableDirectories = Directories.getKSChildDirectories(keyspace);
        Directories.clearSnapshot(snapshotName, tableDirectories, clearSnapshotRateLimiter);
    }

    public List<SSTableReader> getAllSSTables(SSTableSet sstableSet) {
        ArrayList<SSTableReader> list = new ArrayList<SSTableReader>(this.columnFamilyStores.size());
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            Iterables.addAll(list, cfStore.getSSTables(sstableSet));
        }
        return list;
    }

    public Stream<TableSnapshot> getAllSnapshots() {
        return this.getColumnFamilyStores().stream().flatMap(cfs -> cfs.listSnapshots().values().stream());
    }

    private Keyspace(String keyspaceName, SchemaProvider schema, boolean loadSSTables) {
        this.schema = schema;
        this.metadata = schema.getKeyspaceMetadata(keyspaceName);
        assert (this.metadata != null) : "Unknown keyspace " + keyspaceName;
        if (this.metadata.isVirtual()) {
            throw new IllegalStateException("Cannot initialize Keyspace with virtual metadata " + keyspaceName);
        }
        this.createReplicationStrategy(this.metadata);
        this.metric = new KeyspaceMetrics(this);
        this.viewManager = new ViewManager(this);
        for (TableMetadata cfm : this.metadata.tablesAndViews()) {
            logger.trace("Initializing {}.{}", (Object)this.getName(), (Object)cfm.name);
            this.initCf(schema.getTableMetadataRef(cfm.id), loadSSTables);
        }
        this.viewManager.reload(false);
        this.repairManager = new CassandraKeyspaceRepairManager(this);
        this.writeHandler = new CassandraKeyspaceWriteHandler(this);
    }

    private Keyspace(KeyspaceMetadata metadata) {
        this.schema = Schema.instance;
        this.metadata = metadata;
        this.createReplicationStrategy(metadata);
        this.metric = new KeyspaceMetrics(this);
        this.viewManager = new ViewManager(this);
        this.repairManager = new CassandraKeyspaceRepairManager(this);
        this.writeHandler = new CassandraKeyspaceWriteHandler(this);
    }

    public KeyspaceRepairManager getRepairManager() {
        return this.repairManager;
    }

    public static Keyspace mockKS(KeyspaceMetadata metadata) {
        return new Keyspace(metadata);
    }

    private void createReplicationStrategy(KeyspaceMetadata ksm) {
        logger.info("Creating replication strategy " + ksm.name + " params " + ksm.params);
        this.replicationStrategy = ksm.createReplicationStrategy();
        if (!ksm.params.replication.equals(this.replicationParams)) {
            logger.debug("New replication settings for keyspace {} - invalidating disk boundary caches", (Object)ksm.name);
            this.columnFamilyStores.values().forEach(ColumnFamilyStore::invalidateLocalRanges);
        }
        this.replicationParams = ksm.params.replication;
    }

    public void dropCf(TableId tableId, boolean dropData) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.remove(tableId);
        if (cfs == null) {
            return;
        }
        cfs.onTableDropped();
        this.unloadCf(cfs, dropData);
    }

    public void unload(boolean dropData) {
        for (ColumnFamilyStore cfs : this.getColumnFamilyStores()) {
            this.unloadCf(cfs, dropData);
        }
        this.metric.release();
    }

    private void unloadCf(ColumnFamilyStore cfs, boolean dropData) {
        cfs.unloadCf();
        cfs.invalidate(true, dropData);
    }

    public void initCfCustom(ColumnFamilyStore newCfs) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(newCfs.metadata.id);
        if (cfs == null) {
            ColumnFamilyStore oldCfs = this.columnFamilyStores.putIfAbsent(newCfs.metadata.id, newCfs);
            if (oldCfs != null) {
                throw new IllegalStateException("added multiple mappings for cf id " + newCfs.metadata.id);
            }
        } else {
            throw new IllegalStateException("CFS is already initialized: " + cfs.name);
        }
    }

    public KeyspaceWriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public void initCf(TableMetadataRef metadata, boolean loadSSTables) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(metadata.id);
        if (cfs == null) {
            ColumnFamilyStore oldCfs = this.columnFamilyStores.putIfAbsent(metadata.id, ColumnFamilyStore.createColumnFamilyStore(this, metadata, loadSSTables));
            if (oldCfs != null) {
                throw new IllegalStateException("added multiple mappings for cf id " + metadata.id);
            }
        } else {
            assert (cfs.name.equals(metadata.name));
            cfs.reload();
        }
    }

    public Future<?> applyFuture(Mutation mutation, boolean writeCommitLog, boolean updateIndexes) {
        return this.applyInternal(mutation, writeCommitLog, updateIndexes, true, true, new AsyncPromise());
    }

    public Future<?> applyFuture(Mutation mutation, boolean writeCommitLog, boolean updateIndexes, boolean isDroppable, boolean isDeferrable) {
        return this.applyInternal(mutation, writeCommitLog, updateIndexes, isDroppable, isDeferrable, new AsyncPromise());
    }

    public void apply(Mutation mutation, boolean writeCommitLog, boolean updateIndexes) {
        this.apply(mutation, writeCommitLog, updateIndexes, true);
    }

    public void apply(Mutation mutation, boolean writeCommitLog) {
        this.apply(mutation, writeCommitLog, true, true);
    }

    public void apply(Mutation mutation, boolean makeDurable, boolean updateIndexes, boolean isDroppable) {
        this.applyInternal(mutation, makeDurable, updateIndexes, isDroppable, false, null);
    }

    /*
     * Loose catch block
     */
    private Future<?> applyInternal(Mutation mutation, boolean makeDurable, boolean updateIndexes, boolean isDroppable, boolean isDeferrable, Promise<?> future) {
        boolean requiresViewUpdate;
        if (TEST_FAIL_WRITES && this.metadata.name.equals(TEST_FAIL_WRITES_KS)) {
            throw new RuntimeException("Testing write failures");
        }
        Lock[] locks = null;
        boolean bl = requiresViewUpdate = updateIndexes && this.viewManager.updatesAffectView(Collections.singleton(mutation), false);
        if (requiresViewUpdate) {
            mutation.viewLockAcquireStart.compareAndSet(0L, Clock.Global.currentTimeMillis());
            Collection<TableId> tableIds = mutation.getTableIds();
            Iterator<TableId> idIterator = tableIds.iterator();
            locks = new Lock[tableIds.size()];
            for (int i = 0; i < tableIds.size(); ++i) {
                Lock lock;
                TableId tableId = idIterator.next();
                int lockKey = Objects.hash(mutation.key().getKey(), tableId);
                while (true) {
                    lock = null;
                    if (TEST_FAIL_MV_LOCKS_COUNT == 0) {
                        lock = ViewManager.acquireLockFor(lockKey);
                    } else {
                        --TEST_FAIL_MV_LOCKS_COUNT;
                    }
                    if (lock != null) break;
                    if (isDroppable && MonotonicClock.Global.approxTime.isAfter(mutation.approxCreatedAtNanos + DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS))) {
                        for (int j = 0; j < i; ++j) {
                            locks[j].unlock();
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("Could not acquire lock for {} and table {}", (Object)ByteBufferUtil.bytesToHex(mutation.key().getKey()), (Object)((ColumnFamilyStore)this.columnFamilyStores.get((Object)tableId)).name);
                        }
                        Tracing.trace("Could not acquire MV lock");
                        if (future != null) {
                            future.tryFailure(new WriteTimeoutException(WriteType.VIEW, ConsistencyLevel.LOCAL_ONE, 0, 1));
                            return future;
                        }
                        throw new WriteTimeoutException(WriteType.VIEW, ConsistencyLevel.LOCAL_ONE, 0, 1);
                    }
                    if (isDeferrable) {
                        for (int j = 0; j < i; ++j) {
                            locks[j].unlock();
                        }
                        Stage.MUTATION.execute(() -> this.applyInternal(mutation, makeDurable, true, isDroppable, true, future));
                        return future;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedInterruptedException(e);
                    }
                }
                locks[i] = lock;
            }
            long acquireTime = Clock.Global.currentTimeMillis() - mutation.viewLockAcquireStart.get();
            if (isDroppable) {
                for (TableId tableId : tableIds) {
                    ((ColumnFamilyStore)this.columnFamilyStores.get((Object)tableId)).metric.viewLockAcquireTime.update(acquireTime, TimeUnit.MILLISECONDS);
                }
            }
        }
        int nowInSec = FBUtilities.nowInSeconds();
        try {
            try (WriteContext ctx = this.getWriteHandler().beginWrite(mutation, makeDurable);){
                for (PartitionUpdate upd : mutation.getPartitionUpdates()) {
                    ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(upd.metadata().id);
                    if (cfs == null) {
                        logger.error("Attempting to mutate non-existant table {} ({}.{})", new Object[]{upd.metadata().id, upd.metadata().keyspace, upd.metadata().name});
                        continue;
                    }
                    AtomicLong baseComplete = new AtomicLong(Long.MAX_VALUE);
                    if (requiresViewUpdate) {
                        try {
                            Tracing.trace("Creating materialized view mutations from base table replica");
                            this.viewManager.forTable(upd.metadata().id).pushViewReplicaUpdates(upd, makeDurable, baseComplete);
                        }
                        catch (Throwable t) {
                            JVMStabilityInspector.inspectThrowable(t);
                            logger.error(String.format("Unknown exception caught while attempting to update MaterializedView! %s", upd.metadata().toString()), t);
                            throw t;
                        }
                    }
                    UpdateTransaction indexTransaction = updateIndexes ? cfs.indexManager.newUpdateTransaction(upd, ctx, nowInSec) : UpdateTransaction.NO_OP;
                    cfs.getWriteHandler().write(upd, ctx, indexTransaction);
                    if (!requiresViewUpdate) continue;
                    baseComplete.set(Clock.Global.currentTimeMillis());
                }
                if (future != null) {
                    future.trySuccess(null);
                }
                Object object = future;
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (locks != null) {
                for (Lock lock : locks) {
                    if (lock == null) continue;
                    lock.unlock();
                }
            }
        }
    }

    public AbstractReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public List<Future<?>> flush(ColumnFamilyStore.FlushReason reason) {
        ArrayList futures = new ArrayList(this.columnFamilyStores.size());
        for (ColumnFamilyStore cfs : this.columnFamilyStores.values()) {
            futures.add(cfs.forceFlush(reason));
        }
        return futures;
    }

    public Iterable<ColumnFamilyStore> getValidColumnFamilies(boolean allowIndexes, boolean autoAddIndexes, String ... cfNames) throws IOException {
        HashSet<ColumnFamilyStore> valid = new HashSet<ColumnFamilyStore>();
        if (cfNames.length == 0) {
            for (ColumnFamilyStore cfStore : this.getColumnFamilyStores()) {
                valid.add(cfStore);
                if (!autoAddIndexes) continue;
                valid.addAll(this.getIndexColumnFamilyStores(cfStore));
            }
            return valid;
        }
        for (String cfName : cfNames) {
            if (SecondaryIndexManager.isIndexColumnFamily(cfName)) {
                if (!allowIndexes) {
                    logger.warn("Operation not allowed on secondary Index table ({})", (Object)cfName);
                    continue;
                }
                String baseName = SecondaryIndexManager.getParentCfsName(cfName);
                String indexName = SecondaryIndexManager.getIndexName(cfName);
                ColumnFamilyStore baseCfs = this.getColumnFamilyStore(baseName);
                Index index = baseCfs.indexManager.getIndexByName(indexName);
                if (index == null) {
                    throw new IllegalArgumentException(String.format("Invalid index specified: %s/%s.", baseCfs.metadata.name, indexName));
                }
                if (!index.getBackingTable().isPresent()) continue;
                valid.add(index.getBackingTable().get());
                continue;
            }
            ColumnFamilyStore cfStore = this.getColumnFamilyStore(cfName);
            valid.add(cfStore);
            if (!autoAddIndexes) continue;
            valid.addAll(this.getIndexColumnFamilyStores(cfStore));
        }
        return valid;
    }

    private Set<ColumnFamilyStore> getIndexColumnFamilyStores(ColumnFamilyStore baseCfs) {
        HashSet<ColumnFamilyStore> stores = new HashSet<ColumnFamilyStore>();
        for (ColumnFamilyStore indexCfs : baseCfs.indexManager.getAllIndexColumnFamilyStores()) {
            logger.info("adding secondary index table {} to operation", (Object)indexCfs.metadata.name);
            stores.add(indexCfs);
        }
        return stores;
    }

    public static Iterable<Keyspace> all() {
        return Iterables.transform(Schema.instance.getKeyspaces(), Keyspace::open);
    }

    public static Stream<Keyspace> allExisting() {
        return Schema.instance.getKeyspaces().stream().map(Schema.instance::getKeyspaceInstance).filter(Objects::nonNull);
    }

    public static Iterable<Keyspace> nonLocalStrategy() {
        return Iterables.transform(Schema.instance.distributedKeyspaces().names(), Keyspace::open);
    }

    public static Iterable<Keyspace> system() {
        return Iterables.transform(SchemaConstants.LOCAL_SYSTEM_KEYSPACE_NAMES, Keyspace::open);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name='" + this.getName() + "')";
    }

    public String getName() {
        return this.metadata.name;
    }

    static {
        if (DatabaseDescriptor.isDaemonInitialized() || DatabaseDescriptor.isToolInitialized()) {
            DatabaseDescriptor.createAllDirectories();
        }
        writeOrder = new OpOrder();
        initialized = false;
    }
}

