/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.util.Comparator;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.apache.cassandra.utils.caching.TinyThreadLocalPool;
import org.apache.cassandra.utils.memory.Cloner;

public abstract class ColumnData
implements IMeasurableMemory {
    public static final Comparator<ColumnData> comparator = (cd1, cd2) -> cd1.column().compareTo(cd2.column());
    public static PostReconciliationFunction noOp = new PostReconciliationFunction(){

        @Override
        public Cell<?> merge(Cell<?> previous, Cell<?> insert) {
            return insert;
        }

        @Override
        public ColumnData insert(ColumnData insert) {
            return insert;
        }

        @Override
        public void delete(ColumnData existing) {
        }

        @Override
        public void onAllocatedOnHeap(long delta) {
        }
    };
    protected final ColumnMetadata column;

    public static Reconciler reconciler(PostReconciliationFunction updateF, DeletionTime activeDeletion) {
        TinyThreadLocalPool.TinyPool pool = (TinyThreadLocalPool.TinyPool)Reconciler.POOL.get();
        Reconciler reconciler = (Reconciler)pool.poll();
        if (reconciler == null) {
            reconciler = new Reconciler();
        }
        reconciler.init(updateF, activeDeletion);
        reconciler.pool = pool;
        return reconciler;
    }

    protected ColumnData(ColumnMetadata column) {
        this.column = column;
    }

    public final ColumnMetadata column() {
        return this.column;
    }

    public abstract int dataSize();

    public abstract long unsharedHeapSizeExcludingData();

    @Override
    public abstract long unsharedHeapSize();

    public abstract void validate();

    public abstract boolean hasInvalidDeletions();

    public abstract void digest(Digest var1);

    public static void digest(Digest digest, ColumnData cd) {
        cd.digest(digest);
    }

    public abstract ColumnData clone(Cloner var1);

    public abstract ColumnData updateAllTimestamp(long var1);

    public abstract ColumnData markCounterLocalToBeCleared();

    public abstract ColumnData purge(DeletionPurger var1, int var2);

    public abstract ColumnData purgeDataOlderThan(long var1);

    public abstract long maxTimestamp();

    public static class Reconciler
    implements UpdateFunction<ColumnData, ColumnData>,
    AutoCloseable {
        private static final TinyThreadLocalPool<Reconciler> POOL = new TinyThreadLocalPool();
        private PostReconciliationFunction postReconcile;
        private DeletionTime activeDeletion;
        private TinyThreadLocalPool.TinyPool<Reconciler> pool;

        private void init(PostReconciliationFunction postReconcile, DeletionTime activeDeletion) {
            this.postReconcile = postReconcile;
            this.activeDeletion = activeDeletion;
        }

        @Override
        public ColumnData merge(ColumnData existing, ColumnData update) {
            Object[] cells;
            DeletionTime updateDeletion;
            if (!(existing instanceof ComplexColumnData)) {
                Cell existingCell = (Cell)existing;
                Cell updateCell = (Cell)update;
                Cell<?> result = Cells.reconcile(existingCell, updateCell);
                return this.postReconcile.merge(existingCell, result);
            }
            ComplexColumnData existingComplex = (ComplexColumnData)existing;
            ComplexColumnData updateComplex = (ComplexColumnData)update;
            DeletionTime existingDeletion = existingComplex.complexDeletion();
            DeletionTime maxComplexDeletion = existingDeletion.supersedes(updateDeletion = updateComplex.complexDeletion()) ? existingDeletion : updateDeletion;
            Object[] existingTree = existingComplex.tree();
            Object[] updateTree = updateComplex.tree();
            try (Reconciler reconciler = ColumnData.reconciler(this.postReconcile, maxComplexDeletion);){
                if (!maxComplexDeletion.isLive()) {
                    if (maxComplexDeletion == existingDeletion) {
                        updateTree = BTree.transformAndFilter(updateTree, reconciler::removeShadowed);
                    } else {
                        Object[] retained = BTree.transformAndFilter(existingTree, reconciler::retain);
                        if (existingTree != retained) {
                            this.onAllocatedOnHeap(BTree.sizeOnHeapOf(retained) - BTree.sizeOnHeapOf(existingTree));
                            existingTree = retained;
                        }
                    }
                }
                cells = BTree.update(existingTree, updateTree, existingComplex.column.cellComparator(), reconciler);
            }
            return new ComplexColumnData(existingComplex.column, cells, maxComplexDeletion);
        }

        @Override
        public void onAllocatedOnHeap(long heapSize) {
            this.postReconcile.onAllocatedOnHeap(heapSize);
        }

        @Override
        public ColumnData insert(ColumnData insert) {
            return this.postReconcile.insert(insert);
        }

        public ColumnData retain(ColumnData existing) {
            return this.removeShadowed(existing, this.postReconcile);
        }

        private ColumnData removeShadowed(ColumnData existing) {
            return this.removeShadowed(existing, noOp);
        }

        private ColumnData removeShadowed(ColumnData existing, PostReconciliationFunction recordDeletion) {
            if (!(existing instanceof ComplexColumnData)) {
                if (this.activeDeletion.deletes((Cell)existing)) {
                    recordDeletion.delete(existing);
                    return null;
                }
            } else {
                ComplexColumnData existingComplex = (ComplexColumnData)existing;
                if (this.activeDeletion.supersedes(existingComplex.complexDeletion())) {
                    Object[] cells = BTree.transformAndFilter(existingComplex.tree(), cd -> this.removeShadowed((ColumnData)cd, recordDeletion));
                    return BTree.isEmpty(cells) ? null : new ComplexColumnData(existingComplex.column, cells, DeletionTime.LIVE);
                }
            }
            return existing;
        }

        @Override
        public void close() {
            this.activeDeletion = null;
            this.postReconcile = null;
            TinyThreadLocalPool.TinyPool<Reconciler> tmp = this.pool;
            this.pool = null;
            tmp.offer(this);
        }
    }

    public static interface PostReconciliationFunction {
        public ColumnData insert(ColumnData var1);

        public Cell<?> merge(Cell<?> var1, Cell<?> var2);

        public void delete(ColumnData var1);

        public void onAllocatedOnHeap(long var1);
    }
}

