/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.tracker;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.tracker.RequestIdGenerator;
import com.datastax.oss.driver.shaded.guava.common.io.BaseEncoding;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.SecureRandom;
import java.util.Random;

public class W3CContextRequestIdGenerator
implements RequestIdGenerator {
    private final Random random = new SecureRandom();
    private final BaseEncoding baseEncoding = BaseEncoding.base16().lowerCase();
    private final String payloadKey;

    public W3CContextRequestIdGenerator(DriverContext context) {
        this.payloadKey = RequestIdGenerator.super.getCustomPayloadKey();
    }

    public W3CContextRequestIdGenerator(String payloadKey) {
        this.payloadKey = payloadKey;
    }

    @Override
    public String getSessionRequestId() {
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        return this.baseEncoding.encode(bytes);
    }

    @Override
    public String getNodeRequestId(@NonNull Request statement, @NonNull String parentId) {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        return String.format("00-%s-%s-00", parentId, this.baseEncoding.encode(bytes));
    }

    @Override
    public String getCustomPayloadKey() {
        return this.payloadKey;
    }
}

