/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.Predicate;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractMockPredicateTest<T> {
    private List<Predicate<? super T>> mockPredicatesToVerify;
    private final T testValue;

    protected AbstractMockPredicateTest(T testValue) {
        this.testValue = testValue;
    }

    protected final Predicate<T> createMockPredicate(Boolean returnValue) {
        Predicate mockPredicate = (Predicate)EasyMock.createMock(Predicate.class);
        if (returnValue != null) {
            EasyMock.expect((Object)mockPredicate.test(this.testValue)).andReturn((Object)returnValue);
        }
        EasyMock.replay((Object[])new Object[]{mockPredicate});
        this.mockPredicatesToVerify.add(mockPredicate);
        return mockPredicate;
    }

    @BeforeEach
    public final void createVerifyList() {
        this.mockPredicatesToVerify = new ArrayList<Predicate<? super T>>();
    }

    protected final T getTestValue() {
        return this.testValue;
    }

    @AfterEach
    public final void verifyPredicates() {
        for (Predicate<? super T> predicate : this.mockPredicatesToVerify) {
            EasyMock.verify((Object[])new Object[]{predicate});
        }
    }
}

