/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.classic;

import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.ConnPoolStats;
import org.apache.hc.core5.pool.PoolStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConnPoolListener
implements ConnPoolListener<HttpHost> {
    public static final LoggingConnPoolListener INSTANCE = new LoggingConnPoolListener();
    private final Logger connLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.connection");

    private LoggingConnPoolListener() {
    }

    public void onLease(HttpHost route, ConnPoolStats<HttpHost> connPoolStats) {
        if (this.connLog.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Leased ").append(route).append(" ");
            PoolStats totals = connPoolStats.getTotalStats();
            buf.append(" total kept alive: ").append(totals.getAvailable()).append("; ");
            buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
            buf.append(" of ").append(totals.getMax());
            this.connLog.debug(buf.toString());
        }
    }

    public void onRelease(HttpHost route, ConnPoolStats<HttpHost> connPoolStats) {
        if (this.connLog.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Released ").append(route).append(" ");
            PoolStats totals = connPoolStats.getTotalStats();
            buf.append(" total kept alive: ").append(totals.getAvailable()).append("; ");
            buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
            buf.append(" of ").append(totals.getMax());
            this.connLog.debug(buf.toString());
        }
    }
}

