/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.security.filters.SecurityFilter;
import java.security.Principal;
import java.util.Optional;

public abstract class AbstractPrincipalArgumentBinder<A extends Principal>
implements TypedRequestArgumentBinder<A> {
    private final Class<A> authenticationClass;
    private final Argument<A> argumentType;

    protected AbstractPrincipalArgumentBinder(Class<A> authenticationClass) {
        this.authenticationClass = authenticationClass;
        this.argumentType = Argument.of(authenticationClass);
    }

    public ArgumentBinder.BindingResult<A> bind(ArgumentConversionContext<A> context, HttpRequest<?> source) {
        if (!source.getAttributes().contains(SecurityFilter.KEY)) {
            return ArgumentBinder.BindingResult.UNSATISFIED;
        }
        Optional existing = source.getUserPrincipal(this.authenticationClass);
        return existing.isPresent() ? () -> existing : ArgumentBinder.BindingResult.EMPTY;
    }

    public Argument<A> argumentType() {
        return this.argumentType;
    }
}

