/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.sql;

import java.sql.SQLException;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.StringCallInput;
import org.apache.ignite.internal.cli.sql.SqlManager;
import org.apache.ignite.internal.cli.sql.SqlQueryResult;

public class SqlQueryCall
implements Call<StringCallInput, SqlQueryResult> {
    private final SqlManager sqlManager;

    public SqlQueryCall(SqlManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    @Override
    public CallOutput<SqlQueryResult> execute(StringCallInput input) {
        try {
            SqlQueryResult result = this.sqlManager.execute(SqlQueryCall.trimQuotes(input.getString()));
            return DefaultCallOutput.success(result);
        }
        catch (SQLException e) {
            return DefaultCallOutput.failure(e);
        }
    }

    private static String trimQuotes(String input) {
        if (input.startsWith("\"") && input.endsWith("\"") && input.length() > 2) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }
}

