/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SignatureData
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=456");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=458");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=457");
    private final String algorithm;
    private final ByteString signature;

    public SignatureData(String algorithm, ByteString signature) {
        this.algorithm = algorithm;
        this.signature = signature;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public ByteString getSignature() {
        return this.signature;
    }

    protected SignatureData(SignatureDataBuilder<?, ?> b) {
        super(b);
        this.algorithm = ((SignatureDataBuilder)b).algorithm;
        this.signature = ((SignatureDataBuilder)b).signature;
    }

    public static SignatureDataBuilder<?, ?> builder() {
        return new SignatureDataBuilderImpl();
    }

    public SignatureDataBuilder<?, ?> toBuilder() {
        return new SignatureDataBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignatureData)) {
            return false;
        }
        SignatureData other = (SignatureData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        ByteString this$signature = this.getSignature();
        ByteString other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignatureData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        ByteString $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SignatureData(algorithm=" + this.getAlgorithm() + ", signature=" + this.getSignature() + ")";
    }

    private static final class SignatureDataBuilderImpl
    extends SignatureDataBuilder<SignatureData, SignatureDataBuilderImpl> {
        private SignatureDataBuilderImpl() {
        }

        @Override
        protected SignatureDataBuilderImpl self() {
            return this;
        }

        @Override
        public SignatureData build() {
            return new SignatureData(this);
        }
    }

    public static abstract class SignatureDataBuilder<C extends SignatureData, B extends SignatureDataBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String algorithm;
        private ByteString signature;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SignatureDataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SignatureData instance, SignatureDataBuilder<?, ?> b) {
            b.algorithm(instance.algorithm);
            b.signature(instance.signature);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B algorithm(String algorithm) {
            this.algorithm = algorithm;
            return (B)this.self();
        }

        public B signature(ByteString signature) {
            this.signature = signature;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SignatureData.SignatureDataBuilder(super=" + super.toString() + ", algorithm=" + this.algorithm + ", signature=" + this.signature + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SignatureData> {
        @Override
        public Class<SignatureData> getType() {
            return SignatureData.class;
        }

        @Override
        public SignatureData decode(SerializationContext context, UaDecoder decoder) {
            String algorithm = decoder.readString("Algorithm");
            ByteString signature = decoder.readByteString("Signature");
            return new SignatureData(algorithm, signature);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SignatureData value) {
            encoder.writeString("Algorithm", value.getAlgorithm());
            encoder.writeByteString("Signature", value.getSignature());
        }
    }
}

