/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PollTabletsPayload
implements SubscriptionPollPayload {
    private transient SubscriptionCommitContext commitContext;
    private transient int offset;

    public SubscriptionCommitContext getCommitContext() {
        return this.commitContext;
    }

    public int getOffset() {
        return this.offset;
    }

    public PollTabletsPayload() {
    }

    public PollTabletsPayload(SubscriptionCommitContext commitContext, int offset) {
        this.commitContext = commitContext;
        this.offset = offset;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        this.commitContext.serialize(stream);
        ReadWriteIOUtils.write((int)this.offset, (OutputStream)stream);
    }

    @Override
    public SubscriptionPollPayload deserialize(ByteBuffer buffer) {
        this.commitContext = SubscriptionCommitContext.deserialize(buffer);
        this.offset = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PollTabletsPayload that = (PollTabletsPayload)obj;
        return Objects.equals(this.commitContext, that.commitContext) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.commitContext, this.offset);
    }

    public String toString() {
        return "PollTabletsPayload{commitContext=" + this.commitContext + ", offset=" + this.offset + "}";
    }
}

