/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.OverlapStatistic;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.OverlapStatisticTool;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.SequenceFileSubTaskThreadExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.tool.TimePartitionProcessTask;

public class TimePartitionProcessWorker {
    private final List<TimePartitionProcessTask> workerTaskList = new ArrayList<TimePartitionProcessTask>();
    private final List<OverlapStatistic> workerResults = new ArrayList<OverlapStatistic>();

    public void addTask(TimePartitionProcessTask task) {
        this.workerTaskList.add(task);
    }

    public void run(CountDownLatch latch) {
        new Thread(() -> {
            SequenceFileSubTaskThreadExecutor fileProcessTaskExecutor = new SequenceFileSubTaskThreadExecutor(OverlapStatisticTool.subTaskNum);
            while (!this.workerTaskList.isEmpty()) {
                TimePartitionProcessTask task = this.workerTaskList.remove(0);
                OverlapStatistic partialRet = null;
                try {
                    partialRet = task.processTimePartition(fileProcessTaskExecutor);
                }
                catch (InterruptedException e) {
                    fileProcessTaskExecutor.shutdown();
                    Thread.currentThread().interrupt();
                    return;
                }
                this.workerResults.add(partialRet);
            }
            latch.countDown();
            fileProcessTaskExecutor.shutdown();
        }).start();
    }

    public List<OverlapStatistic> getWorkerResults() {
        return this.workerResults;
    }
}

