/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.leaf;

import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;

public class TimeColumnTransformer
extends LeafColumnTransformer {
    public TimeColumnTransformer(Type returnType) {
        super(returnType);
    }

    @Override
    protected void evaluate() {
        this.initializeColumnCache(this.input.getTimeColumn());
    }

    @Override
    public void evaluateWithSelection(boolean[] selection) {
        ColumnBuilder builder = TimestampType.TIMESTAMP.createColumnBuilder(selection.length);
        Column timeColumn = this.input.getTimeColumn();
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i] || timeColumn.isNull(i)) {
                builder.appendNull();
                continue;
            }
            builder.write(timeColumn, i);
        }
        this.initializeColumnCache(builder.build());
    }
}

