/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.udf.utils.UDFBinaryTransformer;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.commons.utils.BlobUtils;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFParameterNotValidException;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;

public class UDTFConst
implements UDTF {
    private static final Set<String> VALID_TYPES = new HashSet<String>();
    private TSDataType dataType;
    private int intValue;
    private long longValue;
    private float floatValue;
    private double doubleValue;
    private boolean booleanValue;
    private Binary binaryValue;

    public void validate(UDFParameterValidator validator) throws UDFParameterNotValidException {
        validator.validateRequiredAttribute("value").validateRequiredAttribute("type").validate(type -> VALID_TYPES.contains((String)type), "the given value type is not supported.", (Object)validator.getParameters().getString("type"));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.dataType = TSDataType.valueOf((String)parameters.getString("type"));
        switch (this.dataType) {
            case INT32: {
                this.intValue = Integer.parseInt(parameters.getString("value"));
                break;
            }
            case DATE: {
                this.intValue = DateUtils.parseDateExpressionToInt((String)parameters.getString("value"));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValue = Long.parseLong(parameters.getString("value"));
                break;
            }
            case FLOAT: {
                this.floatValue = Float.parseFloat(parameters.getString("value"));
                break;
            }
            case DOUBLE: {
                this.doubleValue = Double.parseDouble(parameters.getString("value"));
                break;
            }
            case BOOLEAN: {
                this.booleanValue = Boolean.parseBoolean(parameters.getString("value"));
                break;
            }
            case TEXT: 
            case STRING: {
                this.binaryValue = BytesUtils.valueOf((String)parameters.getString("value"));
                break;
            }
            case BLOB: {
                this.binaryValue = new Binary(BlobUtils.parseBlobString(parameters.getString("value")));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.dataType));
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        switch (this.dataType) {
            case INT32: 
            case DATE: {
                collector.putInt(row.getTime(), this.intValue);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                collector.putLong(row.getTime(), this.longValue);
                break;
            }
            case FLOAT: {
                collector.putFloat(row.getTime(), this.floatValue);
                break;
            }
            case DOUBLE: {
                collector.putDouble(row.getTime(), this.doubleValue);
                break;
            }
            case BOOLEAN: {
                collector.putBoolean(row.getTime(), this.booleanValue);
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                collector.putBinary(row.getTime(), UDFBinaryTransformer.transformToUDFBinary(this.binaryValue));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public Object transform(Row row) throws IOException {
        switch (this.dataType) {
            case INT32: 
            case DATE: {
                return this.intValue;
            }
            case INT64: 
            case TIMESTAMP: {
                return this.longValue;
            }
            case FLOAT: {
                return Float.valueOf(this.floatValue);
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case BOOLEAN: {
                return this.booleanValue;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                return UDFBinaryTransformer.transformToUDFBinary(this.binaryValue);
            }
        }
        throw new UnsupportedOperationException();
    }

    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        int count = columns[0].getPositionCount();
        switch (this.dataType) {
            case INT32: 
            case DATE: {
                for (int i = 0; i < count; ++i) {
                    boolean hasWritten = false;
                    for (int j = 0; j < columns.length - 1; ++j) {
                        if (columns[j].isNull(i)) continue;
                        builder.writeInt(this.intValue);
                        hasWritten = true;
                        break;
                    }
                    if (hasWritten) continue;
                    builder.appendNull();
                }
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                for (int i = 0; i < count; ++i) {
                    boolean hasWritten = false;
                    for (int j = 0; j < columns.length - 1; ++j) {
                        if (columns[j].isNull(i)) continue;
                        builder.writeLong(this.longValue);
                        hasWritten = true;
                        break;
                    }
                    if (hasWritten) continue;
                    builder.appendNull();
                }
                return;
            }
            case FLOAT: {
                for (int i = 0; i < count; ++i) {
                    boolean hasWritten = false;
                    for (int j = 0; j < columns.length - 1; ++j) {
                        if (columns[j].isNull(i)) continue;
                        builder.writeFloat(this.floatValue);
                        hasWritten = true;
                        break;
                    }
                    if (hasWritten) continue;
                    builder.appendNull();
                }
                return;
            }
            case DOUBLE: {
                for (int i = 0; i < count; ++i) {
                    boolean hasWritten = false;
                    for (int j = 0; j < columns.length - 1; ++j) {
                        if (columns[j].isNull(i)) continue;
                        builder.writeDouble(this.doubleValue);
                        hasWritten = true;
                        break;
                    }
                    if (hasWritten) continue;
                    builder.appendNull();
                }
                return;
            }
            case BOOLEAN: {
                for (int i = 0; i < count; ++i) {
                    boolean hasWritten = false;
                    for (int j = 0; j < columns.length - 1; ++j) {
                        if (columns[j].isNull(i)) continue;
                        builder.writeBoolean(this.booleanValue);
                        hasWritten = true;
                        break;
                    }
                    if (hasWritten) continue;
                    builder.appendNull();
                }
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                for (int i = 0; i < count; ++i) {
                    boolean hasWritten = false;
                    for (int j = 0; j < columns.length - 1; ++j) {
                        if (columns[j].isNull(i)) continue;
                        builder.writeBinary(this.binaryValue);
                        hasWritten = true;
                        break;
                    }
                    if (hasWritten) continue;
                    builder.appendNull();
                }
                return;
            }
        }
        throw new UnsupportedOperationException();
    }

    static {
        VALID_TYPES.add(TSDataType.INT32.name());
        VALID_TYPES.add(TSDataType.DATE.name());
        VALID_TYPES.add(TSDataType.INT64.name());
        VALID_TYPES.add(TSDataType.TIMESTAMP.name());
        VALID_TYPES.add(TSDataType.FLOAT.name());
        VALID_TYPES.add(TSDataType.DOUBLE.name());
        VALID_TYPES.add(TSDataType.BOOLEAN.name());
        VALID_TYPES.add(TSDataType.TEXT.name());
        VALID_TYPES.add(TSDataType.STRING.name());
        VALID_TYPES.add(TSDataType.BLOB.name());
    }
}

