/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.tsfile.read.common.block.TsBlock;

public class AscLongTypeIgnoreEqualJoinKeyComparator
implements JoinKeyComparator {
    private static final AscLongTypeIgnoreEqualJoinKeyComparator INSTANCE = new AscLongTypeIgnoreEqualJoinKeyComparator();

    private AscLongTypeIgnoreEqualJoinKeyComparator() {
    }

    public static AscLongTypeIgnoreEqualJoinKeyComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public Optional<Boolean> lessThan(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getLong(leftRowIndex) <= right.getColumn(rightColumnIndex).getLong(rightRowIndex));
    }

    @Override
    public Optional<Boolean> equalsTo(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getLong(leftRowIndex) == right.getColumn(rightColumnIndex).getLong(rightRowIndex));
    }

    @Override
    public Optional<Boolean> lessThanOrEqual(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getLong(leftRowIndex) < right.getColumn(rightColumnIndex).getLong(rightRowIndex));
    }
}

