/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SourceNode;

public abstract class SchemaQueryScanNode
extends SourceNode {
    protected long limit;
    protected long offset;
    protected PartialPath path;
    protected PathPatternTree scope;
    private boolean hasLimit;
    protected boolean isPrefixPath;
    private TRegionReplicaSet schemaRegionReplicaSet;

    protected SchemaQueryScanNode(PlanNodeId id) {
        this(id, null, false, SchemaConstant.ALL_MATCH_SCOPE);
    }

    protected SchemaQueryScanNode(PlanNodeId id, PartialPath partialPath, long limit, long offset, boolean isPrefixPath, PathPatternTree scope) {
        super(id);
        this.path = partialPath;
        this.scope = scope;
        this.setLimit(limit);
        this.offset = offset;
        this.isPrefixPath = isPrefixPath;
    }

    protected SchemaQueryScanNode(PlanNodeId id, PartialPath partialPath, boolean isPrefixPath, PathPatternTree scope) {
        this(id, partialPath, 0L, 0L, isPrefixPath, scope);
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public void close() throws Exception {
    }

    public List<PartialPath> getPathPatternList() {
        return Collections.singletonList(this.path);
    }

    public void setPathPatternList(List<PartialPath> pathPatternList) {
        if (pathPatternList.size() == 1) {
            this.path = pathPatternList.get(0);
        }
    }

    public boolean isPrefixPath() {
        return this.isPrefixPath;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
        this.hasLimit = limit != 0L;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.schemaRegionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet schemaRegionReplicaSet) {
        this.schemaRegionReplicaSet = schemaRegionReplicaSet;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public PathPatternTree getScope() {
        return this.scope;
    }

    public void setScope(PathPatternTree scope) {
        this.scope = scope;
    }

    public boolean isHasLimit() {
        return this.hasLimit;
    }

    public void setHasLimit(boolean hasLimit) {
        this.hasLimit = hasLimit;
    }

    public String toString() {
        return String.format("SchemaQueryScanNode-%s:[Path: %s, DataRegion: %s]", this.getPlanNodeId(), this.path, PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSchemaQueryScan(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaQueryScanNode that = (SchemaQueryScanNode)o;
        return this.limit == that.limit && this.offset == that.offset && this.isPrefixPath == that.isPrefixPath && Objects.equals(this.path, that.path) && Objects.equals(this.scope, that.scope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.limit, this.offset, this.path, this.scope, this.isPrefixPath);
    }
}

