/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class MultiTVListIterator
implements MemPointIterator {
    protected TSDataType tsDataType;
    protected List<TVList.TVListIterator> tvListIterators;
    protected List<TsBlock> tsBlocks;
    protected int floatPrecision;
    protected TSEncoding encoding;
    protected boolean probeNext = false;
    protected boolean hasNext = false;
    protected long currentTime = 0L;
    protected int iteratorIndex = 0;
    protected int rowIndex = 0;
    protected final int maxNumberOfPointsInPage;

    protected MultiTVListIterator(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        this.tsDataType = tsDataType;
        this.tvListIterators = new ArrayList<TVList.TVListIterator>(tvLists.size());
        for (TVList tvList : tvLists) {
            this.tvListIterators.add(tvList.iterator(deletionList, null, null, maxNumberOfPointsInPage));
        }
        this.floatPrecision = floatPrecision != null ? floatPrecision : 0;
        this.encoding = encoding;
        this.tsBlocks = new ArrayList<TsBlock>();
        this.maxNumberOfPointsInPage = maxNumberOfPointsInPage;
    }

    public boolean hasNextTimeValuePair() {
        if (!this.probeNext) {
            this.prepareNext();
        }
        return this.hasNext;
    }

    public TimeValuePair nextTimeValuePair() {
        if (!this.hasNextTimeValuePair()) {
            return null;
        }
        TVList.TVListIterator iterator = this.tvListIterators.get(this.iteratorIndex);
        TimeValuePair currentTvPair = iterator.getTVList().getTimeValuePair(this.rowIndex, this.currentTime, this.floatPrecision, this.encoding);
        this.next();
        return currentTvPair;
    }

    public TimeValuePair currentTimeValuePair() {
        if (!this.hasNextTimeValuePair()) {
            return null;
        }
        TVList.TVListIterator iterator = this.tvListIterators.get(this.iteratorIndex);
        return iterator.getTVList().getTimeValuePair(this.rowIndex, this.currentTime, this.floatPrecision, this.encoding);
    }

    @Override
    public boolean hasNextBatch() {
        return this.hasNextTimeValuePair();
    }

    @Override
    public TsBlock nextBatch() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.tsDataType));
        while (this.hasNextTimeValuePair() && builder.getPositionCount() < this.maxNumberOfPointsInPage) {
            TVList.TVListIterator iterator = this.tvListIterators.get(this.iteratorIndex);
            builder.getTimeColumnBuilder().writeLong(this.currentTime);
            switch (this.tsDataType) {
                case BOOLEAN: {
                    builder.getColumnBuilder(0).writeBoolean(iterator.getTVList().getBoolean(this.rowIndex));
                    break;
                }
                case INT32: 
                case DATE: {
                    builder.getColumnBuilder(0).writeInt(iterator.getTVList().getInt(this.rowIndex));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    builder.getColumnBuilder(0).writeLong(iterator.getTVList().getLong(this.rowIndex));
                    break;
                }
                case FLOAT: {
                    TVList floatTvList = iterator.getTVList();
                    builder.getColumnBuilder(0).writeFloat(floatTvList.roundValueWithGivenPrecision(floatTvList.getFloat(this.rowIndex), this.floatPrecision, this.encoding));
                    break;
                }
                case DOUBLE: {
                    TVList doubleTvList = iterator.getTVList();
                    builder.getColumnBuilder(0).writeDouble(doubleTvList.roundValueWithGivenPrecision(doubleTvList.getDouble(this.rowIndex), this.floatPrecision, this.encoding));
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    builder.getColumnBuilder(0).writeBinary(iterator.getTVList().getBinary(this.rowIndex));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.tsDataType));
                }
            }
            this.next();
            builder.declarePosition();
        }
        TsBlock tsBlock = builder.build();
        this.tsBlocks.add(tsBlock);
        return tsBlock;
    }

    @Override
    public TsBlock getBatch(int tsBlockIndex) {
        if (tsBlockIndex < 0 || tsBlockIndex >= this.tsBlocks.size()) {
            return null;
        }
        return this.tsBlocks.get(tsBlockIndex);
    }

    public long getUsedMemorySize() {
        return 0L;
    }

    public void close() throws IOException {
        this.tsBlocks.clear();
    }

    protected abstract void prepareNext();

    protected abstract void next();
}

