/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.jndi;

import java.util.Properties;
import javax.naming.NamingException;
import org.apache.shiro.jndi.JndiTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiLocator {
    public static final String CONTAINER_PREFIX = "java:comp/env/";
    private static final Logger LOGGER = LoggerFactory.getLogger(JndiLocator.class);
    private boolean resourceRef;
    private JndiTemplate jndiTemplate = new JndiTemplate();

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate != null ? jndiTemplate : new JndiTemplate();
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiTemplate = new JndiTemplate(jndiEnvironment);
    }

    public Properties getJndiEnvironment() {
        return this.jndiTemplate.getEnvironment();
    }

    public void setResourceRef(boolean resourceRef) {
        this.resourceRef = resourceRef;
    }

    public boolean isResourceRef() {
        return this.resourceRef;
    }

    protected Object lookup(String jndiName) throws NamingException {
        return this.lookup(jndiName, null);
    }

    protected Object lookup(String jndiName, Class requiredType) throws NamingException {
        Object jndiObject;
        if (jndiName == null) {
            throw new IllegalArgumentException("jndiName argument must not be null");
        }
        String convertedName = this.convertJndiName(jndiName);
        try {
            jndiObject = this.getJndiTemplate().lookup(convertedName, requiredType);
        }
        catch (NamingException ex) {
            if (!convertedName.equals(jndiName)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Converted JNDI name [" + convertedName + "] not found - trying original name [" + jndiName + "]. " + String.valueOf(ex));
                }
                jndiObject = this.getJndiTemplate().lookup(jndiName, requiredType);
            }
            throw ex;
        }
        LOGGER.debug("Located object with JNDI name '{}'", (Object)convertedName);
        return jndiObject;
    }

    protected String convertJndiName(String jndiName) {
        if (this.isResourceRef() && !((String)jndiName).startsWith(CONTAINER_PREFIX) && ((String)jndiName).indexOf(58) == -1) {
            jndiName = CONTAINER_PREFIX + (String)jndiName;
        }
        return jndiName;
    }
}

