/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Date;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.RequestedDate;

@XmlType(name="MI_RequestedDate_Type", propOrder={"requestedDateOfCollection", "latestAcceptableDate"})
@XmlRootElement(name="MI_RequestedDate")
public class DefaultRequestedDate
extends ISOMetadata
implements RequestedDate {
    private static final long serialVersionUID = 942236885315159329L;
    private long requestedDateOfCollection = Long.MIN_VALUE;
    private long latestAcceptableDate = Long.MIN_VALUE;

    public DefaultRequestedDate() {
    }

    public DefaultRequestedDate(RequestedDate object) {
        super(object);
        if (object != null) {
            this.requestedDateOfCollection = ImplementationHelper.toMilliseconds(object.getRequestedDateOfCollection());
            this.latestAcceptableDate = ImplementationHelper.toMilliseconds(object.getLatestAcceptableDate());
        }
    }

    public static DefaultRequestedDate castOrCopy(RequestedDate object) {
        if (object == null || object instanceof DefaultRequestedDate) {
            return (DefaultRequestedDate)object;
        }
        return new DefaultRequestedDate(object);
    }

    @Override
    @XmlElement(name="requestedDateOfCollection", required=true)
    public Date getRequestedDateOfCollection() {
        return ImplementationHelper.toDate(this.requestedDateOfCollection);
    }

    public void setRequestedDateOfCollection(Date newValue) {
        this.checkWritePermission(ImplementationHelper.toDate(this.requestedDateOfCollection));
        this.requestedDateOfCollection = ImplementationHelper.toMilliseconds(newValue);
    }

    @Override
    @XmlElement(name="latestAcceptableDate", required=true)
    public Date getLatestAcceptableDate() {
        return ImplementationHelper.toDate(this.latestAcceptableDate);
    }

    public void setLatestAcceptableDate(Date newValue) {
        this.checkWritePermission(ImplementationHelper.toDate(this.latestAcceptableDate));
        this.latestAcceptableDate = ImplementationHelper.toMilliseconds(newValue);
    }
}

