/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFDirLangString;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException0;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProviderJenaIRI;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.langtagx.LangTagX;
import org.apache.jena.riot.system.CheckerJenaIRI;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.SplitIRI;
import org.apache.jena.vocabulary.RDF;

public class Checker {
    private static ErrorHandler nullErrorHandler = new ErrorHandler(){

        @Override
        public void warning(String message, long line, long col) {
        }

        @Override
        public void error(String message, long line, long col) {
        }

        @Override
        public void fatal(String message, long line, long col) {
        }
    };

    public static boolean check(Node node) {
        return Checker.check(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean check(Node node, ErrorHandler errorHandler, long line, long col) {
        if (node.isURI()) {
            return Checker.checkIRI(node, errorHandler, line, col);
        }
        if (node.isBlank()) {
            return Checker.checkBlankNode(node, errorHandler, line, col);
        }
        if (node.isLiteral()) {
            return Checker.checkLiteral(node, errorHandler, line, col);
        }
        if (node.isVariable()) {
            return Checker.checkVar(node, errorHandler, line, col);
        }
        if (node.isTripleTerm()) {
            Triple t = node.getTriple();
            return Checker.check(t.getSubject()) && Checker.check(t.getPredicate()) && Checker.check(t.getObject()) && Checker.checkTriple(t);
        }
        Checker.errorHandler(errorHandler).warning("Not a recognized node: ", line, col);
        return false;
    }

    public static boolean checkIRI(Node node) {
        return Checker.checkIRI(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkIRI(Node node, ErrorHandler errorHandler, long line, long col) {
        if (!node.isURI()) {
            Checker.errorHandler(errorHandler).error("Not a URI: " + String.valueOf(node), line, col);
            return false;
        }
        return Checker.checkIRI(node.getURI(), errorHandler, line, col);
    }

    public static boolean checkIRI(String iriStr, ErrorHandler errorHandler, long line, long col) {
        try {
            IRIx iri2 = IRIs.reference(iriStr);
            if (iri2 instanceof IRIProviderJenaIRI.IRIxJena) {
                IRIProviderJenaIRI.IRIxJena jiri = (IRIProviderJenaIRI.IRIxJena)iri2;
                IRI jenaIRI = jiri.getImpl();
                return CheckerJenaIRI.iriViolations(jenaIRI, errorHandler, line, col);
            }
            if (!iri2.hasViolations()) {
                return true;
            }
            iri2.handleViolations((isError, message) -> errorHandler.warning((String)message, line, col));
            return false;
        }
        catch (IRIException ex) {
            errorHandler.warning(ex.getMessage(), line, col);
            return false;
        }
    }

    public static void iriViolationMessage(String iriStr, boolean isError, String msg, long line, long col, ErrorHandler errorHandler) {
        try {
            if (isError) {
                Checker.errorHandler(errorHandler).warning("Bad IRI: " + msg, line, col);
            } else {
                Checker.errorHandler(errorHandler).warning("Unwise IRI: " + msg, line, col);
            }
        }
        catch (IRIException0 | IRIException runtimeException) {
            // empty catch block
        }
    }

    public static boolean checkLiteral(Node node) {
        return Checker.checkLiteral(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkLiteral(Node node, ErrorHandler errorHandler, long line, long col) {
        if (!node.isLiteral()) {
            Checker.errorHandler(errorHandler).error("Not a literal: " + String.valueOf(node), line, col);
            return false;
        }
        return Checker.checkLiteral(node.getLiteralLexicalForm(), node.getLiteralLanguage(), node.getLiteralBaseDirection(), node.getLiteralDatatype(), errorHandler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkLiteral(lexicalForm, null, (TextDirection)null, datatype, errorHandler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, String lang, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkLiteral(lexicalForm, lang, (TextDirection)null, null, errorHandler, line, col);
    }

    @Deprecated
    public static boolean checkLiteral(String lexicalForm, String lang, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkLiteral(lexicalForm, lang, (TextDirection)null, datatype, errorHandler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, String lang, String direction, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        TextDirection textDir = null;
        if (direction != null && (textDir = TextDirection.createOrNull(direction)) == null) {
            Checker.errorHandler(errorHandler).error("Language direction not valid: " + direction, line, col);
        }
        return Checker.checkLiteral(lexicalForm, lang, textDir, datatype, errorHandler, line, col);
    }

    public static boolean checkLiteral(String lexicalForm, String lang, TextDirection direction, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        boolean hasDatatype;
        boolean hasLang = lang != null && !lang.isEmpty();
        boolean hasTextDirection = direction != null;
        boolean bl = hasDatatype = datatype != null;
        if (!hasDatatype && !hasLang) {
            return true;
        }
        if (hasLang) {
            if (!LangTagX.checkLanguageTag(lang)) {
                Checker.errorHandler(errorHandler).warning("Language not valid: " + lang, line, col);
                return false;
            }
            if (hasDatatype) {
                if (hasTextDirection && !datatype.equals(RDFDirLangString.rdfDirLangString)) {
                    Checker.errorHandler(errorHandler).error("Literal has language and base direction but wrong datatype: " + String.valueOf(datatype), line, col);
                    return false;
                }
                if (!datatype.equals(RDFLangString.rdfLangString)) {
                    Checker.errorHandler(errorHandler).error("Literal has language but wrong datatype: " + datatype.getURI(), line, col);
                    return false;
                }
            }
            return true;
        }
        if (hasTextDirection) {
            Checker.errorHandler(errorHandler).error("Language base direction without language", line, col);
        }
        if (datatype.equals(XSDDatatype.XSDstring)) {
            return true;
        }
        if (datatype.equals(RDF.dtLangString)) {
            Checker.errorHandler(errorHandler).warning("Literal has datatype " + datatype.getURI() + " but no language tag", line, col);
            return false;
        }
        if (datatype.equals(RDF.dtDirLangString)) {
            Checker.errorHandler(errorHandler).warning("Literal has datatype " + datatype.getURI() + " but no language tag and no base direction", line, col);
            return false;
        }
        return Checker.validateByDatatype(lexicalForm, datatype, errorHandler, line, col);
    }

    protected static boolean validateByDatatype(String lexicalForm, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        return Checker.validateByDatatypeJena(lexicalForm, datatype, errorHandler, line, col);
    }

    protected static boolean validateByDatatypeJena(String lexicalForm, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        if (datatype.isValid(lexicalForm)) {
            return true;
        }
        Checker.errorHandler(errorHandler).warning("Lexical form '" + lexicalForm + "' not valid for datatype " + Checker.xsdDatatypeName(datatype), line, col);
        return false;
    }

    protected static boolean checkWhitespace(String lexicalForm, RDFDatatype datatype, ErrorHandler errorHandler, long line, long col) {
        if (lexicalForm.contains(" ")) {
            Checker.errorHandler(errorHandler).warning("Whitespace in " + Checker.xsdDatatypeName(datatype) + " literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (lexicalForm.contains("\n")) {
            Checker.errorHandler(errorHandler).warning("Newline in " + Checker.xsdDatatypeName(datatype) + " literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        if (lexicalForm.contains("\r")) {
            Checker.errorHandler(errorHandler).warning("Newline in " + Checker.xsdDatatypeName(datatype) + " literal: '" + lexicalForm + "'", line, col);
            return false;
        }
        return true;
    }

    private static String xsdDatatypeName(RDFDatatype datatype) {
        return "XSD " + SplitIRI.localname(datatype.getURI());
    }

    public static boolean checkBlankNode(Node node) {
        return Checker.checkBlankNode(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkBlankNode(Node node, ErrorHandler errorHandler, long line, long col) {
        if (!node.isBlank()) {
            Checker.errorHandler(errorHandler).error("Not a blank node: " + String.valueOf(node), line, col);
            return false;
        }
        return Checker.checkBlankNode(node.getBlankNodeLabel(), errorHandler, line, col);
    }

    public static boolean checkBlankNode(String label) {
        return Checker.checkBlankNode(label, null, -1L, -1L);
    }

    public static boolean checkBlankNode(String label, ErrorHandler errorHandler, long line, long col) {
        if (label.indexOf(32) >= 0) {
            Checker.errorHandler(errorHandler).error("Illegal blank node label (contains a space): " + label, line, col);
            return false;
        }
        return true;
    }

    public static boolean checkVar(Node node) {
        return Checker.checkVar(node, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkVar(Node node, ErrorHandler errorHandler, long line, long col) {
        if (node.isVariable()) {
            Checker.errorHandler(errorHandler).error("Not a variable: " + String.valueOf(node), line, col);
            return false;
        }
        return true;
    }

    public static boolean checkTriple(Triple triple) {
        return Checker.checkTriple(triple, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkTriple(Triple triple, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkTriple(triple.getSubject(), triple.getPredicate(), triple.getObject(), errorHandler, line, col);
    }

    public static boolean checkTriple(Node subject, Node predicate, Node object, ErrorHandler errorHandler, long line, long col) {
        boolean rc = true;
        if (subject == null || !subject.isURI() && !subject.isBlank()) {
            Checker.errorHandler(errorHandler).error("Subject is not a URI or blank node", line, col);
            rc = false;
        }
        if (predicate == null || !predicate.isURI()) {
            Checker.errorHandler(errorHandler).error("Predicate not a URI", line, col);
            rc = false;
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            Checker.errorHandler(errorHandler).error("Object is not a URI, blank node or literal", line, col);
            rc = false;
        }
        return rc;
    }

    public static boolean checkQuad(Quad quad) {
        return Checker.checkQuad(quad, nullErrorHandler, -1L, -1L);
    }

    public static boolean checkQuad(Quad quad, ErrorHandler errorHandler, long line, long col) {
        return Checker.checkQuad(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject(), errorHandler, line, col);
    }

    public static boolean checkQuad(Node graph, Node subject, Node predicate, Node object, ErrorHandler errorHandler, long line, long col) {
        boolean rc = true;
        if (graph == null || !graph.isURI() && !graph.isBlank()) {
            Checker.errorHandler(errorHandler).error("Graph name is not a URI or blank node", line, col);
            rc = false;
        }
        if (subject == null || !subject.isURI() && !subject.isBlank() && !subject.isTripleTerm()) {
            Checker.errorHandler(errorHandler).error("Subject is not a URI, blank node or RDF-star triple term", line, col);
            rc = false;
        }
        if (predicate == null || !predicate.isURI()) {
            Checker.errorHandler(errorHandler).error("Predicate not a URI", line, col);
            rc = false;
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral() && !subject.isTripleTerm()) {
            Checker.errorHandler(errorHandler).error("Object is not a URI, blank node, literal or RDF-star triple term", line, col);
            rc = false;
        }
        return rc;
    }

    private static ErrorHandler errorHandler(ErrorHandler handler) {
        return handler != null ? handler : ErrorHandlerFactory.errorHandlerStd;
    }
}

