/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.reassign;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.tools.reassign.LogDirMoveState;
import org.apache.kafka.tools.reassign.PartitionReassignmentState;

public final class VerifyAssignmentResult {
    public final Map<TopicPartition, PartitionReassignmentState> partStates;
    public final boolean partsOngoing;
    public final Map<TopicPartitionReplica, LogDirMoveState> moveStates;
    public final boolean movesOngoing;

    public VerifyAssignmentResult(Map<TopicPartition, PartitionReassignmentState> partStates) {
        this(partStates, false, Collections.emptyMap(), false);
    }

    public VerifyAssignmentResult(Map<TopicPartition, PartitionReassignmentState> partStates, boolean partsOngoing, Map<TopicPartitionReplica, LogDirMoveState> moveStates, boolean movesOngoing) {
        this.partStates = partStates;
        this.partsOngoing = partsOngoing;
        this.moveStates = moveStates;
        this.movesOngoing = movesOngoing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyAssignmentResult that = (VerifyAssignmentResult)o;
        return this.partsOngoing == that.partsOngoing && this.movesOngoing == that.movesOngoing && Objects.equals(this.partStates, that.partStates) && Objects.equals(this.moveStates, that.moveStates);
    }

    public int hashCode() {
        return Objects.hash(this.partStates, this.partsOngoing, this.moveStates, this.movesOngoing);
    }
}

