/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.MaterializedStoreFactory;
import org.apache.kafka.streams.state.DslSessionParams;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;

public class SessionStoreMaterializer<K, V>
extends MaterializedStoreFactory<K, V, SessionStore<Bytes, byte[]>> {
    private final MaterializedInternal<K, V, SessionStore<Bytes, byte[]>> materialized;
    private final SessionWindows sessionWindows;
    private final EmitStrategy emitStrategy;
    private final long retentionPeriod;

    public SessionStoreMaterializer(MaterializedInternal<K, V, SessionStore<Bytes, byte[]>> materialized, SessionWindows sessionWindows, EmitStrategy emitStrategy) {
        super(materialized);
        this.materialized = materialized;
        this.sessionWindows = sessionWindows;
        this.emitStrategy = emitStrategy;
        this.retentionPeriod = this.retentionPeriod();
        if (sessionWindows.inactivityGap() + sessionWindows.gracePeriodMs() > this.retentionPeriod) {
            throw new IllegalArgumentException("The retention period of the session store " + materialized.storeName() + " must be no smaller than the session inactivity gap plus the grace period. Got gap=[" + sessionWindows.inactivityGap() + "], grace=[" + sessionWindows.gracePeriodMs() + "], retention=[" + this.retentionPeriod + "]");
        }
    }

    @Override
    public StoreBuilder<?> builder() {
        SessionBytesStoreSupplier supplier = this.materialized.storeSupplier() == null ? this.dslStoreSuppliers().sessionStore(new DslSessionParams(this.materialized.storeName(), Duration.ofMillis(this.retentionPeriod), this.emitStrategy)) : (SessionBytesStoreSupplier)this.materialized.storeSupplier();
        StoreBuilder<SessionStore<K, V>> builder = Stores.sessionStoreBuilder(supplier, this.materialized.keySerde(), this.materialized.valueSerde());
        if (this.materialized.loggingEnabled()) {
            builder.withLoggingEnabled(this.materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (this.materialized.cachingEnabled() && this.emitStrategy.type() != EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
            builder.withCachingEnabled();
        } else {
            builder.withCachingDisabled();
        }
        return builder;
    }

    @Override
    public final long retentionPeriod() {
        return this.materialized.retention() != null ? this.materialized.retention().toMillis() : this.sessionWindows.inactivityGap() + this.sessionWindows.gracePeriodMs();
    }

    @Override
    public long historyRetention() {
        throw new IllegalStateException("historyRetention is not supported when not a versioned store");
    }

    @Override
    public boolean isWindowStore() {
        return true;
    }

    @Override
    public boolean isVersionedStore() {
        return false;
    }
}

