/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.remote.RemoteLogManager;
import kafka.server.ConfigHandler;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.StopPartition;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0006\r\u0001EA\u0001B\t\u0001\u0003\u0006\u0004%Ia\t\u0005\tO\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005-\u0001\t\u0015\r\u0011\"\u0001.\u0011!a\u0004A!A!\u0002\u0013q\u0003\"B\u001f\u0001\t\u0003q\u0004\"B\"\u0001\t\u0013!\u0005B\u0002/\u0001\t\u0003aQ\fC\u0003u\u0001\u0011\u0005Q\u000fC\u0003y\u0001\u0011\u0005\u0011P\u0001\nU_BL7mQ8oM&<\u0007*\u00198eY\u0016\u0014(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0011\u0002\u0004\b\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eQR\"\u0001\u0007\n\u0005ma!!D\"p]\u001aLw\rS1oI2,'\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 \u001d\u0005)Q\u000f^5mg&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012\u0001\n\t\u00033\u0015J!A\n\u0007\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\u0006lC\u001a\\\u0017mQ8oM&<\u0007CA\r+\u0013\tYCBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AB9v_R\f7/F\u0001/!\ty\u0013H\u0004\u00021o9\u0011\u0011G\u000e\b\u0003eUj\u0011a\r\u0006\u0003iA\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u00055q\u0011B\u0001\u001d\r\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\tQ4HA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0003q1\tq!];pi\u0006\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u007f\u0001\u000b%\t\u0005\u0002\u001a\u0001!)!E\u0002a\u0001I!)\u0001F\u0002a\u0001S!)AF\u0002a\u0001]\u0005yQ\u000f\u001d3bi\u0016dunZ\"p]\u001aLw\rF\u0002F\u0011J\u0003\"a\u0005$\n\u0005\u001d#\"\u0001B+oSRDQ!S\u0004A\u0002)\u000bQ\u0001^8qS\u000e\u0004\"aS(\u000f\u00051k\u0005C\u0001\u001a\u0015\u0013\tqE#\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(\u0015\u0011\u0015\u0019v\u00011\u0001U\u0003-!x\u000e]5d\u0007>tg-[4\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016\u0001B;uS2T\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\\-\nQ\u0001K]8qKJ$\u0018.Z:\u0002=5\f\u0017PY3Va\u0012\fG/\u001a*f[>$X\rT8h\u0007>l\u0007o\u001c8f]R\u001cH#B#_?6\u0014\b\"B%\t\u0001\u0004Q\u0005\"\u00021\t\u0001\u0004\t\u0017\u0001\u00027pON\u00042AY3h\u001b\u0005\u0019'B\u00013\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003M\u000e\u00141aU3r!\tA7.D\u0001j\u0015\tQg\"A\u0002m_\u001eL!\u0001\\5\u0003\u0015Us\u0017NZ5fI2{w\rC\u0003o\u0011\u0001\u0007q.A\nxCN\u0014V-\\8uK2{w-\u00128bE2,G\r\u0005\u0002\u0014a&\u0011\u0011\u000f\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019\b\u00021\u0001p\u0003=9\u0018m]\"paf$\u0015n]1cY\u0016$\u0017\u0001\u00069s_\u000e,7o]\"p]\u001aLwm\u00115b]\u001e,7\u000fF\u0002Fm^DQ!S\u0005A\u0002)CQaU\u0005A\u0002Q\u000b\u0001\u0004]1sg\u0016$\u0006N]8ui2,G\rU1si&$\u0018n\u001c8t)\u0015Qhp`A\u0002!\r\u0011Wm\u001f\t\u0003'qL!! \u000b\u0003\u0007%sG\u000fC\u0003T\u0015\u0001\u0007A\u000b\u0003\u0004\u0002\u0002)\u0001\ra_\u0001\tEJ|7.\u001a:JI\"1\u0011Q\u0001\u0006A\u0002)\u000bA\u0001\u001d:pa\u0002")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private void updateLogConfig(String topic, Properties topicConfig) {
        LogManager logManager = this.replicaManager().logManager();
        Seq<UnifiedLog> logs = logManager.logsByTopic(topic);
        boolean wasRemoteLogEnabled = logs.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.remoteLogEnabled()));
        boolean wasCopyDisabled = logs.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$2.config().remoteLogCopyDisable())));
        logManager.updateTopicConfig(topic, topicConfig, this.kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled(), wasRemoteLogEnabled);
        this.maybeUpdateRemoteLogComponents(topic, logs, wasRemoteLogEnabled, wasCopyDisabled);
    }

    /*
     * WARNING - void declaration
     */
    public void maybeUpdateRemoteLogComponents(String topic, Seq<UnifiedLog> logs, boolean wasRemoteLogEnabled, boolean wasCopyDisabled) {
        void var10_10;
        void var9_9;
        boolean isRemoteLogEnabled = logs.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.remoteLogEnabled()));
        boolean isCopyDisabled = logs.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$4.config().remoteLogCopyDisable())));
        boolean isDeleteOnDisable = logs.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$5.config().remoteLogDeleteOnDisable())));
        Tuple2 tuple2 = ((IterableOps)logs.flatMap((Function1 & Serializable)log -> this.replicaManager().onlinePartition(log.topicPartition()))).partition((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isLeader()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq leaderPartitions = (Seq)tuple2._1();
        Seq followerPartitions = (Seq)tuple2._2();
        if (isRemoteLogEnabled && (!wasRemoteLogEnabled || wasCopyDisabled && !isCopyDisabled)) {
            Map<String, Uuid> topicIds = Collections.singletonMap(topic, this.replicaManager().metadataCache().getTopicId(topic));
            this.replicaManager().remoteLogManager().foreach(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$6$adapted((Seq)var9_9, (Seq)var10_10, topicIds, arg_0));
        }
        if (isRemoteLogEnabled && !wasCopyDisabled && isCopyDisabled) {
            this.replicaManager().remoteLogManager().foreach(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$7$adapted((Seq)var9_9, arg_0));
        }
        if (wasRemoteLogEnabled && !isRemoteLogEnabled && isDeleteOnDisable) {
            HashSet stopPartitions = new HashSet();
            var9_9.foreach((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)stopPartitions.add(new StopPartition(partition.topicPartition(), false, true, true))));
            var10_10.foreach((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)stopPartitions.add(new StopPartition(partition.topicPartition(), false, false, true))));
            ((IterableOnceOps)logs.filter(arg_0 -> TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$10$adapted((Seq)var9_9, arg_0))).foreach((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)log.maybeIncrementLogStartOffset(log.localLogStartOffset(), LogStartOffsetIncrementReason.SegmentDeletion)));
            this.replicaManager().remoteLogManager().foreach((Function1 & Serializable)rlm -> {
                rlm.stopPartitions(stopPartitions, (x$8, x$9) -> {});
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        this.updateLogConfig(topic, topicConfig);
        this.updateThrottledList$1("leader.replication.throttled.replicas", this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1("follower.replication.throttled.replicas", this.quotas().follower(), topicConfig, topic);
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator.ensureValidString((String)prop, (String)configValue);
        switch (configValue == null ? 0 : configValue.hashCode()) {
            case 0: {
                if (!"".equals(configValue)) break;
                return Nil$.MODULE$;
            }
            case 42: {
                if (!"*".equals(configValue)) break;
                return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ReplicationQuotaManager.ALL_REPLICAS).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$10)))).toSeq();
            }
        }
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$11 -> x$11.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$3(brokerId, x$12)))), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$13[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateRemoteLogComponents$11(UnifiedLog log$1, Partition p) {
        return p.topicPartition().equals((Object)log$1.topicPartition());
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicConfig$1.getProperty(prop)))) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Setting " + prop + " on broker " + $this.kafkaConfig.brokerId() + " for topic: " + topic$1 + " and partitions " + partitions);
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Removing " + prop + " from broker " + $this.kafkaConfig.brokerId() + " for topic " + topic$1);
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$3(int brokerId$1, String[] x$12) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$12[1])) == brokerId$1;
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$6$adapted(Seq leaderPartitions$1, Seq followerPartitions$1, Map topicIds$1, RemoteLogManager rlm) {
        rlm.onLeadershipChange(CollectionConverters$.MODULE$.SetHasAsJava((Set)leaderPartitions$1.toSet()).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)followerPartitions$1.toSet()).asJava(), topicIds$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$7$adapted(Seq leaderPartitions$1, RemoteLogManager rlm) {
        rlm.stopLeaderCopyRLMTasks(CollectionConverters$.MODULE$.SetHasAsJava((Set)leaderPartitions$1.toSet()).asJava());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maybeUpdateRemoteLogComponents$10$adapted(Seq leaderPartitions$1, UnifiedLog log) {
        return BoxesRunTime.boxToBoolean((boolean)leaderPartitions$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$maybeUpdateRemoteLogComponents$11(log, p))));
    }
}

