/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class InputStreamContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker invoker = new SerializedInvoker(InputStreamContentSource.class);
    private final InputStream inputStream;
    private ByteBufferPool.Sized bufferPool;
    private Runnable demandCallback;
    private Content.Chunk errorChunk;
    private boolean closed;

    public InputStreamContentSource(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputStreamContentSource(InputStream inputStream, ByteBufferPool bufferPool) {
        this(inputStream, bufferPool instanceof ByteBufferPool.Sized ? (sized = (ByteBufferPool.Sized)bufferPool) : new ByteBufferPool.Sized(bufferPool));
        ByteBufferPool.Sized sized;
    }

    public InputStreamContentSource(InputStream inputStream, ByteBufferPool.Sized bufferPool) {
        this.inputStream = Objects.requireNonNull(inputStream);
        this.bufferPool = Objects.requireNonNullElse(bufferPool, ByteBufferPool.SIZED_NON_POOLING);
    }

    public int getBufferSize() {
        return this.bufferPool.getSize();
    }

    @Deprecated(forRemoval=true)
    public void setBufferSize(int bufferSize) {
        try (AutoLock ignored = this.lock.lock();){
            if (bufferSize != this.bufferPool.getSize()) {
                this.bufferPool = new ByteBufferPool.Sized(this.bufferPool.getWrapped(), this.bufferPool.isDirect(), bufferSize);
            }
        }
    }

    public boolean isUseDirectByteBuffers() {
        return this.bufferPool.isDirect();
    }

    @Deprecated(forRemoval=true, since="12.0.11")
    public void setUseDirectByteBuffers(boolean useDirectByteBuffers) {
        try (AutoLock ignored = this.lock.lock();){
            if (useDirectByteBuffers != this.bufferPool.isDirect()) {
                this.bufferPool = new ByteBufferPool.Sized(this.bufferPool.getWrapped(), useDirectByteBuffers, this.bufferPool.getSize());
            }
        }
    }

    @Override
    public Content.Chunk read() {
        try (AutoLock ignored = this.lock.lock();){
            if (this.errorChunk != null) {
                Content.Chunk chunk = this.errorChunk;
                return chunk;
            }
            if (this.closed) {
                Content.Chunk chunk = Content.Chunk.EOF;
                return chunk;
            }
        }
        RetainableByteBuffer streamBuffer = this.bufferPool.acquire(false);
        try {
            ByteBuffer buffer = streamBuffer.getByteBuffer();
            int read = this.fillBufferFromInputStream(this.inputStream, buffer.array());
            if (read < 0) {
                streamBuffer.release();
                this.close();
                return Content.Chunk.EOF;
            }
            buffer.limit(read);
            return Content.Chunk.asChunk(buffer, false, streamBuffer);
        }
        catch (Throwable x) {
            streamBuffer.release();
            return this.failure(x);
        }
    }

    protected int fillBufferFromInputStream(InputStream inputStream, byte[] buffer) throws IOException {
        return inputStream.read(buffer, 0, buffer.length);
    }

    private void close() {
        try (AutoLock ignored = this.lock.lock();){
            this.closed = true;
        }
        IO.close((InputStream)this.inputStream);
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            ExceptionUtil.run((Runnable)demandCallback, this::fail);
        }
    }

    @Override
    public void fail(Throwable failure) {
        this.failure(failure);
    }

    private Content.Chunk failure(Throwable failure) {
        Content.Chunk error;
        try (AutoLock ignored = this.lock.lock();){
            error = this.errorChunk;
            if (error == null) {
                error = this.errorChunk = Content.Chunk.from(failure);
            }
        }
        IO.close((InputStream)this.inputStream);
        return error;
    }
}

