/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.UnexpectedAppendOffsetException;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadataFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.AsyncOffsetReadFutureHolder;
import org.apache.kafka.storage.internals.log.AsyncOffsetReader;
import org.apache.kafka.storage.internals.log.BatchMetadata;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.LeaderHwChange;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogLoader;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.apache.kafka.storage.internals.log.OffsetsOutOfOrderException;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.RollParams;
import org.apache.kafka.storage.internals.log.SegmentDeletionReason;
import org.apache.kafka.storage.internals.log.SnapshotFile;
import org.apache.kafka.storage.internals.log.StorageAction;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.storage.internals.log.VerificationStateEntry;
import org.apache.kafka.storage.log.metrics.BrokerTopicMetrics;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedLog
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(UnifiedLog.class);
    public static final String LOG_FILE_SUFFIX = ".log";
    public static final String INDEX_FILE_SUFFIX = ".index";
    public static final String TIME_INDEX_FILE_SUFFIX = ".timeindex";
    public static final String TXN_INDEX_FILE_SUFFIX = ".txnindex";
    public static final String CLEANED_FILE_SUFFIX = ".cleaned";
    public static final String SWAP_FILE_SUFFIX = ".swap";
    public static final String DELETE_DIR_SUFFIX = "-delete";
    public static final String STRAY_DIR_SUFFIX = "-stray";
    public static final long UNKNOWN_OFFSET = -1L;
    private final KafkaMetricsGroup metricsGroup = new KafkaMetricsGroup("kafka.log", "Log");
    private final Object lock = new Object();
    private final Map<String, Map<String, String>> metricNames = new HashMap<String, Map<String, String>>();
    private final LocalLog localLog;
    private final BrokerTopicStats brokerTopicStats;
    private final ProducerStateManager producerStateManager;
    private final boolean remoteStorageSystemEnable;
    private final ScheduledFuture<?> producerExpireCheck;
    private final int producerIdExpirationCheckIntervalMs;
    private final String logIdent;
    private final Logger logger;
    private final Logger futureTimestampLogger;
    private final LogValidator.MetricsRecorder validatorMetricsRecorder;
    private volatile Optional<LogOffsetMetadata> firstUnstableOffsetMetadata = Optional.empty();
    private volatile Optional<PartitionMetadataFile> partitionMetadataFile = Optional.empty();
    private volatile long highestOffsetInRemoteStorage = -1L;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    private volatile long localLogStartOffset;
    private volatile long logStartOffset;
    private volatile LeaderEpochFileCache leaderEpochCache;
    private volatile Optional<Uuid> topicId;
    private volatile LogOffsetsListener logOffsetsListener;

    public UnifiedLog(long logStartOffset, LocalLog localLog, BrokerTopicStats brokerTopicStats, int producerIdExpirationCheckIntervalMs, LeaderEpochFileCache leaderEpochCache, ProducerStateManager producerStateManager, Optional<Uuid> topicId, boolean remoteStorageSystemEnable, LogOffsetsListener logOffsetsListener) throws IOException {
        this.logStartOffset = logStartOffset;
        this.localLog = localLog;
        this.brokerTopicStats = brokerTopicStats;
        this.producerIdExpirationCheckIntervalMs = producerIdExpirationCheckIntervalMs;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.topicId = topicId;
        this.remoteStorageSystemEnable = remoteStorageSystemEnable;
        this.logOffsetsListener = logOffsetsListener;
        this.logIdent = "[UnifiedLog partition=" + String.valueOf(this.topicPartition()) + ", dir=" + this.parentDir() + "] ";
        this.logger = new LogContext(this.logIdent).logger(UnifiedLog.class);
        this.futureTimestampLogger = new LogContext(this.logIdent).logger("LogFutureTimestampLogger");
        this.highWatermarkMetadata = new LogOffsetMetadata(logStartOffset);
        this.localLogStartOffset = logStartOffset;
        this.producerExpireCheck = this.scheduler().schedule("PeriodicProducerExpirationCheck", () -> this.removeExpiredProducers(this.time().milliseconds()), (long)producerIdExpirationCheckIntervalMs, (long)producerIdExpirationCheckIntervalMs);
        this.validatorMetricsRecorder = UnifiedLog.newValidatorMetricsRecorder(brokerTopicStats.allTopicsStats());
        this.initializePartitionMetadata();
        this.updateLogStartOffset(logStartOffset);
        this.updateLocalLogStartOffset(Math.max(logStartOffset, localLog.segments().firstSegmentBaseOffset().orElse(0L)));
        if (!this.remoteLogEnabled()) {
            this.logStartOffset = this.localLogStartOffset;
        }
        this.maybeIncrementFirstUnstableOffset();
        this.initializeTopicId();
        logOffsetsListener.onHighWatermarkUpdated(this.highWatermarkMetadata.messageOffset);
        this.newMetrics();
    }

    public static UnifiedLog create(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, Optional<Uuid> topicId) throws IOException {
        return UnifiedLog.create(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxTransactionTimeoutMs, producerStateManagerConfig, producerIdExpirationCheckIntervalMs, logDirFailureChannel, lastShutdownClean, topicId, new ConcurrentHashMap<String, Integer>(), false, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
    }

    public static UnifiedLog create(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel, boolean lastShutdownClean, Optional<Uuid> topicId, ConcurrentMap<String, Integer> numRemainingSegments, boolean remoteStorageSystemEnable, LogOffsetsListener logOffsetsListener) throws IOException {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        TopicPartition topicPartition = UnifiedLog.parseTopicPartitionName(dir);
        LogSegments segments = new LogSegments(topicPartition);
        LeaderEpochFileCache leaderEpochCache = UnifiedLog.createLeaderEpochCache(dir, topicPartition, logDirFailureChannel, Optional.empty(), scheduler);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxTransactionTimeoutMs, producerStateManagerConfig, time);
        boolean isRemoteLogEnabled = UnifiedLog.isRemoteLogEnabled(remoteStorageSystemEnable, config, topicPartition.topic());
        LoadedLogOffsets offsets = new LogLoader(dir, topicPartition, config, scheduler, time, logDirFailureChannel, lastShutdownClean, segments, logStartOffset, recoveryPoint, leaderEpochCache, producerStateManager, numRemainingSegments, isRemoteLogEnabled).load();
        LocalLog localLog = new LocalLog(dir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
        return new UnifiedLog(offsets.logStartOffset, localLog, brokerTopicStats, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager, topicId, remoteStorageSystemEnable, logOffsetsListener);
    }

    public long localLogStartOffset() {
        return this.localLogStartOffset;
    }

    public LeaderEpochFileCache leaderEpochCache() {
        return this.leaderEpochCache;
    }

    public long logStartOffset() {
        return this.logStartOffset;
    }

    long highestOffsetInRemoteStorage() {
        return this.highestOffsetInRemoteStorage;
    }

    public Optional<PartitionMetadataFile> partitionMetadataFile() {
        return this.partitionMetadataFile;
    }

    public Optional<Uuid> topicId() {
        return this.topicId;
    }

    public File dir() {
        return this.localLog.dir();
    }

    public String parentDir() {
        return this.localLog.parentDir();
    }

    public File parentDirFile() {
        return this.localLog.parentDirFile();
    }

    public String name() {
        return this.localLog.name();
    }

    public long recoveryPoint() {
        return this.localLog.recoveryPoint();
    }

    public TopicPartition topicPartition() {
        return this.localLog.topicPartition();
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.localLog.logDirFailureChannel();
    }

    public LogConfig config() {
        return this.localLog.config();
    }

    public boolean remoteLogEnabled() {
        return UnifiedLog.isRemoteLogEnabled(this.remoteStorageSystemEnable, this.config(), this.topicPartition().topic());
    }

    public ScheduledFuture<?> producerExpireCheck() {
        return this.producerExpireCheck;
    }

    public int producerIdExpirationCheckIntervalMs() {
        return this.producerIdExpirationCheckIntervalMs;
    }

    public void updateLogStartOffsetFromRemoteTier(long remoteLogStartOffset) {
        if (!this.remoteLogEnabled()) {
            this.logger.error("Ignoring the call as the remote log storage is disabled");
            return;
        }
        this.maybeIncrementLogStartOffset(remoteLogStartOffset, LogStartOffsetIncrementReason.SegmentDeletion);
    }

    public void updateLocalLogStartOffset(long offset) throws IOException {
        this.localLogStartOffset = offset;
        if (this.highWatermark() < offset) {
            this.updateHighWatermark(offset);
        }
        if (this.recoveryPoint() < offset) {
            this.localLog.updateRecoveryPoint(offset);
        }
    }

    public void setLogOffsetsListener(LogOffsetsListener listener) {
        this.logOffsetsListener = listener;
    }

    private void initializeTopicId() {
        PartitionMetadataFile partMetadataFile = this.partitionMetadataFile.orElseThrow(() -> new KafkaException("The partitionMetadataFile should have been initialized"));
        if (partMetadataFile.exists()) {
            Uuid fileTopicId = partMetadataFile.read().topicId();
            if (this.topicId.filter(x -> !x.equals((Object)fileTopicId)).isPresent()) {
                throw new InconsistentTopicIdException("Tried to assign topic ID " + String.valueOf(this.topicId) + " to log for topic partition " + String.valueOf(this.topicPartition()) + ",but log already contained topic ID " + String.valueOf(fileTopicId));
            }
            this.topicId = Optional.of(fileTopicId);
        } else {
            this.topicId.ifPresent(partMetadataFile::record);
            this.scheduler().scheduleOnce("flush-metadata-file", this::maybeFlushMetadataFile);
        }
    }

    public LogConfig updateConfig(LogConfig newConfig) {
        LogConfig oldConfig = this.localLog.config();
        this.localLog.updateConfig(newConfig);
        return oldConfig;
    }

    public long highWatermark() {
        return this.highWatermarkMetadata.messageOffset;
    }

    public ProducerStateManager producerStateManager() {
        return this.producerStateManager;
    }

    private Time time() {
        return this.localLog.time();
    }

    private Scheduler scheduler() {
        return this.localLog.scheduler();
    }

    public long updateHighWatermark(long hw) throws IOException {
        return this.updateHighWatermark(new LogOffsetMetadata(hw));
    }

    public long updateHighWatermark(LogOffsetMetadata highWatermarkMetadata) throws IOException {
        LogOffsetMetadata endOffsetMetadata = this.localLog.logEndOffsetMetadata();
        LogOffsetMetadata newHighWatermarkMetadata = highWatermarkMetadata.messageOffset < this.logStartOffset ? new LogOffsetMetadata(this.logStartOffset) : (highWatermarkMetadata.messageOffset >= endOffsetMetadata.messageOffset ? endOffsetMetadata : highWatermarkMetadata);
        this.updateHighWatermarkMetadata(newHighWatermarkMetadata);
        return newHighWatermarkMetadata.messageOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<LogOffsetMetadata> maybeIncrementHighWatermark(LogOffsetMetadata newHighWatermark) throws IOException {
        if (newHighWatermark.messageOffset > this.logEndOffset()) {
            throw new IllegalArgumentException("High watermark " + String.valueOf(newHighWatermark) + " update exceeds current log end offset " + String.valueOf(this.localLog.logEndOffsetMetadata()));
        }
        Object object = this.lock;
        synchronized (object) {
            LogOffsetMetadata oldHighWatermark = this.fetchHighWatermarkMetadata();
            if (oldHighWatermark.messageOffset < newHighWatermark.messageOffset || oldHighWatermark.messageOffset == newHighWatermark.messageOffset && oldHighWatermark.onOlderSegment(newHighWatermark)) {
                this.updateHighWatermarkMetadata(newHighWatermark);
                return Optional.of(oldHighWatermark);
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Long> maybeUpdateHighWatermark(long hw) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            LogOffsetMetadata oldHighWatermark = this.highWatermarkMetadata;
            long newHighWatermark = this.updateHighWatermark(new LogOffsetMetadata(hw));
            return newHighWatermark == oldHighWatermark.messageOffset ? Optional.empty() : Optional.of(newHighWatermark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogOffsetMetadata fetchHighWatermarkMetadata() throws IOException {
        this.localLog.checkIfMemoryMappedBufferClosed();
        LogOffsetMetadata offsetMetadata = this.highWatermarkMetadata;
        if (offsetMetadata.messageOffsetOnly()) {
            Object object = this.lock;
            synchronized (object) {
                LogOffsetMetadata fullOffset = this.maybeConvertToOffsetMetadata(this.highWatermark());
                this.updateHighWatermarkMetadata(fullOffset);
                return fullOffset;
            }
        }
        return offsetMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHighWatermarkMetadata(LogOffsetMetadata newHighWatermark) throws IOException {
        if (newHighWatermark.messageOffset < 0L) {
            throw new IllegalArgumentException("High watermark offset should be non-negative");
        }
        Object object = this.lock;
        synchronized (object) {
            if (newHighWatermark.messageOffset < this.highWatermarkMetadata.messageOffset) {
                this.logger.warn("Non-monotonic update of high watermark from {} to {}", (Object)this.highWatermarkMetadata, (Object)newHighWatermark);
            }
            this.highWatermarkMetadata = newHighWatermark;
            this.producerStateManager.onHighWatermarkUpdated(newHighWatermark.messageOffset);
            this.logOffsetsListener.onHighWatermarkUpdated(newHighWatermark.messageOffset);
            this.maybeIncrementFirstUnstableOffset();
        }
        this.logger.trace("Setting high watermark {}", (Object)newHighWatermark);
    }

    public Optional<Long> firstUnstableOffset() {
        return this.firstUnstableOffsetMetadata.map(uom -> uom.messageOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogOffsetMetadata fetchLastStableOffsetMetadata() throws IOException {
        this.localLog.checkIfMemoryMappedBufferClosed();
        LogOffsetMetadata highWatermarkMetadata = this.fetchHighWatermarkMetadata();
        Optional<LogOffsetMetadata> firstUnstableOffsetMetadataCopy = this.firstUnstableOffsetMetadata;
        if (firstUnstableOffsetMetadataCopy.isPresent() && firstUnstableOffsetMetadataCopy.get().messageOffset < highWatermarkMetadata.messageOffset) {
            LogOffsetMetadata lom = firstUnstableOffsetMetadataCopy.get();
            if (lom.messageOffsetOnly()) {
                Object object = this.lock;
                synchronized (object) {
                    LogOffsetMetadata fullOffset = this.maybeConvertToOffsetMetadata(lom.messageOffset);
                    this.firstUnstableOffsetMetadata = Optional.of(fullOffset);
                    return fullOffset;
                }
            }
            return lom;
        }
        return highWatermarkMetadata;
    }

    public long lastStableOffset() {
        Optional<LogOffsetMetadata> firstUnstableOffsetMetadataCopy = this.firstUnstableOffsetMetadata;
        if (firstUnstableOffsetMetadataCopy.isPresent() && firstUnstableOffsetMetadataCopy.get().messageOffset < this.highWatermark()) {
            return firstUnstableOffsetMetadataCopy.get().messageOffset;
        }
        return this.highWatermark();
    }

    public long lastStableOffsetLag() {
        return this.highWatermark() - this.lastStableOffset();
    }

    public LogOffsetSnapshot fetchOffsetSnapshot() throws IOException {
        LogOffsetMetadata lastStable = this.fetchLastStableOffsetMetadata();
        LogOffsetMetadata highWatermark = this.fetchHighWatermarkMetadata();
        return new LogOffsetSnapshot(this.logStartOffset, this.localLog.logEndOffsetMetadata(), highWatermark, lastStable);
    }

    public void newMetrics() {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("topic", this.topicPartition().topic());
        tags.put("partition", String.valueOf(this.topicPartition().partition()));
        if (this.isFuture()) {
            tags.put("is-future", "true");
        }
        this.metricsGroup.newGauge("NumLogSegments", this::numberOfSegments, tags);
        this.metricsGroup.newGauge("LogStartOffset", this::logStartOffset, tags);
        this.metricsGroup.newGauge("LogEndOffset", this::logEndOffset, tags);
        this.metricsGroup.newGauge("Size", this::size, tags);
        this.metricNames.put("NumLogSegments", tags);
        this.metricNames.put("LogStartOffset", tags);
        this.metricNames.put("LogEndOffset", tags);
        this.metricNames.put("Size", tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredProducers(long currentTimeMs) {
        Object object = this.lock;
        synchronized (object) {
            this.producerStateManager.removeExpiredProducers(currentTimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProducerState(long lastOffset) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.rebuildProducerState(lastOffset, this.producerStateManager);
            this.maybeIncrementFirstUnstableOffset();
            this.updateHighWatermark(this.localLog.logEndOffsetMetadata());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePartitionMetadata() {
        Object object = this.lock;
        synchronized (object) {
            File partitionMetadata = PartitionMetadataFile.newFile(this.dir());
            this.partitionMetadataFile = Optional.of(new PartitionMetadataFile(partitionMetadata, this.logDirFailureChannel()));
        }
    }

    private void maybeFlushMetadataFile() {
        this.partitionMetadataFile.ifPresent(PartitionMetadataFile::maybeFlush);
    }

    public void assignTopicId(Uuid topicId) {
        if (this.topicId.isPresent()) {
            Uuid currentId = this.topicId.get();
            if (!currentId.equals((Object)topicId)) {
                throw new InconsistentTopicIdException("Tried to assign topic ID " + String.valueOf(topicId) + " to log for topic partition " + String.valueOf(this.topicPartition()) + ", but log already contained topic ID " + String.valueOf(currentId));
            }
        } else {
            this.topicId = Optional.of(topicId);
            this.partitionMetadataFile.ifPresentOrElse(file -> {
                if (!file.exists()) {
                    file.record(topicId);
                    this.scheduler().scheduleOnce("flush-metadata-file", this::maybeFlushMetadataFile);
                }
            }, () -> this.logger.warn("The topic id {} will not be persisted to the partition metadata file since the partition is deleted", (Object)topicId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitializeLeaderEpochCache() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.leaderEpochCache = UnifiedLog.createLeaderEpochCache(this.dir(), this.topicPartition(), this.logDirFailureChannel(), Optional.of(this.leaderEpochCache), this.scheduler());
        }
    }

    private void updateHighWatermarkWithLogEndOffset() throws IOException {
        if (this.highWatermark() >= this.localLog.logEndOffset()) {
            this.updateHighWatermarkMetadata(this.localLog.logEndOffsetMetadata());
        }
    }

    private void updateLogStartOffset(long offset) throws IOException {
        this.logStartOffset = offset;
        if (this.highWatermark() < offset) {
            this.updateHighWatermark(offset);
        }
        if (this.localLog.recoveryPoint() < offset) {
            this.localLog.updateRecoveryPoint(offset);
        }
    }

    public void updateHighestOffsetInRemoteStorage(long offset) {
        if (!this.remoteLogEnabled()) {
            this.logger.warn("Unable to update the highest offset in remote storage with offset {} since remote storage is not enabled. The existing highest offset is {}.", (Object)offset, (Object)this.highestOffsetInRemoteStorage());
        } else if (offset > this.highestOffsetInRemoteStorage()) {
            this.highestOffsetInRemoteStorage = offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildProducerState(long lastOffset, ProducerStateManager producerStateManager) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.localLog.checkIfMemoryMappedBufferClosed();
            UnifiedLog.rebuildProducerState(producerStateManager, this.localLog.segments(), this.logStartOffset, lastOffset, this.time(), false, this.logIdent);
        }
    }

    public boolean hasLateTransaction(long currentTimeMs) {
        return this.producerStateManager.hasLateTransaction(currentTimeMs);
    }

    public int producerIdCount() {
        return this.producerStateManager.producerIdCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DescribeProducersResponseData.ProducerState> activeProducers() {
        Object object = this.lock;
        synchronized (object) {
            return this.producerStateManager.activeProducers().entrySet().stream().map(entry -> {
                long producerId = (Long)entry.getKey();
                ProducerStateEntry state = (ProducerStateEntry)entry.getValue();
                return new DescribeProducersResponseData.ProducerState().setProducerId(producerId).setProducerEpoch((int)state.producerEpoch()).setLastSequence(state.lastSeq()).setLastTimestamp(state.lastTimestamp()).setCoordinatorEpoch(state.coordinatorEpoch()).setCurrentTxnStartOffset(state.currentTxnFirstOffset().orElse(-1L));
            }).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Integer> activeProducersWithLastSequence() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<Long, Integer> result = new HashMap<Long, Integer>();
            this.producerStateManager.activeProducers().forEach((producerId, producerIdEntry) -> result.put((Long)producerId, producerIdEntry.lastSeq()));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, LastRecord> lastRecordsOfActiveProducers() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<Long, LastRecord> result = new HashMap<Long, LastRecord>();
            this.producerStateManager.activeProducers().forEach((producerId, producerIdEntry) -> {
                Optional<Long> lastDataOffset = producerIdEntry.lastDataOffset() >= 0L ? Optional.of(producerIdEntry.lastDataOffset()) : Optional.empty();
                LastRecord lastRecord = new LastRecord(lastDataOffset.map(OptionalLong::of).orElseGet(OptionalLong::empty), producerIdEntry.producerEpoch());
                result.put((Long)producerId, lastRecord);
            });
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationGuard maybeStartTransactionVerification(long producerId, int sequence, short epoch, boolean supportsEpochBump) {
        Object object = this.lock;
        synchronized (object) {
            ProducerStateEntry entry = this.producerStateManager.activeProducers().get(producerId);
            if (entry != null && epoch < entry.producerEpoch()) {
                String message = "Epoch of producer " + producerId + " is " + epoch + ", which is smaller than the last seen epoch " + entry.producerEpoch();
                throw new InvalidProducerEpochException(message);
            }
            if (this.hasOngoingTransaction(producerId, epoch)) {
                return VerificationGuard.SENTINEL;
            }
            return this.maybeCreateVerificationGuard(producerId, sequence, epoch, supportsEpochBump);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerificationGuard maybeCreateVerificationGuard(long producerId, int sequence, short epoch, boolean supportsEpochBump) {
        Object object = this.lock;
        synchronized (object) {
            return this.producerStateManager.maybeCreateVerificationStateEntry(producerId, sequence, epoch, supportsEpochBump).verificationGuard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerificationGuard verificationGuard(long producerId) {
        Object object = this.lock;
        synchronized (object) {
            VerificationStateEntry entry = this.producerStateManager.verificationStateEntry(producerId);
            return entry != null ? entry.verificationGuard() : VerificationGuard.SENTINEL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOngoingTransaction(long producerId, short producerEpoch) {
        Object object = this.lock;
        synchronized (object) {
            ProducerStateEntry entry = this.producerStateManager.activeProducers().get(producerId);
            return entry != null && entry.currentTxnFirstOffset().isPresent() && entry.producerEpoch() == producerEpoch;
        }
    }

    public int numberOfSegments() {
        return this.localLog.segments().numberOfSegments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.logger.debug("Closing log");
        Object object = this.lock;
        synchronized (object) {
            this.logOffsetsListener = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            this.maybeFlushMetadataFile();
            this.localLog.checkIfMemoryMappedBufferClosed();
            this.producerExpireCheck.cancel(true);
            this.maybeHandleIOException(() -> "Error while renaming dir for " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent(), () -> {
                this.producerStateManager.takeSnapshot();
                return null;
            });
            this.localLog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameDir(String name, boolean shouldReinitialize) {
        Object object = this.lock;
        synchronized (object) {
            this.maybeHandleIOException(() -> "Error while renaming dir for " + String.valueOf(this.topicPartition()) + " in log dir " + this.dir().getParent(), () -> {
                this.maybeFlushMetadataFile();
                if (this.localLog.renameDir(name)) {
                    this.producerStateManager.updateParentDir(this.dir());
                    if (shouldReinitialize) {
                        this.reinitializeLeaderEpochCache();
                        this.initializePartitionMetadata();
                    } else {
                        this.leaderEpochCache.clear();
                        this.partitionMetadataFile = Optional.empty();
                    }
                }
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeHandlers() {
        this.logger.debug("Closing handlers");
        Object object = this.lock;
        synchronized (object) {
            this.localLog.closeHandlers();
        }
    }

    public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch) throws IOException {
        return this.appendAsLeader(records, leaderEpoch, AppendOrigin.CLIENT, RequestLocal.noCaching(), VerificationGuard.SENTINEL);
    }

    public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin) throws IOException {
        return this.appendAsLeader(records, leaderEpoch, origin, RequestLocal.noCaching(), VerificationGuard.SENTINEL);
    }

    public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, RequestLocal requestLocal, VerificationGuard verificationGuard) {
        boolean validateAndAssignOffsets = origin != AppendOrigin.RAFT_LEADER;
        return this.append(records, origin, validateAndAssignOffsets, leaderEpoch, Optional.of(requestLocal), verificationGuard, false, (byte)2);
    }

    public LogAppendInfo appendAsLeaderWithRecordVersion(MemoryRecords records, int leaderEpoch, RecordVersion recordVersion) {
        return this.append(records, AppendOrigin.CLIENT, true, leaderEpoch, Optional.of(RequestLocal.noCaching()), VerificationGuard.SENTINEL, false, recordVersion.value);
    }

    public LogAppendInfo appendAsFollower(MemoryRecords records, int leaderEpoch) {
        return this.append(records, AppendOrigin.REPLICATION, false, leaderEpoch, Optional.empty(), VerificationGuard.SENTINEL, true, (byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogAppendInfo append(MemoryRecords records, AppendOrigin origin, boolean validateAndAssignOffsets, int leaderEpoch, Optional<RequestLocal> requestLocal, VerificationGuard verificationGuard, boolean ignoreRecordSize, byte toMagic) {
        this.maybeFlushMetadataFile();
        LogAppendInfo appendInfo = this.analyzeAndValidateRecords(records, origin, ignoreRecordSize, !validateAndAssignOffsets, leaderEpoch);
        if (appendInfo.validBytes() <= 0) {
            return appendInfo;
        }
        MemoryRecords trimmedRecords = this.trimInvalidBytes(records, appendInfo);
        Object object = this.lock;
        synchronized (object) {
            return this.maybeHandleIOException(() -> "Error while appending records to " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent(), () -> {
                MemoryRecords validRecords = trimmedRecords;
                this.localLog.checkIfMemoryMappedBufferClosed();
                if (validateAndAssignOffsets) {
                    PrimitiveRef.LongRef offset = PrimitiveRef.ofLong((long)this.localLog.logEndOffset());
                    appendInfo.setFirstOffset(offset.value);
                    Compression targetCompression = BrokerCompressionType.targetCompression(this.config().compression, (CompressionType)appendInfo.sourceCompression());
                    LogValidator validator = new LogValidator(validRecords, this.topicPartition(), this.time(), appendInfo.sourceCompression(), targetCompression, this.config().compact, toMagic, this.config().messageTimestampType, this.config().messageTimestampBeforeMaxMs, this.config().messageTimestampAfterMaxMs, leaderEpoch, origin);
                    LogValidator.ValidationResult validateAndOffsetAssignResult = validator.validateMessagesAndAssignOffsets(offset, this.validatorMetricsRecorder, ((RequestLocal)requestLocal.orElseThrow(() -> new IllegalArgumentException("requestLocal should be defined if assignOffsets is true"))).bufferSupplier());
                    validRecords = validateAndOffsetAssignResult.validatedRecords;
                    appendInfo.setMaxTimestamp(validateAndOffsetAssignResult.maxTimestampMs);
                    appendInfo.setLastOffset(offset.value - 1L);
                    appendInfo.setRecordValidationStats(validateAndOffsetAssignResult.recordValidationStats);
                    if (this.config().messageTimestampType == TimestampType.LOG_APPEND_TIME) {
                        appendInfo.setLogAppendTime(validateAndOffsetAssignResult.logAppendTimeMs);
                    }
                    if (!ignoreRecordSize && validateAndOffsetAssignResult.messageSizeMaybeChanged) {
                        validRecords.batches().forEach(batch -> {
                            if (batch.sizeInBytes() > this.config().maxMessageSize()) {
                                this.brokerTopicStats.topicStats(this.topicPartition().topic()).bytesRejectedRate().mark((long)records.sizeInBytes());
                                this.brokerTopicStats.allTopicsStats().bytesRejectedRate().mark((long)records.sizeInBytes());
                                throw new RecordTooLargeException("Message batch size is " + batch.sizeInBytes() + " bytes in append topartition " + String.valueOf(this.topicPartition()) + " which exceeds the maximum configured size of " + this.config().maxMessageSize() + ".");
                            }
                        });
                    }
                } else if (appendInfo.firstOrLastOffsetOfFirstBatch() < this.localLog.logEndOffset()) {
                    boolean hasFirstOffset = appendInfo.firstOffset() != -1L;
                    long firstOffset = hasFirstOffset ? appendInfo.firstOffset() : ((MutableRecordBatch)records.batches().iterator().next()).baseOffset();
                    String firstOrLast = hasFirstOffset ? "First offset" : "Last offset of the first batch";
                    ArrayList<String> offsets = new ArrayList<String>();
                    for (Record record : records.records()) {
                        offsets.add(String.valueOf(record.offset()));
                        if (offsets.size() != 10) continue;
                        break;
                    }
                    throw new UnexpectedAppendOffsetException("Unexpected offset in append to " + String.valueOf(this.topicPartition()) + ". " + firstOrLast + " " + appendInfo.firstOrLastOffsetOfFirstBatch() + " is less than the next offset " + this.localLog.logEndOffset() + ". First 10 offsets in append: " + String.join((CharSequence)", ", offsets) + ", last offset in append: " + appendInfo.lastOffset() + ". Log start offset = " + this.logStartOffset, firstOffset, appendInfo.lastOffset());
                }
                validRecords.batches().forEach(batch -> {
                    if (batch.magic() >= 2) {
                        this.assignEpochStartOffset(batch.partitionLeaderEpoch(), batch.baseOffset());
                    } else if (this.leaderEpochCache.nonEmpty()) {
                        this.logger.warn("Clearing leader epoch cache after unexpected append with message format v{}", (Object)batch.magic());
                        this.leaderEpochCache.clearAndFlush();
                    }
                });
                if (validRecords.sizeInBytes() > this.config().segmentSize()) {
                    throw new RecordBatchTooLargeException("Message batch size is " + validRecords.sizeInBytes() + " bytes in append to partition " + String.valueOf(this.topicPartition()) + ", which exceeds the maximum configured segment size of " + this.config().segmentSize() + ".");
                }
                LogSegment segment = this.maybeRoll(validRecords.sizeInBytes(), appendInfo);
                LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(appendInfo.firstOrLastOffsetOfFirstBatch(), segment.baseOffset(), segment.size());
                AnalyzeAndValidateProducerStateResult result = this.analyzeAndValidateProducerState(logOffsetMetadata, validRecords, origin, verificationGuard);
                if (result.maybeDuplicate.isPresent()) {
                    BatchMetadata duplicate = result.maybeDuplicate.get();
                    appendInfo.setFirstOffset(duplicate.firstOffset());
                    appendInfo.setLastOffset(duplicate.lastOffset);
                    appendInfo.setLogAppendTime(duplicate.timestamp);
                    appendInfo.setLogStartOffset(this.logStartOffset);
                } else {
                    this.localLog.append(appendInfo.lastOffset(), validRecords);
                    this.updateHighWatermarkWithLogEndOffset();
                    result.updatedProducers.values().forEach(this.producerStateManager::update);
                    for (CompletedTxn completedTxn : result.completedTxns) {
                        long lastStableOffset = this.producerStateManager.lastStableOffset(completedTxn);
                        segment.updateTxnIndex(completedTxn, lastStableOffset);
                        this.producerStateManager.completeTxn(completedTxn);
                    }
                    this.producerStateManager.updateMapEndOffset(appendInfo.lastOffset() + 1L);
                    this.maybeIncrementFirstUnstableOffset();
                    this.logger.trace("Appended message set with last offset: {}, first offset: {}, next offset: {}, and messages: {}", new Object[]{appendInfo.lastOffset(), appendInfo.firstOffset(), this.localLog.logEndOffset(), validRecords});
                    if (this.localLog.unflushedMessages() >= this.config().flushInterval) {
                        this.flush(false);
                    }
                }
                return appendInfo;
            });
        }
    }

    public void assignEpochStartOffset(int leaderEpoch, long startOffset) {
        this.leaderEpochCache.assign(leaderEpoch, startOffset);
    }

    public Optional<Integer> latestEpoch() {
        return this.leaderEpochCache.latestEpoch();
    }

    public Optional<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
        Map.Entry<Integer, Long> entry = this.leaderEpochCache.endOffsetFor(leaderEpoch, this.logEndOffset());
        int foundEpoch = entry.getKey();
        long foundOffset = entry.getValue();
        if (foundOffset == -1L) {
            return Optional.empty();
        }
        return Optional.of(new OffsetAndEpoch(foundOffset, foundEpoch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeIncrementFirstUnstableOffset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.localLog.checkIfMemoryMappedBufferClosed();
            Optional<LogOffsetMetadata> updatedFirstUnstableOffset = this.producerStateManager.firstUnstableOffset();
            if (updatedFirstUnstableOffset.isPresent() && (updatedFirstUnstableOffset.get().messageOffsetOnly() || updatedFirstUnstableOffset.get().messageOffset < this.logStartOffset)) {
                long offset = Math.max(updatedFirstUnstableOffset.get().messageOffset, this.logStartOffset);
                updatedFirstUnstableOffset = Optional.of(this.maybeConvertToOffsetMetadata(offset));
            }
            if (updatedFirstUnstableOffset != this.firstUnstableOffsetMetadata) {
                this.logger.debug("First unstable offset updated to {}", updatedFirstUnstableOffset);
                this.firstUnstableOffsetMetadata = updatedFirstUnstableOffset;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeIncrementLocalLogStartOffset(long newLocalLogStartOffset, LogStartOffsetIncrementReason reason) {
        Object object = this.lock;
        synchronized (object) {
            if (newLocalLogStartOffset > this.localLogStartOffset()) {
                this.localLogStartOffset = newLocalLogStartOffset;
                this.logger.info("Incremented local log start offset to {} due to reason {}", (Object)this.localLogStartOffset(), (Object)reason);
            }
        }
    }

    public boolean maybeIncrementLogStartOffset(long newLogStartOffset, LogStartOffsetIncrementReason reason) {
        return this.maybeHandleIOException(() -> "Exception while increasing log start offset for " + String.valueOf(this.topicPartition()) + " to " + newLogStartOffset + " in dir " + this.dir().getParent(), () -> {
            Object object = this.lock;
            synchronized (object) {
                if (newLogStartOffset > this.highWatermark()) {
                    throw new OffsetOutOfRangeException("Cannot increment the log start offset to " + newLogStartOffset + " of partition " + String.valueOf(this.topicPartition()) + " since it is larger than the high watermark " + this.highWatermark());
                }
                if (this.remoteLogEnabled()) {
                    this.localLogStartOffset = Math.max(newLogStartOffset, this.localLogStartOffset());
                }
                this.localLog.checkIfMemoryMappedBufferClosed();
                if (newLogStartOffset > this.logStartOffset) {
                    this.updateLogStartOffset(newLogStartOffset);
                    this.logger.info("Incremented log start offset to {} due to {}", (Object)newLogStartOffset, (Object)reason);
                    this.leaderEpochCache.truncateFromStartAsyncFlush(this.logStartOffset);
                    this.producerStateManager.onLogStartOffsetIncremented(newLogStartOffset);
                    this.maybeIncrementFirstUnstableOffset();
                    return true;
                }
            }
            return false;
        });
    }

    private AnalyzeAndValidateProducerStateResult analyzeAndValidateProducerState(LogOffsetMetadata appendOffsetMetadata, MemoryRecords records, AppendOrigin origin, VerificationGuard requestVerificationGuard) {
        HashMap<Long, ProducerAppendInfo> updatedProducers = new HashMap<Long, ProducerAppendInfo>();
        ArrayList<CompletedTxn> completedTxns = new ArrayList<CompletedTxn>();
        int relativePositionInSegment = appendOffsetMetadata.relativePositionInSegment;
        for (MutableRecordBatch batch : records.batches()) {
            if (batch.hasProducerId()) {
                Optional<ProducerStateEntry> maybeLastEntry;
                Optional<BatchMetadata> duplicateBatch;
                if (origin == AppendOrigin.CLIENT && (duplicateBatch = (maybeLastEntry = this.producerStateManager.lastEntry(batch.producerId())).flatMap(e -> e.findDuplicateBatch((RecordBatch)batch))).isPresent()) {
                    return new AnalyzeAndValidateProducerStateResult(updatedProducers, completedTxns, duplicateBatch);
                }
                if ((origin == AppendOrigin.CLIENT || origin == AppendOrigin.COORDINATOR) && batch.isTransactional() && !this.hasOngoingTransaction(batch.producerId(), batch.producerEpoch())) {
                    ProducerStateEntry entry = this.producerStateManager.activeProducers().get(batch.producerId());
                    if (entry != null && batch.producerEpoch() < entry.producerEpoch()) {
                        String message = "Epoch of producer " + batch.producerId() + " is " + batch.producerEpoch() + ", which is smaller than the last seen epoch " + entry.producerEpoch();
                        throw new InvalidProducerEpochException(message);
                    }
                    if (this.batchMissingRequiredVerification(batch, requestVerificationGuard)) {
                        throw new InvalidTxnStateException("Record was not part of an ongoing transaction");
                    }
                }
                Optional<LogOffsetMetadata> firstOffsetMetadata = batch.isTransactional() ? Optional.of(new LogOffsetMetadata(batch.baseOffset(), appendOffsetMetadata.segmentBaseOffset, relativePositionInSegment)) : Optional.empty();
                Optional<CompletedTxn> maybeCompletedTxn = UnifiedLog.updateProducers(this.producerStateManager, (RecordBatch)batch, updatedProducers, firstOffsetMetadata, origin);
                maybeCompletedTxn.ifPresent(completedTxns::add);
            }
            relativePositionInSegment += batch.sizeInBytes();
        }
        return new AnalyzeAndValidateProducerStateResult(updatedProducers, completedTxns, Optional.empty());
    }

    private boolean batchMissingRequiredVerification(MutableRecordBatch batch, VerificationGuard requestVerificationGuard) {
        return this.producerStateManager.producerStateManagerConfig().transactionVerificationEnabled() && !batch.isControlBatch() && !this.verificationGuard(batch.producerId()).verify(requestVerificationGuard);
    }

    private LogAppendInfo analyzeAndValidateRecords(MemoryRecords records, AppendOrigin origin, boolean ignoreRecordSize, boolean requireOffsetsMonotonic, int leaderEpoch) {
        int validBytesCount = 0;
        long firstOffset = -1L;
        long lastOffset = -1L;
        int lastLeaderEpoch = -1;
        CompressionType sourceCompression = CompressionType.NONE;
        boolean monotonic = true;
        long maxTimestamp = -1L;
        boolean readFirstMessage = false;
        long lastOffsetOfFirstBatch = -1L;
        boolean skipRemainingBatches = false;
        for (MutableRecordBatch batch : records.batches()) {
            if (origin == AppendOrigin.RAFT_LEADER && batch.partitionLeaderEpoch() != leaderEpoch) {
                throw new InvalidRecordException("Append from Raft leader did not set the batch epoch correctly, expected " + leaderEpoch + " but the batch has " + batch.partitionLeaderEpoch());
            }
            if (batch.magic() >= 2 && origin == AppendOrigin.CLIENT && batch.baseOffset() != 0L) {
                throw new InvalidRecordException("The baseOffset of the record batch in the append to " + String.valueOf(this.topicPartition()) + " should be 0, but it is " + batch.baseOffset());
            }
            boolean bl = skipRemainingBatches = skipRemainingBatches || this.hasHigherPartitionLeaderEpoch((RecordBatch)batch, origin, leaderEpoch);
            if (skipRemainingBatches) {
                this.logger.info("Skipping batch {} from an origin of {} because its partition leader epoch {} is higher than the replica's current leader epoch {}", new Object[]{batch, origin, batch.partitionLeaderEpoch(), leaderEpoch});
            } else {
                if (!readFirstMessage) {
                    if (batch.magic() >= 2) {
                        firstOffset = batch.baseOffset();
                    }
                    lastOffsetOfFirstBatch = batch.lastOffset();
                    readFirstMessage = true;
                }
                if (lastOffset >= batch.lastOffset()) {
                    monotonic = false;
                }
                lastOffset = batch.lastOffset();
                lastLeaderEpoch = batch.partitionLeaderEpoch();
                int batchSize = batch.sizeInBytes();
                if (!ignoreRecordSize && batchSize > this.config().maxMessageSize()) {
                    this.brokerTopicStats.topicStats(this.topicPartition().topic()).bytesRejectedRate().mark((long)records.sizeInBytes());
                    this.brokerTopicStats.allTopicsStats().bytesRejectedRate().mark((long)records.sizeInBytes());
                    throw new RecordTooLargeException("The record batch size in the append to " + String.valueOf(this.topicPartition()) + " is " + batchSize + " bytes which exceeds the maximum configured value of " + this.config().maxMessageSize() + ").");
                }
                if (!batch.isValid()) {
                    this.brokerTopicStats.allTopicsStats().invalidMessageCrcRecordsPerSec().mark();
                    throw new CorruptRecordException("Record is corrupt (stored crc = " + batch.checksum() + ") in topic partition " + String.valueOf(this.topicPartition()) + ".");
                }
                if (batch.maxTimestamp() > maxTimestamp) {
                    maxTimestamp = batch.maxTimestamp();
                }
                validBytesCount += batchSize;
                CompressionType batchCompression = CompressionType.forId((int)batch.compressionType().id);
                if (batchCompression != CompressionType.NONE) {
                    sourceCompression = batchCompression;
                }
            }
            if (!requireOffsetsMonotonic || monotonic) continue;
            throw new OffsetsOutOfOrderException("Out of order offsets found in append to " + String.valueOf(this.topicPartition()) + ": " + StreamSupport.stream(records.records().spliterator(), false).map(Record::offset).map(String::valueOf).collect(Collectors.joining(",")));
        }
        Optional<Integer> lastLeaderEpochOpt = lastLeaderEpoch != -1 ? Optional.of(lastLeaderEpoch) : Optional.empty();
        return new LogAppendInfo(firstOffset, lastOffset, lastLeaderEpochOpt, maxTimestamp, -1L, this.logStartOffset, RecordValidationStats.EMPTY, sourceCompression, validBytesCount, lastOffsetOfFirstBatch, Collections.emptyList(), LeaderHwChange.NONE);
    }

    private boolean hasHigherPartitionLeaderEpoch(RecordBatch batch, AppendOrigin origin, int leaderEpoch) {
        return origin == AppendOrigin.REPLICATION && batch.partitionLeaderEpoch() != -1 && batch.partitionLeaderEpoch() > leaderEpoch;
    }

    private MemoryRecords trimInvalidBytes(MemoryRecords records, LogAppendInfo info) {
        int validBytes = info.validBytes();
        if (validBytes < 0) {
            throw new CorruptRecordException("Cannot append record batch with illegal length " + validBytes + " to log for " + String.valueOf(this.topicPartition()) + ". A possible cause is a corrupted produce request.");
        }
        if (validBytes == records.sizeInBytes()) {
            return records;
        }
        ByteBuffer validByteBuffer = records.buffer().duplicate();
        validByteBuffer.limit(validBytes);
        return MemoryRecords.readableRecords((ByteBuffer)validByteBuffer);
    }

    private void checkLogStartOffset(long offset) {
        if (offset < this.logStartOffset) {
            throw new OffsetOutOfRangeException("Received request for offset " + offset + " for partition " + String.valueOf(this.topicPartition()) + ", but we only have log segments starting from offset: " + this.logStartOffset + ".");
        }
    }

    public FetchDataInfo read(long startOffset, int maxLength, FetchIsolation isolation, boolean minOneMessage) throws IOException {
        this.checkLogStartOffset(startOffset);
        LogOffsetMetadata maxOffsetMetadata = switch (isolation) {
            default -> throw new IncompatibleClassChangeError();
            case FetchIsolation.LOG_END -> this.localLog.logEndOffsetMetadata();
            case FetchIsolation.HIGH_WATERMARK -> this.fetchHighWatermarkMetadata();
            case FetchIsolation.TXN_COMMITTED -> this.fetchLastStableOffsetMetadata();
        };
        return this.localLog.read(startOffset, maxLength, minOneMessage, maxOffsetMetadata, isolation == FetchIsolation.TXN_COMMITTED);
    }

    public List<AbortedTxn> collectAbortedTransactions(long startOffset, long upperBoundOffset) {
        return this.localLog.collectAbortedTransactions(this.logStartOffset, startOffset, upperBoundOffset);
    }

    public OffsetResultHolder fetchOffsetByTimestamp(long targetTimestamp, Optional<AsyncOffsetReader> remoteOffsetReader) {
        return this.maybeHandleIOException(() -> "Error while fetching offset by timestamp for " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent(), () -> {
            this.logger.debug("Searching offset for timestamp {}.", (Object)targetTimestamp);
            if (targetTimestamp == -2L || !this.remoteLogEnabled() && targetTimestamp == -4L) {
                Optional<EpochEntry> earliestEpochEntry = this.leaderEpochCache.earliestEntry();
                Optional epochOpt = earliestEpochEntry.isPresent() && earliestEpochEntry.get().startOffset <= this.logStartOffset ? Optional.of(earliestEpochEntry.get().epoch) : Optional.empty();
                return new OffsetResultHolder(new FileRecords.TimestampAndOffset(-1L, this.logStartOffset, epochOpt));
            }
            if (targetTimestamp == -4L) {
                long curLocalLogStartOffset = this.localLogStartOffset();
                OptionalInt epochForOffset = this.leaderEpochCache.epochForOffset(curLocalLogStartOffset);
                Optional epochResult = epochForOffset.isPresent() ? Optional.of(epochForOffset.getAsInt()) : Optional.empty();
                return new OffsetResultHolder(new FileRecords.TimestampAndOffset(-1L, curLocalLogStartOffset, epochResult));
            }
            if (targetTimestamp == -1L) {
                return new OffsetResultHolder(new FileRecords.TimestampAndOffset(-1L, this.logEndOffset(), this.leaderEpochCache.latestEpoch()));
            }
            if (targetTimestamp == -5L) {
                if (this.remoteLogEnabled()) {
                    long curHighestRemoteOffset = this.highestOffsetInRemoteStorage();
                    OptionalInt epochOpt = this.leaderEpochCache.epochForOffset(curHighestRemoteOffset);
                    Optional<Integer> epochResult = epochOpt.isPresent() ? Optional.of(epochOpt.getAsInt()) : (curHighestRemoteOffset == -1L ? Optional.of(-1) : Optional.empty());
                    return new OffsetResultHolder(new FileRecords.TimestampAndOffset(-1L, curHighestRemoteOffset, epochResult));
                }
                return new OffsetResultHolder(new FileRecords.TimestampAndOffset(-1L, -1L, Optional.of(-1)));
            }
            if (targetTimestamp == -3L) {
                List<LogSegment> segments = this.logSegments();
                LogSegment latestTimestampSegment = null;
                for (LogSegment segment : segments) {
                    if (latestTimestampSegment == null) {
                        latestTimestampSegment = segment;
                        continue;
                    }
                    if (segment.maxTimestampSoFar() <= latestTimestampSegment.maxTimestampSoFar()) continue;
                    latestTimestampSegment = segment;
                }
                TimestampOffset maxTimestampSoFar = latestTimestampSegment.readMaxTimestampAndOffsetSoFar();
                OffsetPosition position = latestTimestampSegment.offsetIndex().lookup(maxTimestampSoFar.offset);
                Optional<FileRecords.TimestampAndOffset> timestampAndOffsetOpt = UnifiedLog.findFirst(latestTimestampSegment.log().batchesFrom(position.position), item -> item.maxTimestamp() == maxTimestampSoFar.timestamp).flatMap(batch -> batch.offsetOfMaxTimestamp().map(offset -> new FileRecords.TimestampAndOffset(batch.maxTimestamp(), offset.longValue(), Optional.of(batch.partitionLeaderEpoch()).filter(epoch -> epoch >= 0))));
                return new OffsetResultHolder(timestampAndOffsetOpt);
            }
            if (this.remoteLogEnabled() && !this.isEmpty()) {
                if (remoteOffsetReader.isEmpty()) {
                    throw new KafkaException("RemoteLogManager is empty even though the remote log storage is enabled.");
                }
                AsyncOffsetReadFutureHolder<OffsetResultHolder.FileRecordsOrError> asyncOffsetReadFutureHolder = ((AsyncOffsetReader)remoteOffsetReader.get()).asyncOffsetRead(this.topicPartition(), targetTimestamp, this.logStartOffset, this.leaderEpochCache, () -> this.searchOffsetInLocalLog(targetTimestamp, this.localLogStartOffset()));
                return new OffsetResultHolder(Optional.empty(), Optional.of(asyncOffsetReadFutureHolder));
            }
            return new OffsetResultHolder(this.searchOffsetInLocalLog(targetTimestamp, this.logStartOffset));
        });
    }

    public boolean isEmpty() {
        return this.logStartOffset == this.logEndOffset();
    }

    private Optional<FileRecords.TimestampAndOffset> searchOffsetInLocalLog(long targetTimestamp, long startOffset) throws IOException {
        List<LogSegment> segments = this.logSegments();
        for (LogSegment segment : segments) {
            if (segment.largestTimestamp() < targetTimestamp) continue;
            return segment.findOffsetByTimestamp(targetTimestamp, startOffset);
        }
        return Optional.empty();
    }

    public LogOffsetMetadata maybeConvertToOffsetMetadata(long offset) throws IOException {
        try {
            return this.localLog.convertToOffsetMetadataOrThrow(offset);
        }
        catch (OffsetOutOfRangeException ignore) {
            return new LogOffsetMetadata(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteOldSegments(DeletionCondition predicate, SegmentDeletionReason reason) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            List<LogSegment> deletable = this.deletableSegments(predicate);
            if (!deletable.isEmpty()) {
                return this.deleteSegments(deletable, reason);
            }
            return 0;
        }
    }

    private boolean remoteLogEnabledAndRemoteCopyEnabled() {
        return this.remoteLogEnabled() && this.config().remoteLogCopyDisable() == false;
    }

    private boolean isSegmentEligibleForDeletion(Optional<LogSegment> nextSegmentOpt, long upperBoundOffset) {
        boolean allowDeletionDueToLogStartOffsetIncremented;
        boolean bl = allowDeletionDueToLogStartOffsetIncremented = nextSegmentOpt.isPresent() && this.logStartOffset >= nextSegmentOpt.get().baseOffset();
        if (this.remoteLogEnabledAndRemoteCopyEnabled()) {
            return upperBoundOffset > 0L && upperBoundOffset - 1L <= this.highestOffsetInRemoteStorage() || allowDeletionDueToLogStartOffsetIncremented;
        }
        return true;
    }

    public List<LogSegment> deletableSegments(DeletionCondition predicate) throws IOException {
        if (this.localLog.segments().isEmpty()) {
            return List.of();
        }
        ArrayList<LogSegment> deletable = new ArrayList<LogSegment>();
        Iterator<LogSegment> segmentsIterator = this.localLog.segments().values().iterator();
        Optional<LogSegment> segmentOpt = UnifiedLog.nextOption(segmentsIterator);
        boolean shouldRoll = false;
        while (segmentOpt.isPresent()) {
            boolean predicateResult;
            LogSegment segment = segmentOpt.get();
            Optional<LogSegment> nextSegmentOpt = UnifiedLog.nextOption(segmentsIterator);
            boolean isLastSegmentAndEmpty = nextSegmentOpt.isEmpty() && segment.size() == 0;
            long upperBoundOffset = nextSegmentOpt.map(LogSegment::baseOffset).orElseGet(this::logEndOffset);
            boolean bl = predicateResult = this.highWatermark() >= upperBoundOffset && predicate.execute(segment, nextSegmentOpt);
            if (predicateResult && this.remoteLogEnabled() && nextSegmentOpt.isEmpty() && segment.size() > 0) {
                shouldRoll = true;
            }
            if (predicateResult && !isLastSegmentAndEmpty && this.isSegmentEligibleForDeletion(nextSegmentOpt, upperBoundOffset)) {
                deletable.add(segment);
                segmentOpt = nextSegmentOpt;
                continue;
            }
            segmentOpt = Optional.empty();
        }
        if (shouldRoll) {
            this.logger.info("Rolling the active segment to make it eligible for deletion");
            this.roll();
        }
        return deletable;
    }

    private static <T> Optional<T> nextOption(Iterator<T> iterator) {
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    private int deleteSegments(List<LogSegment> deletable, SegmentDeletionReason reason) {
        return this.maybeHandleIOException(() -> "Error while deleting segments for " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent(), () -> {
            int numToDelete = deletable.size();
            if (numToDelete > 0) {
                List segmentsToDelete = deletable;
                if (this.localLog.segments().numberOfSegments() == numToDelete) {
                    LogSegment newSegment = this.roll();
                    if (((LogSegment)deletable.get(deletable.size() - 1)).baseOffset() == newSegment.baseOffset()) {
                        this.logger.warn("Empty active segment at {} was deleted and recreated due to {}", (Object)((LogSegment)deletable.get(deletable.size() - 1)).baseOffset(), (Object)reason);
                        deletable.remove(deletable.size() - 1);
                        segmentsToDelete = List.copyOf(deletable);
                    }
                }
                this.localLog.checkIfMemoryMappedBufferClosed();
                if (!segmentsToDelete.isEmpty()) {
                    long newLocalLogStartOffset = this.localLog.segments().higherSegment(((LogSegment)segmentsToDelete.get(segmentsToDelete.size() - 1)).baseOffset()).get().baseOffset();
                    if (this.remoteLogEnabledAndRemoteCopyEnabled()) {
                        this.maybeIncrementLocalLogStartOffset(newLocalLogStartOffset, LogStartOffsetIncrementReason.SegmentDeletion);
                    } else {
                        this.maybeIncrementLogStartOffset(newLocalLogStartOffset, LogStartOffsetIncrementReason.SegmentDeletion);
                    }
                    this.localLog.removeAndDeleteSegments(segmentsToDelete, true, reason);
                }
                this.deleteProducerSnapshots((Collection<LogSegment>)deletable, true);
            }
            return numToDelete;
        });
    }

    public int deleteOldSegments() throws IOException {
        if (this.config().delete) {
            return this.deleteLogStartOffsetBreachedSegments() + this.deleteRetentionSizeBreachedSegments() + this.deleteRetentionMsBreachedSegments();
        }
        return this.deleteLogStartOffsetBreachedSegments();
    }

    private int deleteRetentionMsBreachedSegments() throws IOException {
        long retentionMs = UnifiedLog.localRetentionMs(this.config(), this.remoteLogEnabledAndRemoteCopyEnabled());
        if (retentionMs < 0L) {
            return 0;
        }
        long startMs = this.time().milliseconds();
        DeletionCondition shouldDelete = (segment, nextSegmentOpt) -> {
            if (startMs < segment.largestTimestamp()) {
                this.futureTimestampLogger.warn("{} contains future timestamp(s), making it ineligible to be deleted", (Object)segment);
            }
            boolean delete = startMs - segment.largestTimestamp() > retentionMs;
            this.logger.debug("{} retentionMs breached: {}, startMs={}, retentionMs={}", new Object[]{segment, delete, startMs, retentionMs});
            return delete;
        };
        return this.deleteOldSegments(shouldDelete, toDelete -> {
            long localRetentionMs = UnifiedLog.localRetentionMs(this.config(), this.remoteLogEnabledAndRemoteCopyEnabled());
            for (LogSegment segment : toDelete) {
                if (segment.largestRecordTimestamp().isPresent()) {
                    if (this.remoteLogEnabledAndRemoteCopyEnabled()) {
                        this.logger.info("Deleting segment {} due to local log retention time {}ms breach based on the largest record timestamp in the segment", (Object)segment, (Object)localRetentionMs);
                        continue;
                    }
                    this.logger.info("Deleting segment {} due to log retention time {}ms breach based on the largest record timestamp in the segment", (Object)segment, (Object)localRetentionMs);
                    continue;
                }
                if (this.remoteLogEnabledAndRemoteCopyEnabled()) {
                    this.logger.info("Deleting segment {} due to local log retention time {}ms breach based on the last modified time of the segment", (Object)segment, (Object)localRetentionMs);
                    continue;
                }
                this.logger.info("Deleting segment {} due to log retention time {}ms breach based on the last modified time of the segment", (Object)segment, (Object)localRetentionMs);
            }
        });
    }

    private int deleteRetentionSizeBreachedSegments() throws IOException {
        long retentionSize = UnifiedLog.localRetentionSize(this.config(), this.remoteLogEnabledAndRemoteCopyEnabled());
        long logSize = this.size();
        if (retentionSize < 0L || logSize < retentionSize) {
            return 0;
        }
        AtomicLong diff = new AtomicLong(logSize - retentionSize);
        DeletionCondition shouldDelete = (segment, nextSegmentOpt) -> {
            int segmentSize = segment.size();
            boolean delete = diff.get() - (long)segmentSize >= 0L;
            this.logger.debug("{} retentionSize breached: {}, log size before delete segment={}, after delete segment={}", new Object[]{segment, delete, diff.get(), diff.get() - (long)segmentSize});
            if (delete) {
                diff.addAndGet(-segmentSize);
            }
            return delete;
        };
        return this.deleteOldSegments(shouldDelete, toDelete -> {
            long size = this.size();
            for (LogSegment segment : toDelete) {
                size -= (long)segment.size();
                if (this.remoteLogEnabledAndRemoteCopyEnabled()) {
                    this.logger.info("Deleting segment {} due to local log retention size {} breach. Local log size after deletion will be {}.", new Object[]{segment, UnifiedLog.localRetentionSize(this.config(), true), size});
                    continue;
                }
                this.logger.info("Deleting segment {} due to log retention size {} breach. Log size after deletion will be {}.", new Object[]{segment, this.config().retentionSize, size});
            }
        });
    }

    private int deleteLogStartOffsetBreachedSegments() throws IOException {
        DeletionCondition shouldDelete = (segment, nextSegmentOpt) -> {
            boolean isRemoteLogEnabled = this.remoteLogEnabled();
            long localLSO = this.localLogStartOffset();
            long logStartOffsetValue = isRemoteLogEnabled ? localLSO : this.logStartOffset();
            boolean delete = nextSegmentOpt.map(nextSegment -> nextSegment.baseOffset() <= logStartOffsetValue).orElse(false);
            this.logger.debug("{} logStartOffset breached: {}, nextSegmentOpt={}, {}", new Object[]{segment, delete, nextSegmentOpt, isRemoteLogEnabled ? "localLogStartOffset=" + localLSO : "logStartOffset=" + this.logStartOffset});
            return delete;
        };
        return this.deleteOldSegments(shouldDelete, toDelete -> {
            if (this.remoteLogEnabledAndRemoteCopyEnabled()) {
                this.logger.info("Deleting segments due to local log start offset {} breach: {}", (Object)this.localLogStartOffset(), (Object)toDelete.stream().map(LogSegment::toString).collect(Collectors.joining(",")));
            } else {
                this.logger.info("Deleting segments due to log start offset {} breach: {}", (Object)this.logStartOffset, (Object)toDelete.stream().map(LogSegment::toString).collect(Collectors.joining(",")));
            }
        });
    }

    public boolean isFuture() {
        return this.localLog.isFuture();
    }

    public long size() {
        return LogSegments.sizeInBytes(this.logSegments());
    }

    public long onlyLocalLogSegmentsSize() {
        return LogSegments.sizeInBytes(this.logSegments().stream().filter(s -> s.baseOffset() >= this.highestOffsetInRemoteStorage()).collect(Collectors.toList()));
    }

    public long onlyLocalLogSegmentsCount() {
        return this.logSegments().stream().filter(s -> s.baseOffset() >= this.highestOffsetInRemoteStorage()).count();
    }

    public long logEndOffset() {
        return this.localLog.logEndOffset();
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this.localLog.logEndOffsetMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogSegment maybeRoll(int messagesSize, LogAppendInfo appendInfo) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            LogSegment segment = this.localLog.segments().activeSegment();
            long now = this.time().milliseconds();
            long maxTimestampInMessages = appendInfo.maxTimestamp();
            long maxOffsetInMessages = appendInfo.lastOffset();
            if (segment.shouldRoll(new RollParams(this.config().maxSegmentMs(), this.config().segmentSize(), appendInfo.maxTimestamp(), appendInfo.lastOffset(), messagesSize, now))) {
                this.logger.debug("Rolling new log segment (log_size = {}/{}}, offset_index_size = {}/{}, time_index_size = {}/{}, inactive_time_ms = {}/{}).", new Object[]{segment.size(), this.config().segmentSize(), segment.offsetIndex().entries(), segment.offsetIndex().maxEntries(), segment.timeIndex().entries(), segment.timeIndex().maxEntries(), segment.timeWaitedForRoll(now, maxTimestampInMessages), this.config().segmentMs - segment.rollJitterMs()});
                long rollOffset = appendInfo.firstOffset() == -1L ? maxOffsetInMessages - Integer.MAX_VALUE : appendInfo.firstOffset();
                return this.roll(Optional.of(rollOffset));
            }
            return segment;
        }
    }

    public LogSegment roll() throws IOException {
        return this.roll(Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogSegment roll(Optional<Long> expectedNextOffset) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long nextOffset = expectedNextOffset.orElse(0L);
            LogSegment newSegment = this.localLog.roll(nextOffset);
            this.producerStateManager.updateMapEndOffset(newSegment.baseOffset());
            Optional<File> maybeSnapshot = this.producerStateManager.takeSnapshot(false);
            this.updateHighWatermarkWithLogEndOffset();
            this.scheduler().scheduleOnce("flush-log", () -> {
                maybeSnapshot.ifPresent(f -> this.flushProducerStateSnapshot(f.toPath()));
                this.flushUptoOffsetExclusive(newSegment.baseOffset());
            });
            return newSegment;
        }
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.flush(this.logEndOffset(), forceFlushActiveSegment);
    }

    public void flushUptoOffsetExclusive(long offset) {
        this.flush(offset, false);
    }

    private void flush(long offset, boolean includingOffset) {
        long flushOffset = includingOffset ? offset + 1L : offset;
        String includingOffsetStr = includingOffset ? "inclusive" : "exclusive";
        this.maybeHandleIOException(() -> "Error while flushing log for " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent() + " with offset " + offset + " (" + includingOffsetStr + ") and recovery point " + offset, () -> {
            if (flushOffset > this.localLog.recoveryPoint()) {
                this.logger.debug("Flushing log up to offset {} ({}) with recovery point {}, last flushed: {},  current time: {}, unflushed: {}", new Object[]{offset, includingOffsetStr, offset, this.lastFlushTime(), this.time().milliseconds(), this.localLog.unflushedMessages()});
                this.localLog.flush(flushOffset);
                Object object = this.lock;
                synchronized (object) {
                    this.localLog.markFlushed(offset);
                }
            }
            return null;
        });
    }

    public void delete() {
        this.maybeHandleIOException(() -> "Error while deleting log for " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent(), () -> {
            Object object = this.lock;
            synchronized (object) {
                this.localLog.checkIfMemoryMappedBufferClosed();
                this.producerExpireCheck.cancel(true);
                this.leaderEpochCache.clear();
                List<LogSegment> deletedSegments = this.localLog.deleteAllSegments();
                this.deleteProducerSnapshots(deletedSegments, false);
                this.localLog.deleteEmptyDir();
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeProducerSnapshot() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.localLog.checkIfMemoryMappedBufferClosed();
            this.producerStateManager.takeSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionalLong latestProducerSnapshotOffset() {
        Object object = this.lock;
        synchronized (object) {
            return this.producerStateManager.latestSnapshotOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionalLong oldestProducerSnapshotOffset() {
        Object object = this.lock;
        synchronized (object) {
            return this.producerStateManager.oldestSnapshotOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long latestProducerStateEndOffset() {
        Object object = this.lock;
        synchronized (object) {
            return this.producerStateManager.mapEndOffset();
        }
    }

    public void flushProducerStateSnapshot(Path snapshot) {
        this.maybeHandleIOException(() -> "Error while deleting producer state snapshot " + String.valueOf(snapshot) + " for " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent(), () -> {
            Utils.flushFileIfExists((Path)snapshot);
            return null;
        });
    }

    public boolean truncateTo(long targetOffset) {
        return this.maybeHandleIOException(() -> "Error while truncating log to offset " + targetOffset + " for " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent(), () -> {
            if (targetOffset < 0L) {
                throw new IllegalArgumentException("Cannot truncate partition " + String.valueOf(this.topicPartition()) + " to a negative offset (" + targetOffset + ").");
            }
            if (targetOffset >= this.localLog.logEndOffset()) {
                this.logger.info("Truncating to {} has no effect as the largest offset in the log is {}", (Object)targetOffset, (Object)(this.localLog.logEndOffset() - 1L));
                Object object = this.lock;
                synchronized (object) {
                    this.leaderEpochCache.truncateFromEndAsyncFlush(this.logEndOffset());
                }
                return false;
            }
            this.logger.info("Truncating to offset {}", (Object)targetOffset);
            Object object = this.lock;
            synchronized (object) {
                this.localLog.checkIfMemoryMappedBufferClosed();
                if (this.localLog.segments().firstSegmentBaseOffset().getAsLong() > targetOffset) {
                    this.truncateFullyAndStartAt(targetOffset, Optional.empty());
                } else {
                    Collection<LogSegment> deletedSegments = this.localLog.truncateTo(targetOffset);
                    this.deleteProducerSnapshots(deletedSegments, true);
                    this.leaderEpochCache.truncateFromEndAsyncFlush(targetOffset);
                    this.logStartOffset = Math.min(targetOffset, this.logStartOffset);
                    this.rebuildProducerState(targetOffset, this.producerStateManager);
                    if (this.highWatermark() >= this.localLog.logEndOffset()) {
                        this.updateHighWatermark(this.localLog.logEndOffsetMetadata());
                    }
                }
                return true;
            }
        });
    }

    public void truncateFullyAndStartAt(long newOffset, Optional<Long> logStartOffsetOpt) {
        this.maybeHandleIOException(() -> "Error while truncating the entire log for " + String.valueOf(this.topicPartition()) + " in dir " + this.dir().getParent(), () -> {
            this.logger.debug("Truncate and start at offset {}, logStartOffset: {}", (Object)newOffset, (Object)logStartOffsetOpt.orElse(newOffset));
            Object object = this.lock;
            synchronized (object) {
                this.localLog.truncateFullyAndStartAt(newOffset);
                this.leaderEpochCache.clearAndFlush();
                this.producerStateManager.truncateFullyAndStartAt(newOffset);
                this.logStartOffset = logStartOffsetOpt.orElse(newOffset);
                if (this.remoteLogEnabled()) {
                    this.localLogStartOffset = newOffset;
                }
                this.rebuildProducerState(newOffset, this.producerStateManager);
                return this.updateHighWatermark(this.localLog.logEndOffsetMetadata());
            }
        });
    }

    public long lastFlushTime() {
        return this.localLog.lastFlushTime();
    }

    public LogSegment activeSegment() {
        return this.localLog.segments().activeSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogSegment> logSegments() {
        Object object = this.lock;
        synchronized (object) {
            return List.copyOf(this.localLog.segments().values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogSegment> logSegments(long from, long to) {
        Object object = this.lock;
        synchronized (object) {
            return List.copyOf(this.localLog.segments().values(from, to));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogSegment> nonActiveLogSegmentsFrom(long from) {
        Object object = this.lock;
        synchronized (object) {
            return List.copyOf(this.localLog.segments().nonActiveLogSegmentsFrom(from));
        }
    }

    public String toString() {
        StringBuilder logString = new StringBuilder();
        logString.append("Log(dir=");
        logString.append(this.dir());
        this.topicId.ifPresent(id -> {
            logString.append(", topicId=");
            logString.append(id);
        });
        logString.append(", topic=");
        logString.append(this.topicPartition().topic());
        logString.append(", partition=");
        logString.append(this.topicPartition().partition());
        logString.append(", highWatermark=");
        logString.append(this.highWatermark());
        logString.append(", lastStableOffset=");
        logString.append(this.lastStableOffset());
        logString.append(", logStartOffset=");
        logString.append(this.logStartOffset());
        logString.append(", logEndOffset=");
        logString.append(this.logEndOffset());
        logString.append(")");
        return logString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSegments(List<LogSegment> newSegments, List<LogSegment> oldSegments) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.localLog.checkIfMemoryMappedBufferClosed();
            List<LogSegment> deletedSegments = LocalLog.replaceSegments(this.localLog.segments(), newSegments, oldSegments, this.dir(), this.topicPartition(), this.config(), this.scheduler(), this.logDirFailureChannel(), this.logIdent, false);
            this.deleteProducerSnapshots(deletedSegments, true);
        }
    }

    public Collection<Long> getFirstBatchTimestampForSegments(Collection<LogSegment> segments) {
        return segments.stream().map(LogSegment::getFirstBatchTimestamp).toList();
    }

    public void removeLogMetrics() {
        this.metricNames.forEach((arg_0, arg_1) -> ((KafkaMetricsGroup)this.metricsGroup).removeMetric(arg_0, arg_1));
        this.metricNames.clear();
    }

    private <T> T maybeHandleIOException(Supplier<String> msg, StorageAction<T, IOException> fun) throws KafkaStorageException {
        return LocalLog.maybeHandleIOException(this.logDirFailureChannel(), this.parentDir(), msg, fun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogSegment> splitOverflowedSegment(LogSegment segment) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            LocalLog.SplitSegmentResult result = LocalLog.splitOverflowedSegment(segment, this.localLog.segments(), this.dir(), this.topicPartition(), this.config(), this.scheduler(), this.logDirFailureChannel(), this.logIdent);
            this.deleteProducerSnapshots(result.deletedSegments, true);
            return result.newSegments;
        }
    }

    private void deleteProducerSnapshots(Collection<LogSegment> segments, boolean asyncDelete) throws IOException {
        UnifiedLog.deleteProducerSnapshots(segments, this.producerStateManager, asyncDelete, this.scheduler(), this.config(), this.logDirFailureChannel(), this.parentDir(), this.topicPartition());
    }

    private static <T> Optional<T> findFirst(Iterable<T> iterable, Predicate<T> predicate) {
        for (T item : iterable) {
            if (!predicate.test(item)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public static void rebuildProducerState(ProducerStateManager producerStateManager, LogSegments segments, long logStartOffset, long lastOffset, Time time, boolean reloadFromCleanShutdown, String logPrefix) throws IOException {
        ArrayList<Long> offsetsToSnapshot = new ArrayList<Long>();
        segments.lastSegment().ifPresent(lastSegment -> {
            long lastSegmentBaseOffset = lastSegment.baseOffset();
            segments.lowerSegment(lastSegmentBaseOffset).ifPresent(s -> offsetsToSnapshot.add(s.baseOffset()));
            offsetsToSnapshot.add(lastSegmentBaseOffset);
        });
        offsetsToSnapshot.add(lastOffset);
        LOG.info("{}Loading producer state till offset {}", (Object)logPrefix, (Object)lastOffset);
        if (producerStateManager.latestSnapshotOffset().isEmpty() && reloadFromCleanShutdown) {
            Iterator iterator = offsetsToSnapshot.iterator();
            while (iterator.hasNext()) {
                long offset = (Long)iterator.next();
                producerStateManager.updateMapEndOffset(offset);
                producerStateManager.takeSnapshot();
            }
        } else {
            LOG.info("{}Reloading from producer snapshot and rebuilding producer state from offset {}", (Object)logPrefix, (Object)lastOffset);
            boolean isEmptyBeforeTruncation = producerStateManager.isEmpty() && producerStateManager.mapEndOffset() >= lastOffset;
            long producerStateLoadStart = time.milliseconds();
            producerStateManager.truncateAndReload(logStartOffset, lastOffset, time.milliseconds());
            long segmentRecoveryStart = time.milliseconds();
            if (lastOffset > producerStateManager.mapEndOffset() && !isEmptyBeforeTruncation) {
                Optional<LogSegment> segmentOfLastOffset = segments.floorSegment(lastOffset);
                for (LogSegment segment : segments.values(producerStateManager.mapEndOffset(), lastOffset)) {
                    FetchDataInfo fetchDataInfo;
                    long startOffset = Utils.max((long)segment.baseOffset(), (long[])new long[]{producerStateManager.mapEndOffset(), logStartOffset});
                    producerStateManager.updateMapEndOffset(startOffset);
                    if (offsetsToSnapshot.contains(segment.baseOffset())) {
                        producerStateManager.takeSnapshot();
                    }
                    int maxPosition = segment.size();
                    if (segmentOfLastOffset.isPresent() && segmentOfLastOffset.get() == segment) {
                        FileRecords.LogOffsetPosition lop = segment.translateOffset(lastOffset);
                        int n = maxPosition = lop != null ? lop.position : segment.size();
                    }
                    if ((fetchDataInfo = segment.read(startOffset, Integer.MAX_VALUE, maxPosition)) == null) continue;
                    UnifiedLog.loadProducersFromRecords(producerStateManager, fetchDataInfo.records);
                }
            }
            producerStateManager.updateMapEndOffset(lastOffset);
            producerStateManager.takeSnapshot();
            LOG.info("{}Producer state recovery took {}ms for snapshot load and {}ms for segment recovery from offset {}", new Object[]{logPrefix, segmentRecoveryStart - producerStateLoadStart, time.milliseconds() - segmentRecoveryStart, lastOffset});
        }
    }

    public static void deleteProducerSnapshots(Collection<LogSegment> segments, ProducerStateManager producerStateManager, boolean asyncDelete, Scheduler scheduler, LogConfig config, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition) throws IOException {
        ArrayList snapshotsToDelete = new ArrayList();
        for (LogSegment segment : segments) {
            Optional<SnapshotFile> snapshotFile = producerStateManager.removeAndMarkSnapshotForDeletion(segment.baseOffset());
            snapshotFile.ifPresent(snapshotsToDelete::add);
        }
        Runnable deleteProducerSnapshots = () -> UnifiedLog.deleteProducerSnapshots(snapshotsToDelete, logDirFailureChannel, parentDir, topicPartition);
        if (asyncDelete) {
            scheduler.scheduleOnce("delete-producer-snapshot", deleteProducerSnapshots, config.fileDeleteDelayMs);
        } else {
            deleteProducerSnapshots.run();
        }
    }

    private static void deleteProducerSnapshots(List<SnapshotFile> snapshotsToDelete, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition) {
        LocalLog.maybeHandleIOException(logDirFailureChannel, parentDir, () -> "Error while deleting producer state snapshots for " + String.valueOf(topicPartition) + " in dir " + parentDir, () -> {
            for (SnapshotFile snapshotFile : snapshotsToDelete) {
                snapshotFile.deleteIfExists();
            }
            return null;
        });
    }

    private static void loadProducersFromRecords(ProducerStateManager producerStateManager, Records records) {
        HashMap loadedProducers = new HashMap();
        ArrayList completedTxns = new ArrayList();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                Optional<CompletedTxn> maybeCompletedTxn = UnifiedLog.updateProducers(producerStateManager, batch, loadedProducers, Optional.empty(), AppendOrigin.REPLICATION);
                maybeCompletedTxn.ifPresent(completedTxns::add);
            }
        });
        loadedProducers.values().forEach(producerStateManager::update);
        completedTxns.forEach(producerStateManager::completeTxn);
    }

    public static Optional<CompletedTxn> updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Long, ProducerAppendInfo> producers, Optional<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin) {
        long producerId = batch.producerId();
        ProducerAppendInfo appendInfo = producers.computeIfAbsent(producerId, __ -> producerStateManager.prepareUpdate(producerId, origin));
        Optional<CompletedTxn> completedTxn = appendInfo.append(batch, firstOffsetMetadata);
        if (batch.isTransactional()) {
            boolean isV2NextTransactionStarted;
            VerificationStateEntry entry = producerStateManager.verificationStateEntry(producerId);
            boolean bl = isV2NextTransactionStarted = entry != null && entry.supportsEpochBump() && batch.isControlBatch() && batch.producerEpoch() == entry.epoch();
            if (!isV2NextTransactionStarted) {
                producerStateManager.clearVerificationStateEntry(producerId);
            }
        }
        return completedTxn;
    }

    public static boolean isRemoteLogEnabled(boolean remoteStorageSystemEnable, LogConfig config, String topic) {
        return remoteStorageSystemEnable && !config.compact && !Topic.isInternal((String)topic) && !"__remote_log_metadata".equals(topic) && !"__cluster_metadata".equals(topic) && config.remoteStorageEnable();
    }

    public static LogValidator.MetricsRecorder newValidatorMetricsRecorder(final BrokerTopicMetrics allTopicsStats) {
        return new LogValidator.MetricsRecorder(){

            @Override
            public void recordInvalidMagic() {
                allTopicsStats.invalidMagicNumberRecordsPerSec().mark();
            }

            @Override
            public void recordInvalidOffset() {
                allTopicsStats.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            @Override
            public void recordInvalidSequence() {
                allTopicsStats.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            @Override
            public void recordInvalidChecksums() {
                allTopicsStats.invalidMessageCrcRecordsPerSec().mark();
            }

            @Override
            public void recordNoKeyCompactedTopic() {
                allTopicsStats.noKeyCompactedTopicRecordsPerSec().mark();
            }
        };
    }

    public static LeaderEpochFileCache createLeaderEpochCache(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel, Optional<LeaderEpochFileCache> currentCache, Scheduler scheduler) throws IOException {
        File leaderEpochFile = LeaderEpochCheckpointFile.newFile(dir);
        LeaderEpochCheckpointFile checkpointFile = new LeaderEpochCheckpointFile(leaderEpochFile, logDirFailureChannel);
        return currentCache.map(cache -> cache.withCheckpoint(checkpointFile)).orElse(new LeaderEpochFileCache(topicPartition, checkpointFile, scheduler));
    }

    public static LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) throws IOException {
        return LocalLog.createNewCleanedSegment(dir, logConfig, baseOffset);
    }

    public static long localRetentionMs(LogConfig config, boolean remoteLogEnabledAndRemoteCopyEnabled) {
        return remoteLogEnabledAndRemoteCopyEnabled ? config.localRetentionMs() : config.retentionMs;
    }

    public static long localRetentionSize(LogConfig config, boolean remoteLogEnabledAndRemoteCopyEnabled) {
        return remoteLogEnabledAndRemoteCopyEnabled ? config.localRetentionBytes() : config.retentionSize;
    }

    public static String logDeleteDirName(TopicPartition topicPartition) {
        return LocalLog.logDeleteDirName(topicPartition);
    }

    public static String logFutureDirName(TopicPartition topicPartition) {
        return LocalLog.logFutureDirName(topicPartition);
    }

    public static String logStrayDirName(TopicPartition topicPartition) {
        return LocalLog.logStrayDirName(topicPartition);
    }

    public static String logDirName(TopicPartition topicPartition) {
        return LocalLog.logDirName(topicPartition);
    }

    public static File transactionIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.transactionIndexFile(dir, offset, suffix);
    }

    public static long offsetFromFile(File file) {
        return LogFileUtils.offsetFromFile(file);
    }

    public static long sizeInBytes(Collection<LogSegment> segments) {
        return LogSegments.sizeInBytes(segments);
    }

    public static TopicPartition parseTopicPartitionName(File dir) throws IOException {
        return LocalLog.parseTopicPartitionName(dir);
    }

    private record AnalyzeAndValidateProducerStateResult(Map<Long, ProducerAppendInfo> updatedProducers, List<CompletedTxn> completedTxns, Optional<BatchMetadata> maybeDuplicate) {
    }

    public static interface DeletionCondition {
        public boolean execute(LogSegment var1, Optional<LogSegment> var2) throws IOException;
    }
}

